import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [emr-serverless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonemrserverless.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class EmrServerless extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [emr-serverless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonemrserverless.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel a job run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_CancelJobRun.html
     */
    toCancelJobRun(): this;
    /**
     * Grants permission to create an Application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to get application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html
     */
    toGetApplication(): this;
    /**
     * Grants permission to get job run dashboard
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetDashboardForJobRun.html
     */
    toGetDashboardForJobRun(): this;
    /**
     * Grants permission to get a job run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetJobRun.html
     */
    toGetJobRun(): this;
    /**
     * Grants permission to list applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to list job runs associated with an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_ListJobRuns.html
     */
    toListJobRuns(): this;
    /**
     * Grants permission to list tags for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to Start an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_StartApplication.html
     */
    toStartApplication(): this;
    /**
     * Grants permission to start a job run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_StartJobRun.html
     */
    toStartJobRun(): this;
    /**
     * Grants permission to Stop an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_StopApplication.html
     */
    toStopApplication(): this;
    /**
     * Grants permission to tag the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to Update an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type jobRun to the statement
     *
     * https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param jobRunId - Identifier for the jobRunId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobRun(applicationId: string, jobRunId: string, account?: string, region?: string, partition?: string): this;
}
