import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Inspector extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to assign attributes (key and value pairs) to the findings that are specified by the ARNs of the findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     */
    toAddAttributesToFindings(): this;
    /**
     * Grants permission to create a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     */
    toCreateAssessmentTarget(): this;
    /**
     * Grants permission to create an assessment template for the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     */
    toCreateAssessmentTemplate(): this;
    /**
     * Grants permission to start the generation of an exclusions preview for the specified assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateExclusionsPreview.html
     */
    toCreateExclusionsPreview(): this;
    /**
     * Grants permission to create a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     */
    toCreateResourceGroup(): this;
    /**
     * Grants permission to delete the assessment run that is specified by the ARN of the assessment run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     */
    toDeleteAssessmentRun(): this;
    /**
     * Grants permission to delete the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     */
    toDeleteAssessmentTarget(): this;
    /**
     * Grants permission to delete the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     */
    toDeleteAssessmentTemplate(): this;
    /**
     * Grants permission to describe the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     */
    toDescribeAssessmentRuns(): this;
    /**
     * Grants permission to describe the assessment targets that are specified by the ARNs of the assessment targets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     */
    toDescribeAssessmentTargets(): this;
    /**
     * Grants permission to describe the assessment templates that are specified by the ARNs of the assessment templates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     */
    toDescribeAssessmentTemplates(): this;
    /**
     * Grants permission to describe the IAM role that enables Amazon Inspector to access your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     */
    toDescribeCrossAccountAccessRole(): this;
    /**
     * Grants permission to describe the exclusions that are specified by the exclusions' ARNs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeExclusions.html
     */
    toDescribeExclusions(): this;
    /**
     * Grants permission to describe the findings that are specified by the ARNs of the findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     */
    toDescribeFindings(): this;
    /**
     * Grants permission to describe the resource groups that are specified by the ARNs of the resource groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     */
    toDescribeResourceGroups(): this;
    /**
     * Grants permission to describe the rules packages that are specified by the ARNs of the rules packages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     */
    toDescribeRulesPackages(): this;
    /**
     * Grants permission to produce an assessment report that includes detailed and comprehensive results of a specified assessment run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetAssessmentReport.html
     */
    toGetAssessmentReport(): this;
    /**
     * Grants permission to retrieve the exclusions preview (a list of ExclusionPreview objects) specified by the preview token
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetExclusionsPreview.html
     */
    toGetExclusionsPreview(): this;
    /**
     * Grants permission to get information about the data that is collected for the specified assessment run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     */
    toGetTelemetryMetadata(): this;
    /**
     * Grants permission to list the agents of the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     */
    toListAssessmentRunAgents(): this;
    /**
     * Grants permission to list the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     */
    toListAssessmentRuns(): this;
    /**
     * Grants permission to list the ARNs of the assessment targets within this AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     */
    toListAssessmentTargets(): this;
    /**
     * Grants permission to list the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     */
    toListAssessmentTemplates(): this;
    /**
     * Grants permission to list all the event subscriptions for the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     */
    toListEventSubscriptions(): this;
    /**
     * Grants permission to list exclusions that are generated by the assessment run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListExclusions.html
     */
    toListExclusions(): this;
    /**
     * Grants permission to list findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     */
    toListFindings(): this;
    /**
     * Grants permission to list all available Amazon Inspector rules packages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     */
    toListRulesPackages(): this;
    /**
     * Grants permission to list all tags associated with an assessment template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to preview the agents installed on the EC2 instances that are part of the specified assessment target
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     */
    toPreviewAgents(): this;
    /**
     * Grants permission to register the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     */
    toRegisterCrossAccountAccessRole(): this;
    /**
     * Grants permission to remove entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     */
    toRemoveAttributesFromFindings(): this;
    /**
     * Grants permission to set tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     */
    toSetTagsForResource(): this;
    /**
     * Grants permission to start the assessment run specified by the ARN of the assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     */
    toStartAssessmentRun(): this;
    /**
     * Grants permission to stop the assessment run that is specified by the ARN of the assessment run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     */
    toStopAssessmentRun(): this;
    /**
     * Grants permission to enable the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     */
    toSubscribeToEvent(): this;
    /**
     * Grants permission to disable the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     */
    toUnsubscribeFromEvent(): this;
    /**
     * Grants permission to update the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     */
    toUpdateAssessmentTarget(): this;
    protected accessLevelList: AccessLevelList;
}
