"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iottwinmaker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iottwinmaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiottwinmaker.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iottwinmaker extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iottwinmaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiottwinmaker.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iottwinmaker';
        this.accessLevelList = {
            Write: [
                'BatchPutPropertyValues',
                'CreateComponentType',
                'CreateEntity',
                'CreateScene',
                'CreateSyncJob',
                'CreateWorkspace',
                'DeleteComponentType',
                'DeleteEntity',
                'DeleteScene',
                'DeleteSyncJob',
                'DeleteWorkspace',
                'UpdateComponentType',
                'UpdateEntity',
                'UpdatePricingPlan',
                'UpdateScene',
                'UpdateWorkspace'
            ],
            Read: [
                'ExecuteQuery',
                'GetComponentType',
                'GetEntity',
                'GetPricingPlan',
                'GetPropertyValue',
                'GetPropertyValueHistory',
                'GetScene',
                'GetSyncJob',
                'GetWorkspace'
            ],
            List: [
                'ListComponentTypes',
                'ListEntities',
                'ListScenes',
                'ListSyncJobs',
                'ListSyncResources',
                'ListTagsForResource',
                'ListWorkspaces'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to set values for multiple time series properties
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iottwinmaker:GetComponentType
     * - iottwinmaker:GetEntity
     * - iottwinmaker:GetWorkspace
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_BatchPutPropertyValues.html
     */
    toBatchPutPropertyValues() {
        return this.to('BatchPutPropertyValues');
    }
    /**
     * Grants permission to create a componentType
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateComponentType.html
     */
    toCreateComponentType() {
        return this.to('CreateComponentType');
    }
    /**
     * Grants permission to create an entity
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateEntity.html
     */
    toCreateEntity() {
        return this.to('CreateEntity');
    }
    /**
     * Grants permission to create a scene
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateScene.html
     */
    toCreateScene() {
        return this.to('CreateScene');
    }
    /**
     * Grants permission to create a sync job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateSyncJob.html
     */
    toCreateSyncJob() {
        return this.to('CreateSyncJob');
    }
    /**
     * Grants permission to create a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateWorkspace.html
     */
    toCreateWorkspace() {
        return this.to('CreateWorkspace');
    }
    /**
     * Grants permission to delete a componentType
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteComponentType.html
     */
    toDeleteComponentType() {
        return this.to('DeleteComponentType');
    }
    /**
     * Grants permission to delete an entity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteEntity.html
     */
    toDeleteEntity() {
        return this.to('DeleteEntity');
    }
    /**
     * Grants permission to delete a scene
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteScene.html
     */
    toDeleteScene() {
        return this.to('DeleteScene');
    }
    /**
     * Grants permission to delete a sync job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteSyncJob.html
     */
    toDeleteSyncJob() {
        return this.to('DeleteSyncJob');
    }
    /**
     * Grants permission to delete a workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteWorkspace.html
     */
    toDeleteWorkspace() {
        return this.to('DeleteWorkspace');
    }
    /**
     * Grants permission to execute query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ExecuteQuery.html
     */
    toExecuteQuery() {
        return this.to('ExecuteQuery');
    }
    /**
     * Grants permission to get a componentType
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetComponentType.html
     */
    toGetComponentType() {
        return this.to('GetComponentType');
    }
    /**
     * Grants permission to get an entity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetEntity.html
     */
    toGetEntity() {
        return this.to('GetEntity');
    }
    /**
     * Grants permission to get pricing plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetPricingPlan.html
     */
    toGetPricingPlan() {
        return this.to('GetPricingPlan');
    }
    /**
     * Grants permission to retrieve the property values
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - iottwinmaker:GetComponentType
     * - iottwinmaker:GetEntity
     * - iottwinmaker:GetWorkspace
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetPropertyValue.html
     */
    toGetPropertyValue() {
        return this.to('GetPropertyValue');
    }
    /**
     * Grants permission to retrieve the time series value history
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - iottwinmaker:GetComponentType
     * - iottwinmaker:GetEntity
     * - iottwinmaker:GetWorkspace
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetPropertyValueHistory.html
     */
    toGetPropertyValueHistory() {
        return this.to('GetPropertyValueHistory');
    }
    /**
     * Grants permission to get a scene
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetScene.html
     */
    toGetScene() {
        return this.to('GetScene');
    }
    /**
     * Grants permission to get a sync job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetSyncJob.html
     */
    toGetSyncJob() {
        return this.to('GetSyncJob');
    }
    /**
     * Grants permission to get a workspace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetWorkspace.html
     */
    toGetWorkspace() {
        return this.to('GetWorkspace');
    }
    /**
     * Grants permission to list all componentTypes in a workspace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListComponentTypes.html
     */
    toListComponentTypes() {
        return this.to('ListComponentTypes');
    }
    /**
     * Grants permission to list all entities in a workspace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListEntities.html
     */
    toListEntities() {
        return this.to('ListEntities');
    }
    /**
     * Grants permission to list all scenes in a workspace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListScenes.html
     */
    toListScenes() {
        return this.to('ListScenes');
    }
    /**
     * Grants permission to list all sync jobs in a workspace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListSyncJobs.html
     */
    toListSyncJobs() {
        return this.to('ListSyncJobs');
    }
    /**
     * Grants permission to list all sync resources for a sync job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListSyncResources.html
     */
    toListSyncResources() {
        return this.to('ListSyncResources');
    }
    /**
     * Grants permission to list all tags for a resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list all workspaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListWorkspaces.html
     */
    toListWorkspaces() {
        return this.to('ListWorkspaces');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a componentType
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateComponentType.html
     */
    toUpdateComponentType() {
        return this.to('UpdateComponentType');
    }
    /**
     * Grants permission to update an entity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateEntity.html
     */
    toUpdateEntity() {
        return this.to('UpdateEntity');
    }
    /**
     * Grants permission to update pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdatePricingPlan.html
     */
    toUpdatePricingPlan() {
        return this.to('UpdatePricingPlan');
    }
    /**
     * Grants permission to update a scene
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateScene.html
     */
    toUpdateScene() {
        return this.to('UpdateScene');
    }
    /**
     * Grants permission to update a workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateWorkspace.html
     */
    toUpdateWorkspace() {
        return this.to('UpdateWorkspace');
    }
    /**
     * Adds a resource of type workspace to the statement
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateWorkspace.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspace(workspaceId, account, region, partition) {
        return this.on(`arn:${partition || Iottwinmaker.defaultPartition}:iottwinmaker:${region || '*'}:${account || '*'}:workspace/${workspaceId}`);
    }
    /**
     * Adds a resource of type entity to the statement
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateEntity.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param entityId - Identifier for the entityId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEntity(workspaceId, entityId, account, region, partition) {
        return this.on(`arn:${partition || Iottwinmaker.defaultPartition}:iottwinmaker:${region || '*'}:${account || '*'}:workspace/${workspaceId}/entity/${entityId}`);
    }
    /**
     * Adds a resource of type componentType to the statement
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateComponentType.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param componentTypeId - Identifier for the componentTypeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onComponentType(workspaceId, componentTypeId, account, region, partition) {
        return this.on(`arn:${partition || Iottwinmaker.defaultPartition}:iottwinmaker:${region || '*'}:${account || '*'}:workspace/${workspaceId}/component-type/${componentTypeId}`);
    }
    /**
     * Adds a resource of type scene to the statement
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateScene.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param sceneId - Identifier for the sceneId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScene(workspaceId, sceneId, account, region, partition) {
        return this.on(`arn:${partition || Iottwinmaker.defaultPartition}:iottwinmaker:${region || '*'}:${account || '*'}:workspace/${workspaceId}/scene/${sceneId}`);
    }
    /**
     * Adds a resource of type syncJob to the statement
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateSyncJob.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param syncJobId - Identifier for the syncJobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSyncJob(workspaceId, syncJobId, account, region, partition) {
        return this.on(`arn:${partition || Iottwinmaker.defaultPartition}:iottwinmaker:${region || '*'}:${account || '*'}:workspace/${workspaceId}/sync-job/${syncJobId}`);
    }
}
exports.Iottwinmaker = Iottwinmaker;
_a = JSII_RTTI_SYMBOL_1;
Iottwinmaker[_a] = { fqn: "iam-floyd.Iottwinmaker", version: "0.490.0" };
//# sourceMappingURL=data:application/json;base64,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