import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Geo extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an association between a geofence-collection and a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_AssociateTrackerConsumer.html
     */
    toAssociateTrackerConsumer(): this;
    /**
     * Grants permission to delete a batch of device position histories from a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchDeleteDevicePositionHistory.html
     */
    toBatchDeleteDevicePositionHistory(): this;
    /**
     * Grants permission to delete a batch of geofences from a geofence collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchDeleteGeofence.html
     */
    toBatchDeleteGeofence(): this;
    /**
     * Grants permission to evaluate device positions against the position of geofences in a given geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchEvaluateGeofences.html
     */
    toBatchEvaluateGeofences(): this;
    /**
     * Grants permission to send a batch request to retrieve device positions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchGetDevicePosition.html
     */
    toBatchGetDevicePosition(): this;
    /**
     * Grants permission to send a batch request for adding geofences into a given geofence collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchPutGeofence.html
     */
    toBatchPutGeofence(): this;
    /**
     * Grants permission to upload a position update for one or more devices to a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchUpdateDevicePosition.html
     */
    toBatchUpdateDevicePosition(): this;
    /**
     * Grants permission to calculate routes using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRoute.html
     */
    toCalculateRoute(): this;
    /**
     * Grants permission to calculate a route matrix using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRouteMatrix.html
     */
    toCalculateRouteMatrix(): this;
    /**
     * Grants permission to create a geofence-collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateGeofenceCollection.html
     */
    toCreateGeofenceCollection(): this;
    /**
     * Grants permission to create an API key resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateKey.html
     */
    toCreateKey(): this;
    /**
     * Grants permission to create a map resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateMap.html
     */
    toCreateMap(): this;
    /**
     * Grants permission to create a place index resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreatePlaceIndex.html
     */
    toCreatePlaceIndex(): this;
    /**
     * Grants permission to create a route calculator resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateRouteCalculator.html
     */
    toCreateRouteCalculator(): this;
    /**
     * Grants permission to create a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateTracker.html
     */
    toCreateTracker(): this;
    /**
     * Grants permission to delete a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteGeofenceCollection.html
     */
    toDeleteGeofenceCollection(): this;
    /**
     * Grants permission to delete an API key resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteKey.html
     */
    toDeleteKey(): this;
    /**
     * Grants permission to delete a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteMap.html
     */
    toDeleteMap(): this;
    /**
     * Grants permission to delete a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeletePlaceIndex.html
     */
    toDeletePlaceIndex(): this;
    /**
     * Grants permission to delete a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteRouteCalculator.html
     */
    toDeleteRouteCalculator(): this;
    /**
     * Grants permission to delete a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteTracker.html
     */
    toDeleteTracker(): this;
    /**
     * Grants permission to retrieve geofence collection details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeGeofenceCollection.html
     */
    toDescribeGeofenceCollection(): this;
    /**
     * Grants permission to retrieve API key resource details and secret
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeKey.html
     */
    toDescribeKey(): this;
    /**
     * Grants permission to retrieve map resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeMap.html
     */
    toDescribeMap(): this;
    /**
     * Grants permission to retrieve place-index resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribePlaceIndex.html
     */
    toDescribePlaceIndex(): this;
    /**
     * Grants permission to retrieve route calculator resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeRouteCalculator.html
     */
    toDescribeRouteCalculator(): this;
    /**
     * Grants permission to retrieve a tracker resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeTracker.html
     */
    toDescribeTracker(): this;
    /**
     * Grants permission to remove the association between a tracker resource and a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DisassociateTrackerConsumer.html
     */
    toDisassociateTrackerConsumer(): this;
    /**
     * Grants permission to retrieve the latest device position
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetDevicePosition.html
     */
    toGetDevicePosition(): this;
    /**
     * Grants permission to retrieve the device position history
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetDevicePositionHistory.html
     */
    toGetDevicePositionHistory(): this;
    /**
     * Grants permission to retrieve the geofence details from a geofence-collection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetGeofence.html
     */
    toGetGeofence(): this;
    /**
     * Grants permission to retrieve the glyph file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html
     */
    toGetMapGlyphs(): this;
    /**
     * Grants permission to retrieve the sprite file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapSprites.html
     */
    toGetMapSprites(): this;
    /**
     * Grants permission to retrieve the map style descriptor from a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapStyleDescriptor.html
     */
    toGetMapStyleDescriptor(): this;
    /**
     * Grants permission to retrieve the map tile from the map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapTile.html
     */
    toGetMapTile(): this;
    /**
     * Grants permission to find a place by its unique ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetPlace.html
     */
    toGetPlace(): this;
    /**
     * Grants permission to retrieve a list of devices and their latest positions from the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListDevicePositions.html
     */
    toListDevicePositions(): this;
    /**
     * Grants permission to lists geofence-collections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListGeofenceCollections.html
     */
    toListGeofenceCollections(): this;
    /**
     * Grants permission to list geofences stored in a given geofence collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListGeofences.html
     */
    toListGeofences(): this;
    /**
     * Grants permission to list API key resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListKeys.html
     */
    toListKeys(): this;
    /**
     * Grants permission to list map resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListMaps.html
     */
    toListMaps(): this;
    /**
     * Grants permission to return a list of place index resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListPlaceIndexes.html
     */
    toListPlaceIndexes(): this;
    /**
     * Grants permission to return a list of route calculator resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListRouteCalculators.html
     */
    toListRouteCalculators(): this;
    /**
     * Grants permission to list the tags (metadata) which you have assigned to the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve a list of geofence collections currently associated to the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListTrackerConsumers.html
     */
    toListTrackerConsumers(): this;
    /**
     * Grants permission to return a list of tracker resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListTrackers.html
     */
    toListTrackers(): this;
    /**
     * Grants permission to add a new geofence or update an existing geofence to a given geofence-collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_PutGeofence.html
     */
    toPutGeofence(): this;
    /**
     * Grants permission to reverse geocodes a given coordinate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SearchPlaceIndexForPosition.html
     */
    toSearchPlaceIndexForPosition(): this;
    /**
     * Grants permission to generate suggestions for addresses and points of interest based on partial or misspelled free-form text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SearchPlaceIndexForSuggestions.html
     */
    toSearchPlaceIndexForSuggestions(): this;
    /**
     * Grants permission to geocode free-form text, such as an address, name, city or region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SearchPlaceIndexForText.html
     */
    toSearchPlaceIndexForText(): this;
    /**
     * Grants permission to adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the given tags (metadata) from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateGeofenceCollection.html
     */
    toUpdateGeofenceCollection(): this;
    /**
     * Grants permission to update an API key resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateKey.html
     */
    toUpdateKey(): this;
    /**
     * Grants permission to update a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateMap.html
     */
    toUpdateMap(): this;
    /**
     * Grants permission to update a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdatePlaceIndex.html
     */
    toUpdatePlaceIndex(): this;
    /**
     * Grants permission to update a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateRouteCalculator.html
     */
    toUpdateRouteCalculator(): this;
    /**
     * Grants permission to update a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateTracker.html
     */
    toUpdateTracker(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type api-key to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html
     *
     * @param keyName - Identifier for the keyName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApiKey(keyName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type geofence-collection to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html
     *
     * @param geofenceCollectionName - Identifier for the geofenceCollectionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifGeofenceIds()
     */
    onGeofenceCollection(geofenceCollectionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type map to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html
     *
     * @param mapName - Identifier for the mapName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMap(mapName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type place-index to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/places-concepts.html
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaceIndex(indexName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type route-calculator to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/route-concepts.html
     *
     * @param calculatorName - Identifier for the calculatorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRouteCalculator(calculatorName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type tracker to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html
     *
     * @param trackerName - Identifier for the trackerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifDeviceIds()
     */
    onTracker(trackerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of device ids in the request
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toBatchDeleteDevicePositionHistory()
     * - .toBatchGetDevicePosition()
     * - .toBatchUpdateDevicePosition()
     * - .toGetDevicePosition()
     * - .toGetDevicePositionHistory()
     *
     * Applies to resource types:
     * - tracker
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDeviceIds(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of geofence ids in the request
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toBatchDeleteGeofence()
     * - .toBatchPutGeofence()
     * - .toGetGeofence()
     * - .toPutGeofence()
     *
     * Applies to resource types:
     * - geofence-collection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifGeofenceIds(value: string | string[], operator?: Operator | string): this;
}
