"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tnb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [tnb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstelconetworkbuilder.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Tnb extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [tnb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstelconetworkbuilder.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'tnb';
        this.accessLevelList = {
            Write: [
                'CancelSolNetworkOperation',
                'CreateSolFunctionPackage',
                'CreateSolNetworkInstance',
                'CreateSolNetworkPackage',
                'DeleteSolFunctionPackage',
                'DeleteSolNetworkInstance',
                'DeleteSolNetworkPackage',
                'InstantiateSolNetworkInstance',
                'PutSolFunctionPackageContent',
                'PutSolNetworkPackageContent',
                'TerminateSolNetworkInstance',
                'UpdateSolFunctionPackage',
                'UpdateSolNetworkInstance',
                'UpdateSolNetworkPackage',
                'ValidateSolFunctionPackageContent',
                'ValidateSolNetworkPackageContent'
            ],
            Read: [
                'GetSolFunctionInstance',
                'GetSolFunctionPackage',
                'GetSolFunctionPackageContent',
                'GetSolFunctionPackageDescriptor',
                'GetSolNetworkInstance',
                'GetSolNetworkOperation',
                'GetSolNetworkPackage',
                'GetSolNetworkPackageContent',
                'GetSolNetworkPackageDescriptor'
            ],
            List: [
                'ListSolFunctionInstances',
                'ListSolFunctionPackages',
                'ListSolNetworkInstances',
                'ListSolNetworkOperations',
                'ListSolNetworkPackages',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to cancel a network operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CancelSolNetworkOperation.html
     */
    toCancelSolNetworkOperation() {
        return this.to('CancelSolNetworkOperation');
    }
    /**
     * Grants permission to create a function package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolFunctionPackage.html
     */
    toCreateSolFunctionPackage() {
        return this.to('CreateSolFunctionPackage');
    }
    /**
     * Grants permission to create a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html
     */
    toCreateSolNetworkInstance() {
        return this.to('CreateSolNetworkInstance');
    }
    /**
     * Grants permission to create a network package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkPackage.html
     */
    toCreateSolNetworkPackage() {
        return this.to('CreateSolNetworkPackage');
    }
    /**
     * Grants permission to delete a function package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_DeleteSolFunctionPackage.html
     */
    toDeleteSolFunctionPackage() {
        return this.to('DeleteSolFunctionPackage');
    }
    /**
     * Grants permission to delete a network instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_DeleteSolNetworkInstance.html
     */
    toDeleteSolNetworkInstance() {
        return this.to('DeleteSolNetworkInstance');
    }
    /**
     * Grants permission to delete a network package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_DeleteSolNetworkPackage.html
     */
    toDeleteSolNetworkPackage() {
        return this.to('DeleteSolNetworkPackage');
    }
    /**
     * Grants permission to get a function instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionInstance.html
     */
    toGetSolFunctionInstance() {
        return this.to('GetSolFunctionInstance');
    }
    /**
     * Grants permission to get a function package
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionPackage.html
     */
    toGetSolFunctionPackage() {
        return this.to('GetSolFunctionPackage');
    }
    /**
     * Grants permission to get a function package contents
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionPackageContent.html
     */
    toGetSolFunctionPackageContent() {
        return this.to('GetSolFunctionPackageContent');
    }
    /**
     * Grants permission to get a function package descriptor
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionPackageDescriptor.html
     */
    toGetSolFunctionPackageDescriptor() {
        return this.to('GetSolFunctionPackageDescriptor');
    }
    /**
     * Grants permission to get a network instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkInstance.html
     */
    toGetSolNetworkInstance() {
        return this.to('GetSolNetworkInstance');
    }
    /**
     * Grants permission to get a network operation
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkOperation.html
     */
    toGetSolNetworkOperation() {
        return this.to('GetSolNetworkOperation');
    }
    /**
     * Grants permission to get a network package
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkPackage.html
     */
    toGetSolNetworkPackage() {
        return this.to('GetSolNetworkPackage');
    }
    /**
     * Grants permission to get a network package contents
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkPackageContent.html
     */
    toGetSolNetworkPackageContent() {
        return this.to('GetSolNetworkPackageContent');
    }
    /**
     * Grants permission to get a network package descriptor
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkPackageDescriptor.html
     */
    toGetSolNetworkPackageDescriptor() {
        return this.to('GetSolNetworkPackageDescriptor');
    }
    /**
     * Grants permission to instantiate a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html
     */
    toInstantiateSolNetworkInstance() {
        return this.to('InstantiateSolNetworkInstance');
    }
    /**
     * Grants permission to list function instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolFunctionInstances.html
     */
    toListSolFunctionInstances() {
        return this.to('ListSolFunctionInstances');
    }
    /**
     * Grants permission to list function packages
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolFunctionPackages.html
     */
    toListSolFunctionPackages() {
        return this.to('ListSolFunctionPackages');
    }
    /**
     * Grants permission to list network instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolNetworkInstances.html
     */
    toListSolNetworkInstances() {
        return this.to('ListSolNetworkInstances');
    }
    /**
     * Grants permission to list network operations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolNetworkOperations.html
     */
    toListSolNetworkOperations() {
        return this.to('ListSolNetworkOperations');
    }
    /**
     * Grants permission to list network packages
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolNetworkPackages.html
     */
    toListSolNetworkPackages() {
        return this.to('ListSolNetworkPackages');
    }
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to upload function package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html
     */
    toPutSolFunctionPackageContent() {
        return this.to('PutSolFunctionPackageContent');
    }
    /**
     * Grants permission to upload network package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html
     */
    toPutSolNetworkPackageContent() {
        return this.to('PutSolNetworkPackageContent');
    }
    /**
     * Grants permission to add tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html
     */
    toTerminateSolNetworkInstance() {
        return this.to('TerminateSolNetworkInstance');
    }
    /**
     * Grants permission to remove tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a function package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html
     */
    toUpdateSolFunctionPackage() {
        return this.to('UpdateSolFunctionPackage');
    }
    /**
     * Grants permission to update a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkInstance.html
     */
    toUpdateSolNetworkInstance() {
        return this.to('UpdateSolNetworkInstance');
    }
    /**
     * Grants permission to update a network package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html
     */
    toUpdateSolNetworkPackage() {
        return this.to('UpdateSolNetworkPackage');
    }
    /**
     * Grants permission to validate function package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ValidateSolFunctionPackageContent.html
     */
    toValidateSolFunctionPackageContent() {
        return this.to('ValidateSolFunctionPackageContent');
    }
    /**
     * Grants permission to validate network package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ValidateSolNetworkPackageContent.html
     */
    toValidateSolNetworkPackageContent() {
        return this.to('ValidateSolNetworkPackageContent');
    }
    /**
     * Adds a resource of type function-package to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html
     *
     * @param functionPackageId - Identifier for the functionPackageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFunctionPackage(functionPackageId, account, region, partition) {
        return this.on(`arn:${partition || Tnb.defaultPartition}:tnb:${region || '*'}:${account || '*'}:function-package/${functionPackageId}`);
    }
    /**
     * Adds a resource of type network-package to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/network-packages.html
     *
     * @param networkPackageId - Identifier for the networkPackageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkPackage(networkPackageId, account, region, partition) {
        return this.on(`arn:${partition || Tnb.defaultPartition}:tnb:${region || '*'}:${account || '*'}:network-package/${networkPackageId}`);
    }
    /**
     * Adds a resource of type network-instance to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html
     *
     * @param networkInstanceId - Identifier for the networkInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkInstance(networkInstanceId, account, region, partition) {
        return this.on(`arn:${partition || Tnb.defaultPartition}:tnb:${region || '*'}:${account || '*'}:network-instance/${networkInstanceId}`);
    }
    /**
     * Adds a resource of type function-instance to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html
     *
     * @param functionInstanceId - Identifier for the functionInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFunctionInstance(functionInstanceId, account, region, partition) {
        return this.on(`arn:${partition || Tnb.defaultPartition}:tnb:${region || '*'}:${account || '*'}:function-instance/${functionInstanceId}`);
    }
    /**
     * Adds a resource of type network-operation to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/network-operations.html
     *
     * @param networkOperationId - Identifier for the networkOperationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkOperation(networkOperationId, account, region, partition) {
        return this.on(`arn:${partition || Tnb.defaultPartition}:tnb:${region || '*'}:${account || '*'}:network-operation/${networkOperationId}`);
    }
}
exports.Tnb = Tnb;
_a = JSII_RTTI_SYMBOL_1;
Tnb[_a] = { fqn: "iam-floyd.Tnb", version: "0.490.0" };
//# sourceMappingURL=data:application/json;base64,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