# CoreDotFinance
### Powerful Python financial data library
[![GitHup issues](https://img.shields.io/github/issues/CoreDotToday/CoreDotFinance)](https://github.com/CoreDotToday/CoreDotFinance/issues)
[![GitHub pull requests](https://img.shields.io/github/issues-pr/CoreDotToday/CoreDotFinance)](https://github.com/CoreDotToday/CoreDotFinance/pulls)
[![PyPI Latest Release](https://img.shields.io/static/v1?label=PyPI&message=0.0.1&color=orange)](https://pypi.org/project/coredotfinance/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)
----------------------------

## 금융 데이터를 쉽고 빠르게!
**CoreDotFinance**는 [KRX](https://www.data.krx.co.kr)의 주식데이터 [Binance](https://www.binance.com)와의 가상화폐 데이터를 
쉽고 빠르게 파이썬 작업 환경에서 작업할 수 있도록 도와주는 파이썬 라이러리입니다. 

## 설치 방법
```sh
pip install coredotfinance
```

## 문서
공식문서 : [https://coredottoday.github.io/CoreDotFinance/](https://coredottoday.github.io/CoreDotFinance/)


## 사용법
 -  krx 데이터 불러오기
 -  binance 데이터 불러오기

### krx에서 데이터 불러오기
### 1. 주식
#### 1-1. 주식 데이터 불러오기
```python
In [22]:
from coredotfinance.data import KrxReader
krx = KrxReader()
krx.read('005930', start='2021-06-16', end='2021-06-22')

Out[2]:
삼성전자
종가	대비	등락률	시가	고가	저가	거래량	거래대금	시가총액	상장주식수
2021-06-22	80000	100	0.13	80200	80300	79900	11773365	942656966106	477582604000000	5969782550
2021-06-21	79900	-600	-0.75	79700	80000	79600	16063340	1282081340900	476985625745000	5969782550
2021-06-18	80500	-400	-0.49	81100	81100	80500	14916721	1202369230300	480567495275000	5969782550
2021-06-17	80900	-900	-1.10	81100	81300	80700	14007385	1132293020100	482955408295000	5969782550
2021-06-16	81800	900	1.11	81500	81900	81100	14999855	1223108169181	488328212590000	5969782550

```
#### 1-2. 해당일 모든 주식 데이터 불러오기
```python
In [3]:
krx.read_all(date='2021-06-22').head()

Out[3]:
종목코드	종목명	시장구분	소속부	종가	대비	등락률	시가	고가	저가	거래량	거래대금	시가총액	상장주식수
0	060310	3S	KOSDAQ	중견기업부	3260	-20	-0.61	3310	3310	3205	262244	848117815	150845132380	46271513
1	095570	AJ네트웍스	KOSPI		6010	-100	-1.64	6100	6100	5970	143696	863763320	281401992950	46822295
2	006840	AK홀딩스	KOSPI		33250	500	1.53	33000	33450	32800	24751	819795450	440481403250	13247561
3	054620	APS홀딩스	KOSDAQ	중견기업부	17150	900	5.54	16350	17350	16000	279681	4707799300	349760890150	20394221
4	265520	AP시스템	KOSDAQ	우량기업부	34100	600	1.79	33800	34200	33100	959984	32312463800	493775740700	14480227

```
#### 1-3. EPS/PER/BPS/PBR/주당배당금/배당수익률 데이터 불러오기
```python

In [4]:
krx.read('005930', kind='per', start='2021-06-16', end='2021-06-22')

Out[4]:
삼성전자
종가	대비	등락률	EPS	PER	BPS	PBR	주당배당금	배당수익률
2021-06-22	80000	100	0.13	3841	20.83	39406	2.03	2994	3.74
2021-06-21	79900	-600	-0.75	3841	20.80	39406	2.03	2994	3.75
2021-06-18	80500	-400	-0.49	3841	20.96	39406	2.04	2994	3.72
2021-06-17	80900	-900	-1.10	3841	21.06	39406	2.05	2994	3.70
2021-06-16	81800	900	1.11	3841	21.30	39406	2.08	2994	3.66

```
#### 1-4. 해당일 모든 EPS/PER/BPS/PBR/주당배당금/배당수익률 데이터 불러오기
```python

In [5]:
krx.read_all(date='2021-06-22', kind='per').head()

Out[5]:
종목코드	종목명	종가	대비	등락률	EPS	PER	BPS	PBR	주당배당금	배당수익률
0	060310	3S	3260	-20	-0.61	0	0.00	745	4.38	0	0.00
1	095570	AJ네트웍스	6010	-100	-1.64	0	0.00	6089	0.99	210	3.49
2	006840	AK홀딩스	33250	500	1.53	0	0.00	50471	0.66	400	1.20
3	054620	APS홀딩스	17150	900	5.54	0	0.00	8135	2.11	0	0.00
4	265520	AP시스템	34100	600	1.79	1736	19.64	9041	3.77	120	0.35

```
### 2. ETF
#### 2-1. ETF 데이터 불러오기
```python

In [6]:
krx.read('152100', start='2021-06-16', end='2021-06-22', kind='etf')

Out[6]:
ARIRANG 200
종가	대비	등락률	순자산가치(NAV)	시가	고가	저가	거래량	거래대금	시가총액	순자산총액	상장좌수	기초지수
                                                                                                                                    지수명	종가	대비	등락률
2021-06-22	43745	290	0.67	43861.26	43695	43810	43645	42959	1879340220	861776500000	864066878141	19700000	코스피 200	434.42	2.96	0.69
2021-06-21	43455	420	-0.96	43563.54	43565	43600	43265	38641	1677991085	860409000000	858201745592	19800000	코스피 200	431.46	3.56	-0.82
2021-06-18	43875	110	0.25	43923.01	43785	43970	43765	42819	1880091335	829237500000	869675659899	18900000	코스피 200	435.02	0.29	0.07
2021-06-17	43765	230	-0.52	43893.56	43800	43825	43600	13435	587449695	827158500000	829588218252	18900000	코스피 200	434.73	2.23	-0.51
2021-06-16	43995	235	0.54	44121.21	43760	44050	43760	106684	4693974037	831505500000	833890893930	18900000	코스피 200	436.96	2.83	0.65

```
#### 2-2. 해당일 모든 ETF 불러오기
```python

In [7]:
krx.read_all(date='2021-06-22', kind='etf').head()

Out[7]:
종목코드	종목명	종가	대비	등락률	순자산가치(NAV)	시가	고가	저가	거래량	거래대금	시가총액	순자산총액	상장좌수	기초지수
                                                                                                                                                지수명	종가	대비	등락률
0	152100	ARIRANG 200	43745	290	0.67	43861.26	43695	43810	43645	42959	1879340220	861776500000	864066878141	19700000	코스피 200	434.42	2.96	0.69
1	295820	ARIRANG 200동일가중	12275	180	1.49	12257.85	12115	12275	12115	248	3033510	15343750000	15322313321	1250000	코스피 200 동일가중지수	2681.00	32.76	1.24
2	253150	ARIRANG 200선물레버리지	51960	720	1.41	51970.87	51800	52075	51650	1023	53030520	15588000000	12992717266	300000	코스피 200 선물지수	2173.41	15.30	0.71
3	253160	ARIRANG 200선물인버스2X	3805	-50	-1.30	3796.80	3830	3830	3780	18559	70532780	14839500000	14617674812	3900000	코스피 200 선물지수	2173.41	15.30	0.71
4	278420	ARIRANG ESG우수기업	9885	100	1.02	9895.12	9860	9900	9845	649	6413000	3954000000	3958047397	400000	WISE ESG우수기업 지수	1383.67	13.12	0.96

```
### 3. ETN
### 3-1. ETN 데이터 불러오기
```python

In [8]:
krx.read('580011', start='2021-06-16', end='2021-06-22', kind='etn')

Out[8]:
KB FnGuide 언택트 ETN
종가	대비	등락률	지표가치(IV)	시가	고가	저가	거래량	거래대금	시가총액	지표가치총액	상장증권수	기초지수
                                                                                                                                지수명	종가	대비	등락률
2021-06-22	14910	65	0.44	14909.11	0	0	0	0	0	14910000000	14909110000	1000000	FnGuide 언택트 지수	2977.49	13.08	0.44
2021-06-21	14845	-65	-0.44	14843.94	14880	14955	14845	360	5378360	14845000000	14843940000	1000000	FnGuide 언택트 지수	2964.41	10.45	-0.35
2021-06-18	14910	340	2.33	14896.59	0	0	0	0	0	14910000000	14896590000	1000000	FnGuide 언택트 지수	2974.86	67.45	2.32
2021-06-17	14570	120	0.83	14559.79	14490	14610	14490	34	492955	14570000000	14559790000	1000000	FnGuide 언택트 지수	2907.41	10.82	0.37
2021-06-16	14450	-45	-0.31	14505.92	14495	14495	14450	33	476985	14450000000	14505920000	1000000	FnGuide 언택트 지수	2896.59	0.82	0.03

```
### 3-2. 해당일 모든 ETN 데이터 불러오기
```python

In [9]:
krx.read_all(date='2021-06-22', kind='etn').head()

Out[9]:
종목코드	종목명	종가	대비	등락률	지표가치(IV)	시가	고가	저가	거래량	거래대금	시가총액	지표가치총액	상장증권수	기초지수
                                                                                                                                                   지수명	종가	대비	등락률
0	580011	KB FnGuide 언택트 ETN	14910	65	0.44	14909.11	0	0	0	0	0	14910000000	14909110000	1000000	FnGuide 언택트 지수	2977.49	13.08	0.44
1	580013	KB KRX ESG Eco ETN	13800	175	1.28	13789.72	0	0	0	0	0	13800000000	13789720000	1000000	KRX Eco Leaders 100	2396.69	31.77	1.34
2	580012	KB KRX300 ETN	13295	55	0.42	13286.96	13295	13295	13295	16	212720	13295000000	13286960000	1000000	KRX 300	1964.83	11.12	0.57
3	580010	KB Wise 분할매매 ETN	11900	0	0.00	11900.20	11900	11900	11900	169	2011100	71400000000	71401200000	6000000	Wise 분할매매 5%/1% 6M 지수	1634.40	0.03	0.00
4	580016	KB 레버리지 S&P 500 선물 ETN(H)	10520	370	3.65	10479.43	10495	10520	10495	10700	111279365	10520000000	10479430000	1000000	S&P 500 Futures 2X Leveraged Daily Index TR	926.00	9.78	1.07

```
### 4. ELW
#### 4-1. ELW 데이터 불러오기
```python

In [10]:
krx.read('58FF24', start='2021-06-16', end='2021-06-22', kind='elw')

Out[10]:
KBFF24삼성전자콜
종가	대비	시가	고가	저가	거래량	거래대금	시가총액	상장증권수	기초자산
                                                                                     자산명	종가	대비	등락률
2021-06-22	140	0	0	0	0	0	0	2926000000	20900000	삼성전자	80000	100	0.13
2021-06-21	140	0	0	0	0	0	0	2926000000	20900000	삼성전자	79900	-600	-0.75
2021-06-18	140	0	0	0	0	0	0	2926000000	20900000	삼성전자	80500	-400	-0.49
2021-06-17	140	0	0	0	0	0	0	2926000000	20900000	삼성전자	80900	-900	-1.10
2021-06-16	140	0	0	0	0	0	0	2926000000	20900000	삼성전자	81800	900	1.11

```
#### 4-2. 해당일 모든 ELW 데이터 불러오기
```python

In [11]:
krx.read_all(date='2021-06-22', kind='elw').head()

Out[11]:
종목코드	종목명	종가	대비	시가	고가	저가	거래량	거래대금	시가총액	상장증권수	기초자산
                                                                                                          자산명	종가	대비	등락률
0	58FF21	KBFF21LG화학콜	55	10	50	55	50	1620	81500	847000000	15400000	LG화학	842000.0	20000.0	2.43
1	58FF22	KBFF22네이버콜	115	-10	115	115	115	45000	5175000	1805500000	15700000	NAVER	391000.0	-6000.0	-1.51
2	58FF23	KBFF23SK하이닉콜	300	0	0	0	0	0	0	5100000000	17000000	SK하이닉스	122000.0	0.0	0.00
3	58FF24	KBFF24삼성전자콜	140	0	0	0	0	0	0	2926000000	20900000	삼성전자	80000.0	100.0	0.13
4	58FF25	KBFF25신한지주콜	65	0	0	0	0	0	0	1222000000	18800000	신한지주	40750.0	950.0	2.39
```

## License
Apach License
