# Installation instructions

**WARNING**: `guikit` is in an early stage of development and the API might change
without notice. Use it in production with caution. And please, contribute to it to
help improving its maturity as fast as posisble!

`guikit` and its dependencies can be installed with `pip` in Widnows,
[Linux](#what-about-linux) and [MacOS](#what-about-macos) (see notes below):

```bash
pip install guikit
```

## What about linux

`guikit` can be installed in Linux with `pip`, but `wxPython` will likely need to be
built from source as there are not *manylinux* wheels for it, yet.

The best option is for you to check if there is a wheel available for your specific
linux distirbution and python version in the [wxPython downloads
webpage](https://wxpython.org/pages/downloads/index.html) and install that one before
installing `guikit`. Otherwise, in the same webpage you have instructions on how to
install `wxPython` from source.

Alternatively, if you use `conda`, you can install `wxPython` from `conda-forge` and
then install `guikit` as above.

## What about MacOS

`wxPython` causes some issue on MacOS when installed with a "Non Framework" version of
python. It typically complains with this error message:

```
This program needs access to the screen. Please run with a
Framework build of python, and only when you are logged in
on the main display of your Mac.
```

To work around this:

1. Install a python.org version of python.
1. Find executable under `/Library/Frameworks/Python.framework/...`.
1. Use that executable to create a virtual environment: `/Library/Frameworks/Python.framework/Versions/<version>/bin/python3 -m venv .venv`.
1. Install `guikit` inside virtual environment, and all should work!

Alternatively, if you use `conda` to install `wxPython`, you will need to use `pythonw`
to execute your applications. See [wxPython downloads
webpage](https://wxpython.org/pages/downloads/index.html) for more information on this.
In short, the steps you should follow in this case consist on creating a conda
environment and then install `wxPython` and `python.app` on it before installing
`guikit`:

```bash
conda create -n guikit-env python=3.8
conda activate guikit-env
(guikit-env)  $ conda install wxPython -c conda-forge
(guikit-env)  $ conda install python.app
(guikit-env)  $ pip install guikit
```

And then, use `guikit` with `pythonw` rather than `python` (see [this
section](using_guikit.md) for all the options). For example:

```bash
(guikit-env)  $ pythonw -m guikit run
```