from typing import Any, Iterable, List

try:
    from functools import cached_property  # noqa F401
except ImportError:
    from cached_property import cached_property  # noqa F401


try:
    from functools import cache
except ImportError:
    from functools import lru_cache

    cache = lru_cache(maxsize=None)


def chunks(elements: List[Any], n: int) -> Iterable[Any]:
    """
    :param elements: List
    :param n: Number of elements per chunk
    :return: Yield successive n-sized chunks from l
    """
    for i in range(0, len(elements), n):
        yield elements[i : i + n]
