"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectLevelMrApprovals = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals}
*/
class ProjectLevelMrApprovals extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectLevelMrApprovalsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project_level_mr_approvals',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.16.1',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._disableOverridingApproversPerMergeRequest = config.disableOverridingApproversPerMergeRequest;
        this._id = config.id;
        this._mergeRequestsAuthorApproval = config.mergeRequestsAuthorApproval;
        this._mergeRequestsDisableCommittersApproval = config.mergeRequestsDisableCommittersApproval;
        this._projectId = config.projectId;
        this._requirePasswordToApprove = config.requirePasswordToApprove;
        this._resetApprovalsOnPush = config.resetApprovalsOnPush;
    }
    get disableOverridingApproversPerMergeRequest() {
        return this.getBooleanAttribute('disable_overriding_approvers_per_merge_request');
    }
    set disableOverridingApproversPerMergeRequest(value) {
        this._disableOverridingApproversPerMergeRequest = value;
    }
    resetDisableOverridingApproversPerMergeRequest() {
        this._disableOverridingApproversPerMergeRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableOverridingApproversPerMergeRequestInput() {
        return this._disableOverridingApproversPerMergeRequest;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get mergeRequestsAuthorApproval() {
        return this.getBooleanAttribute('merge_requests_author_approval');
    }
    set mergeRequestsAuthorApproval(value) {
        this._mergeRequestsAuthorApproval = value;
    }
    resetMergeRequestsAuthorApproval() {
        this._mergeRequestsAuthorApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAuthorApprovalInput() {
        return this._mergeRequestsAuthorApproval;
    }
    get mergeRequestsDisableCommittersApproval() {
        return this.getBooleanAttribute('merge_requests_disable_committers_approval');
    }
    set mergeRequestsDisableCommittersApproval(value) {
        this._mergeRequestsDisableCommittersApproval = value;
    }
    resetMergeRequestsDisableCommittersApproval() {
        this._mergeRequestsDisableCommittersApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsDisableCommittersApprovalInput() {
        return this._mergeRequestsDisableCommittersApproval;
    }
    get projectId() {
        return this.getNumberAttribute('project_id');
    }
    set projectId(value) {
        this._projectId = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectIdInput() {
        return this._projectId;
    }
    get requirePasswordToApprove() {
        return this.getBooleanAttribute('require_password_to_approve');
    }
    set requirePasswordToApprove(value) {
        this._requirePasswordToApprove = value;
    }
    resetRequirePasswordToApprove() {
        this._requirePasswordToApprove = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirePasswordToApproveInput() {
        return this._requirePasswordToApprove;
    }
    get resetApprovalsOnPush() {
        return this.getBooleanAttribute('reset_approvals_on_push');
    }
    set resetApprovalsOnPush(value) {
        this._resetApprovalsOnPush = value;
    }
    resetResetApprovalsOnPush() {
        this._resetApprovalsOnPush = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resetApprovalsOnPushInput() {
        return this._resetApprovalsOnPush;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            disable_overriding_approvers_per_merge_request: cdktf.booleanToTerraform(this._disableOverridingApproversPerMergeRequest),
            id: cdktf.stringToTerraform(this._id),
            merge_requests_author_approval: cdktf.booleanToTerraform(this._mergeRequestsAuthorApproval),
            merge_requests_disable_committers_approval: cdktf.booleanToTerraform(this._mergeRequestsDisableCommittersApproval),
            project_id: cdktf.numberToTerraform(this._projectId),
            require_password_to_approve: cdktf.booleanToTerraform(this._requirePasswordToApprove),
            reset_approvals_on_push: cdktf.booleanToTerraform(this._resetApprovalsOnPush),
        };
    }
}
exports.ProjectLevelMrApprovals = ProjectLevelMrApprovals;
_a = JSII_RTTI_SYMBOL_1;
ProjectLevelMrApprovals[_a] = { fqn: "@cdktf/provider-gitlab.ProjectLevelMrApprovals", version: "1.0.2" };
// =================
// STATIC PROPERTIES
// =================
ProjectLevelMrApprovals.tfResourceType = "gitlab_project_level_mr_approvals";
//# sourceMappingURL=data:application/json;base64,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