"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = exports.ProjectPushRulesOutputReference = exports.projectPushRulesToTerraform = exports.ProjectContainerExpirationPolicyOutputReference = exports.projectContainerExpirationPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectContainerExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cadence: cdktf.stringToTerraform(struct.cadence),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        keep_n: cdktf.numberToTerraform(struct.keepN),
        name_regex_delete: cdktf.stringToTerraform(struct.nameRegexDelete),
        name_regex_keep: cdktf.stringToTerraform(struct.nameRegexKeep),
        older_than: cdktf.stringToTerraform(struct.olderThan),
    };
}
exports.projectContainerExpirationPolicyToTerraform = projectContainerExpirationPolicyToTerraform;
class ProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cadence !== undefined) {
            hasAnyValues = true;
            internalValueResult.cadence = this._cadence;
        }
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._keepN !== undefined) {
            hasAnyValues = true;
            internalValueResult.keepN = this._keepN;
        }
        if (this._nameRegexDelete !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexDelete = this._nameRegexDelete;
        }
        if (this._nameRegexKeep !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexKeep = this._nameRegexKeep;
        }
        if (this._olderThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.olderThan = this._olderThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cadence = undefined;
            this._enabled = undefined;
            this._keepN = undefined;
            this._nameRegexDelete = undefined;
            this._nameRegexKeep = undefined;
            this._olderThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cadence = value.cadence;
            this._enabled = value.enabled;
            this._keepN = value.keepN;
            this._nameRegexDelete = value.nameRegexDelete;
            this._nameRegexKeep = value.nameRegexKeep;
            this._olderThan = value.olderThan;
        }
    }
    get cadence() {
        return this.getStringAttribute('cadence');
    }
    set cadence(value) {
        this._cadence = value;
    }
    resetCadence() {
        this._cadence = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cadenceInput() {
        return this._cadence;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get keepN() {
        return this.getNumberAttribute('keep_n');
    }
    set keepN(value) {
        this._keepN = value;
    }
    resetKeepN() {
        this._keepN = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepNInput() {
        return this._keepN;
    }
    get nameRegexDelete() {
        return this.getStringAttribute('name_regex_delete');
    }
    set nameRegexDelete(value) {
        this._nameRegexDelete = value;
    }
    resetNameRegexDelete() {
        this._nameRegexDelete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexDeleteInput() {
        return this._nameRegexDelete;
    }
    get nameRegexKeep() {
        return this.getStringAttribute('name_regex_keep');
    }
    set nameRegexKeep(value) {
        this._nameRegexKeep = value;
    }
    resetNameRegexKeep() {
        this._nameRegexKeep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexKeepInput() {
        return this._nameRegexKeep;
    }
    // next_run_at - computed: true, optional: false, required: false
    get nextRunAt() {
        return this.getStringAttribute('next_run_at');
    }
    get olderThan() {
        return this.getStringAttribute('older_than');
    }
    set olderThan(value) {
        this._olderThan = value;
    }
    resetOlderThan() {
        this._olderThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get olderThanInput() {
        return this._olderThan;
    }
}
exports.ProjectContainerExpirationPolicyOutputReference = ProjectContainerExpirationPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectContainerExpirationPolicyOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.ProjectContainerExpirationPolicyOutputReference", version: "1.0.2" };
function projectPushRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        author_email_regex: cdktf.stringToTerraform(struct.authorEmailRegex),
        branch_name_regex: cdktf.stringToTerraform(struct.branchNameRegex),
        commit_committer_check: cdktf.booleanToTerraform(struct.commitCommitterCheck),
        commit_message_negative_regex: cdktf.stringToTerraform(struct.commitMessageNegativeRegex),
        commit_message_regex: cdktf.stringToTerraform(struct.commitMessageRegex),
        deny_delete_tag: cdktf.booleanToTerraform(struct.denyDeleteTag),
        file_name_regex: cdktf.stringToTerraform(struct.fileNameRegex),
        max_file_size: cdktf.numberToTerraform(struct.maxFileSize),
        member_check: cdktf.booleanToTerraform(struct.memberCheck),
        prevent_secrets: cdktf.booleanToTerraform(struct.preventSecrets),
        reject_unsigned_commits: cdktf.booleanToTerraform(struct.rejectUnsignedCommits),
    };
}
exports.projectPushRulesToTerraform = projectPushRulesToTerraform;
class ProjectPushRulesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authorEmailRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.authorEmailRegex = this._authorEmailRegex;
        }
        if (this._branchNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.branchNameRegex = this._branchNameRegex;
        }
        if (this._commitCommitterCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitCommitterCheck = this._commitCommitterCheck;
        }
        if (this._commitMessageNegativeRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageNegativeRegex = this._commitMessageNegativeRegex;
        }
        if (this._commitMessageRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageRegex = this._commitMessageRegex;
        }
        if (this._denyDeleteTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.denyDeleteTag = this._denyDeleteTag;
        }
        if (this._fileNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.fileNameRegex = this._fileNameRegex;
        }
        if (this._maxFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFileSize = this._maxFileSize;
        }
        if (this._memberCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.memberCheck = this._memberCheck;
        }
        if (this._preventSecrets !== undefined) {
            hasAnyValues = true;
            internalValueResult.preventSecrets = this._preventSecrets;
        }
        if (this._rejectUnsignedCommits !== undefined) {
            hasAnyValues = true;
            internalValueResult.rejectUnsignedCommits = this._rejectUnsignedCommits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authorEmailRegex = undefined;
            this._branchNameRegex = undefined;
            this._commitCommitterCheck = undefined;
            this._commitMessageNegativeRegex = undefined;
            this._commitMessageRegex = undefined;
            this._denyDeleteTag = undefined;
            this._fileNameRegex = undefined;
            this._maxFileSize = undefined;
            this._memberCheck = undefined;
            this._preventSecrets = undefined;
            this._rejectUnsignedCommits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authorEmailRegex = value.authorEmailRegex;
            this._branchNameRegex = value.branchNameRegex;
            this._commitCommitterCheck = value.commitCommitterCheck;
            this._commitMessageNegativeRegex = value.commitMessageNegativeRegex;
            this._commitMessageRegex = value.commitMessageRegex;
            this._denyDeleteTag = value.denyDeleteTag;
            this._fileNameRegex = value.fileNameRegex;
            this._maxFileSize = value.maxFileSize;
            this._memberCheck = value.memberCheck;
            this._preventSecrets = value.preventSecrets;
            this._rejectUnsignedCommits = value.rejectUnsignedCommits;
        }
    }
    get authorEmailRegex() {
        return this.getStringAttribute('author_email_regex');
    }
    set authorEmailRegex(value) {
        this._authorEmailRegex = value;
    }
    resetAuthorEmailRegex() {
        this._authorEmailRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorEmailRegexInput() {
        return this._authorEmailRegex;
    }
    get branchNameRegex() {
        return this.getStringAttribute('branch_name_regex');
    }
    set branchNameRegex(value) {
        this._branchNameRegex = value;
    }
    resetBranchNameRegex() {
        this._branchNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchNameRegexInput() {
        return this._branchNameRegex;
    }
    get commitCommitterCheck() {
        return this.getBooleanAttribute('commit_committer_check');
    }
    set commitCommitterCheck(value) {
        this._commitCommitterCheck = value;
    }
    resetCommitCommitterCheck() {
        this._commitCommitterCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitCommitterCheckInput() {
        return this._commitCommitterCheck;
    }
    get commitMessageNegativeRegex() {
        return this.getStringAttribute('commit_message_negative_regex');
    }
    set commitMessageNegativeRegex(value) {
        this._commitMessageNegativeRegex = value;
    }
    resetCommitMessageNegativeRegex() {
        this._commitMessageNegativeRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageNegativeRegexInput() {
        return this._commitMessageNegativeRegex;
    }
    get commitMessageRegex() {
        return this.getStringAttribute('commit_message_regex');
    }
    set commitMessageRegex(value) {
        this._commitMessageRegex = value;
    }
    resetCommitMessageRegex() {
        this._commitMessageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageRegexInput() {
        return this._commitMessageRegex;
    }
    get denyDeleteTag() {
        return this.getBooleanAttribute('deny_delete_tag');
    }
    set denyDeleteTag(value) {
        this._denyDeleteTag = value;
    }
    resetDenyDeleteTag() {
        this._denyDeleteTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyDeleteTagInput() {
        return this._denyDeleteTag;
    }
    get fileNameRegex() {
        return this.getStringAttribute('file_name_regex');
    }
    set fileNameRegex(value) {
        this._fileNameRegex = value;
    }
    resetFileNameRegex() {
        this._fileNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileNameRegexInput() {
        return this._fileNameRegex;
    }
    get maxFileSize() {
        return this.getNumberAttribute('max_file_size');
    }
    set maxFileSize(value) {
        this._maxFileSize = value;
    }
    resetMaxFileSize() {
        this._maxFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFileSizeInput() {
        return this._maxFileSize;
    }
    get memberCheck() {
        return this.getBooleanAttribute('member_check');
    }
    set memberCheck(value) {
        this._memberCheck = value;
    }
    resetMemberCheck() {
        this._memberCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberCheckInput() {
        return this._memberCheck;
    }
    get preventSecrets() {
        return this.getBooleanAttribute('prevent_secrets');
    }
    set preventSecrets(value) {
        this._preventSecrets = value;
    }
    resetPreventSecrets() {
        this._preventSecrets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventSecretsInput() {
        return this._preventSecrets;
    }
    get rejectUnsignedCommits() {
        return this.getBooleanAttribute('reject_unsigned_commits');
    }
    set rejectUnsignedCommits(value) {
        this._rejectUnsignedCommits = value;
    }
    resetRejectUnsignedCommits() {
        this._rejectUnsignedCommits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rejectUnsignedCommitsInput() {
        return this._rejectUnsignedCommits;
    }
}
exports.ProjectPushRulesOutputReference = ProjectPushRulesOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ProjectPushRulesOutputReference[_b] = { fqn: "@cdktf/provider-gitlab.ProjectPushRulesOutputReference", version: "1.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project}
*/
class Project extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.16.1',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // container_expiration_policy - computed: false, optional: true, required: false
        this._containerExpirationPolicy = new ProjectContainerExpirationPolicyOutputReference(this, "container_expiration_policy");
        // push_rules - computed: false, optional: true, required: false
        this._pushRules = new ProjectPushRulesOutputReference(this, "push_rules");
        this._allowMergeOnSkippedPipeline = config.allowMergeOnSkippedPipeline;
        this._analyticsAccessLevel = config.analyticsAccessLevel;
        this._approvalsBeforeMerge = config.approvalsBeforeMerge;
        this._archiveOnDestroy = config.archiveOnDestroy;
        this._archived = config.archived;
        this._autoCancelPendingPipelines = config.autoCancelPendingPipelines;
        this._autoDevopsDeployStrategy = config.autoDevopsDeployStrategy;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._autocloseReferencedIssues = config.autocloseReferencedIssues;
        this._buildCoverageRegex = config.buildCoverageRegex;
        this._buildGitStrategy = config.buildGitStrategy;
        this._buildTimeout = config.buildTimeout;
        this._buildsAccessLevel = config.buildsAccessLevel;
        this._ciConfigPath = config.ciConfigPath;
        this._ciDefaultGitDepth = config.ciDefaultGitDepth;
        this._ciForwardDeploymentEnabled = config.ciForwardDeploymentEnabled;
        this._containerRegistryAccessLevel = config.containerRegistryAccessLevel;
        this._containerRegistryEnabled = config.containerRegistryEnabled;
        this._defaultBranch = config.defaultBranch;
        this._description = config.description;
        this._emailsDisabled = config.emailsDisabled;
        this._externalAuthorizationClassificationLabel = config.externalAuthorizationClassificationLabel;
        this._forkingAccessLevel = config.forkingAccessLevel;
        this._groupWithProjectTemplatesId = config.groupWithProjectTemplatesId;
        this._id = config.id;
        this._importUrl = config.importUrl;
        this._initializeWithReadme = config.initializeWithReadme;
        this._issuesAccessLevel = config.issuesAccessLevel;
        this._issuesEnabled = config.issuesEnabled;
        this._issuesTemplate = config.issuesTemplate;
        this._lfsEnabled = config.lfsEnabled;
        this._mergeCommitTemplate = config.mergeCommitTemplate;
        this._mergeMethod = config.mergeMethod;
        this._mergePipelinesEnabled = config.mergePipelinesEnabled;
        this._mergeRequestsAccessLevel = config.mergeRequestsAccessLevel;
        this._mergeRequestsEnabled = config.mergeRequestsEnabled;
        this._mergeRequestsTemplate = config.mergeRequestsTemplate;
        this._mergeTrainsEnabled = config.mergeTrainsEnabled;
        this._mirror = config.mirror;
        this._mirrorOverwritesDivergedBranches = config.mirrorOverwritesDivergedBranches;
        this._mirrorTriggerBuilds = config.mirrorTriggerBuilds;
        this._name = config.name;
        this._namespaceId = config.namespaceId;
        this._onlyAllowMergeIfAllDiscussionsAreResolved = config.onlyAllowMergeIfAllDiscussionsAreResolved;
        this._onlyAllowMergeIfPipelineSucceeds = config.onlyAllowMergeIfPipelineSucceeds;
        this._onlyMirrorProtectedBranches = config.onlyMirrorProtectedBranches;
        this._operationsAccessLevel = config.operationsAccessLevel;
        this._packagesEnabled = config.packagesEnabled;
        this._pagesAccessLevel = config.pagesAccessLevel;
        this._path = config.path;
        this._pipelinesEnabled = config.pipelinesEnabled;
        this._printingMergeRequestLinkEnabled = config.printingMergeRequestLinkEnabled;
        this._publicBuilds = config.publicBuilds;
        this._removeSourceBranchAfterMerge = config.removeSourceBranchAfterMerge;
        this._repositoryAccessLevel = config.repositoryAccessLevel;
        this._repositoryStorage = config.repositoryStorage;
        this._requestAccessEnabled = config.requestAccessEnabled;
        this._requirementsAccessLevel = config.requirementsAccessLevel;
        this._resolveOutdatedDiffDiscussions = config.resolveOutdatedDiffDiscussions;
        this._securityAndComplianceAccessLevel = config.securityAndComplianceAccessLevel;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._skipWaitForDefaultBranchProtection = config.skipWaitForDefaultBranchProtection;
        this._snippetsAccessLevel = config.snippetsAccessLevel;
        this._snippetsEnabled = config.snippetsEnabled;
        this._squashCommitTemplate = config.squashCommitTemplate;
        this._squashOption = config.squashOption;
        this._tags = config.tags;
        this._templateName = config.templateName;
        this._templateProjectId = config.templateProjectId;
        this._topics = config.topics;
        this._useCustomTemplate = config.useCustomTemplate;
        this._visibilityLevel = config.visibilityLevel;
        this._wikiAccessLevel = config.wikiAccessLevel;
        this._wikiEnabled = config.wikiEnabled;
        this._containerExpirationPolicy.internalValue = config.containerExpirationPolicy;
        this._pushRules.internalValue = config.pushRules;
    }
    get allowMergeOnSkippedPipeline() {
        return this.getBooleanAttribute('allow_merge_on_skipped_pipeline');
    }
    set allowMergeOnSkippedPipeline(value) {
        this._allowMergeOnSkippedPipeline = value;
    }
    resetAllowMergeOnSkippedPipeline() {
        this._allowMergeOnSkippedPipeline = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMergeOnSkippedPipelineInput() {
        return this._allowMergeOnSkippedPipeline;
    }
    get analyticsAccessLevel() {
        return this.getStringAttribute('analytics_access_level');
    }
    set analyticsAccessLevel(value) {
        this._analyticsAccessLevel = value;
    }
    resetAnalyticsAccessLevel() {
        this._analyticsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analyticsAccessLevelInput() {
        return this._analyticsAccessLevel;
    }
    get approvalsBeforeMerge() {
        return this.getNumberAttribute('approvals_before_merge');
    }
    set approvalsBeforeMerge(value) {
        this._approvalsBeforeMerge = value;
    }
    resetApprovalsBeforeMerge() {
        this._approvalsBeforeMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get approvalsBeforeMergeInput() {
        return this._approvalsBeforeMerge;
    }
    get archiveOnDestroy() {
        return this.getBooleanAttribute('archive_on_destroy');
    }
    set archiveOnDestroy(value) {
        this._archiveOnDestroy = value;
    }
    resetArchiveOnDestroy() {
        this._archiveOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnDestroyInput() {
        return this._archiveOnDestroy;
    }
    get archived() {
        return this.getBooleanAttribute('archived');
    }
    set archived(value) {
        this._archived = value;
    }
    resetArchived() {
        this._archived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archivedInput() {
        return this._archived;
    }
    get autoCancelPendingPipelines() {
        return this.getStringAttribute('auto_cancel_pending_pipelines');
    }
    set autoCancelPendingPipelines(value) {
        this._autoCancelPendingPipelines = value;
    }
    resetAutoCancelPendingPipelines() {
        this._autoCancelPendingPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoCancelPendingPipelinesInput() {
        return this._autoCancelPendingPipelines;
    }
    get autoDevopsDeployStrategy() {
        return this.getStringAttribute('auto_devops_deploy_strategy');
    }
    set autoDevopsDeployStrategy(value) {
        this._autoDevopsDeployStrategy = value;
    }
    resetAutoDevopsDeployStrategy() {
        this._autoDevopsDeployStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDeployStrategyInput() {
        return this._autoDevopsDeployStrategy;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get autocloseReferencedIssues() {
        return this.getBooleanAttribute('autoclose_referenced_issues');
    }
    set autocloseReferencedIssues(value) {
        this._autocloseReferencedIssues = value;
    }
    resetAutocloseReferencedIssues() {
        this._autocloseReferencedIssues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autocloseReferencedIssuesInput() {
        return this._autocloseReferencedIssues;
    }
    get buildCoverageRegex() {
        return this.getStringAttribute('build_coverage_regex');
    }
    set buildCoverageRegex(value) {
        this._buildCoverageRegex = value;
    }
    resetBuildCoverageRegex() {
        this._buildCoverageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildCoverageRegexInput() {
        return this._buildCoverageRegex;
    }
    get buildGitStrategy() {
        return this.getStringAttribute('build_git_strategy');
    }
    set buildGitStrategy(value) {
        this._buildGitStrategy = value;
    }
    resetBuildGitStrategy() {
        this._buildGitStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildGitStrategyInput() {
        return this._buildGitStrategy;
    }
    get buildTimeout() {
        return this.getNumberAttribute('build_timeout');
    }
    set buildTimeout(value) {
        this._buildTimeout = value;
    }
    resetBuildTimeout() {
        this._buildTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildTimeoutInput() {
        return this._buildTimeout;
    }
    get buildsAccessLevel() {
        return this.getStringAttribute('builds_access_level');
    }
    set buildsAccessLevel(value) {
        this._buildsAccessLevel = value;
    }
    resetBuildsAccessLevel() {
        this._buildsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildsAccessLevelInput() {
        return this._buildsAccessLevel;
    }
    get ciConfigPath() {
        return this.getStringAttribute('ci_config_path');
    }
    set ciConfigPath(value) {
        this._ciConfigPath = value;
    }
    resetCiConfigPath() {
        this._ciConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciConfigPathInput() {
        return this._ciConfigPath;
    }
    get ciDefaultGitDepth() {
        return this.getNumberAttribute('ci_default_git_depth');
    }
    set ciDefaultGitDepth(value) {
        this._ciDefaultGitDepth = value;
    }
    resetCiDefaultGitDepth() {
        this._ciDefaultGitDepth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciDefaultGitDepthInput() {
        return this._ciDefaultGitDepth;
    }
    get ciForwardDeploymentEnabled() {
        return this.getBooleanAttribute('ci_forward_deployment_enabled');
    }
    set ciForwardDeploymentEnabled(value) {
        this._ciForwardDeploymentEnabled = value;
    }
    resetCiForwardDeploymentEnabled() {
        this._ciForwardDeploymentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciForwardDeploymentEnabledInput() {
        return this._ciForwardDeploymentEnabled;
    }
    get containerRegistryAccessLevel() {
        return this.getStringAttribute('container_registry_access_level');
    }
    set containerRegistryAccessLevel(value) {
        this._containerRegistryAccessLevel = value;
    }
    resetContainerRegistryAccessLevel() {
        this._containerRegistryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryAccessLevelInput() {
        return this._containerRegistryAccessLevel;
    }
    get containerRegistryEnabled() {
        return this.getBooleanAttribute('container_registry_enabled');
    }
    set containerRegistryEnabled(value) {
        this._containerRegistryEnabled = value;
    }
    resetContainerRegistryEnabled() {
        this._containerRegistryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryEnabledInput() {
        return this._containerRegistryEnabled;
    }
    get defaultBranch() {
        return this.getStringAttribute('default_branch');
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    resetDefaultBranch() {
        this._defaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchInput() {
        return this._defaultBranch;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailsDisabled() {
        return this.getBooleanAttribute('emails_disabled');
    }
    set emailsDisabled(value) {
        this._emailsDisabled = value;
    }
    resetEmailsDisabled() {
        this._emailsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailsDisabledInput() {
        return this._emailsDisabled;
    }
    get externalAuthorizationClassificationLabel() {
        return this.getStringAttribute('external_authorization_classification_label');
    }
    set externalAuthorizationClassificationLabel(value) {
        this._externalAuthorizationClassificationLabel = value;
    }
    resetExternalAuthorizationClassificationLabel() {
        this._externalAuthorizationClassificationLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationClassificationLabelInput() {
        return this._externalAuthorizationClassificationLabel;
    }
    get forkingAccessLevel() {
        return this.getStringAttribute('forking_access_level');
    }
    set forkingAccessLevel(value) {
        this._forkingAccessLevel = value;
    }
    resetForkingAccessLevel() {
        this._forkingAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forkingAccessLevelInput() {
        return this._forkingAccessLevel;
    }
    get groupWithProjectTemplatesId() {
        return this.getNumberAttribute('group_with_project_templates_id');
    }
    set groupWithProjectTemplatesId(value) {
        this._groupWithProjectTemplatesId = value;
    }
    resetGroupWithProjectTemplatesId() {
        this._groupWithProjectTemplatesId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupWithProjectTemplatesIdInput() {
        return this._groupWithProjectTemplatesId;
    }
    // http_url_to_repo - computed: true, optional: false, required: false
    get httpUrlToRepo() {
        return this.getStringAttribute('http_url_to_repo');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importUrl() {
        return this.getStringAttribute('import_url');
    }
    set importUrl(value) {
        this._importUrl = value;
    }
    resetImportUrl() {
        this._importUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlInput() {
        return this._importUrl;
    }
    get initializeWithReadme() {
        return this.getBooleanAttribute('initialize_with_readme');
    }
    set initializeWithReadme(value) {
        this._initializeWithReadme = value;
    }
    resetInitializeWithReadme() {
        this._initializeWithReadme = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initializeWithReadmeInput() {
        return this._initializeWithReadme;
    }
    get issuesAccessLevel() {
        return this.getStringAttribute('issues_access_level');
    }
    set issuesAccessLevel(value) {
        this._issuesAccessLevel = value;
    }
    resetIssuesAccessLevel() {
        this._issuesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesAccessLevelInput() {
        return this._issuesAccessLevel;
    }
    get issuesEnabled() {
        return this.getBooleanAttribute('issues_enabled');
    }
    set issuesEnabled(value) {
        this._issuesEnabled = value;
    }
    resetIssuesEnabled() {
        this._issuesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEnabledInput() {
        return this._issuesEnabled;
    }
    get issuesTemplate() {
        return this.getStringAttribute('issues_template');
    }
    set issuesTemplate(value) {
        this._issuesTemplate = value;
    }
    resetIssuesTemplate() {
        this._issuesTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesTemplateInput() {
        return this._issuesTemplate;
    }
    get lfsEnabled() {
        return this.getBooleanAttribute('lfs_enabled');
    }
    set lfsEnabled(value) {
        this._lfsEnabled = value;
    }
    resetLfsEnabled() {
        this._lfsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lfsEnabledInput() {
        return this._lfsEnabled;
    }
    get mergeCommitTemplate() {
        return this.getStringAttribute('merge_commit_template');
    }
    set mergeCommitTemplate(value) {
        this._mergeCommitTemplate = value;
    }
    resetMergeCommitTemplate() {
        this._mergeCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeCommitTemplateInput() {
        return this._mergeCommitTemplate;
    }
    get mergeMethod() {
        return this.getStringAttribute('merge_method');
    }
    set mergeMethod(value) {
        this._mergeMethod = value;
    }
    resetMergeMethod() {
        this._mergeMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeMethodInput() {
        return this._mergeMethod;
    }
    get mergePipelinesEnabled() {
        return this.getBooleanAttribute('merge_pipelines_enabled');
    }
    set mergePipelinesEnabled(value) {
        this._mergePipelinesEnabled = value;
    }
    resetMergePipelinesEnabled() {
        this._mergePipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergePipelinesEnabledInput() {
        return this._mergePipelinesEnabled;
    }
    get mergeRequestsAccessLevel() {
        return this.getStringAttribute('merge_requests_access_level');
    }
    set mergeRequestsAccessLevel(value) {
        this._mergeRequestsAccessLevel = value;
    }
    resetMergeRequestsAccessLevel() {
        this._mergeRequestsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAccessLevelInput() {
        return this._mergeRequestsAccessLevel;
    }
    get mergeRequestsEnabled() {
        return this.getBooleanAttribute('merge_requests_enabled');
    }
    set mergeRequestsEnabled(value) {
        this._mergeRequestsEnabled = value;
    }
    resetMergeRequestsEnabled() {
        this._mergeRequestsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEnabledInput() {
        return this._mergeRequestsEnabled;
    }
    get mergeRequestsTemplate() {
        return this.getStringAttribute('merge_requests_template');
    }
    set mergeRequestsTemplate(value) {
        this._mergeRequestsTemplate = value;
    }
    resetMergeRequestsTemplate() {
        this._mergeRequestsTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsTemplateInput() {
        return this._mergeRequestsTemplate;
    }
    get mergeTrainsEnabled() {
        return this.getBooleanAttribute('merge_trains_enabled');
    }
    set mergeTrainsEnabled(value) {
        this._mergeTrainsEnabled = value;
    }
    resetMergeTrainsEnabled() {
        this._mergeTrainsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeTrainsEnabledInput() {
        return this._mergeTrainsEnabled;
    }
    get mirror() {
        return this.getBooleanAttribute('mirror');
    }
    set mirror(value) {
        this._mirror = value;
    }
    resetMirror() {
        this._mirror = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorInput() {
        return this._mirror;
    }
    get mirrorOverwritesDivergedBranches() {
        return this.getBooleanAttribute('mirror_overwrites_diverged_branches');
    }
    set mirrorOverwritesDivergedBranches(value) {
        this._mirrorOverwritesDivergedBranches = value;
    }
    resetMirrorOverwritesDivergedBranches() {
        this._mirrorOverwritesDivergedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorOverwritesDivergedBranchesInput() {
        return this._mirrorOverwritesDivergedBranches;
    }
    get mirrorTriggerBuilds() {
        return this.getBooleanAttribute('mirror_trigger_builds');
    }
    set mirrorTriggerBuilds(value) {
        this._mirrorTriggerBuilds = value;
    }
    resetMirrorTriggerBuilds() {
        this._mirrorTriggerBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorTriggerBuildsInput() {
        return this._mirrorTriggerBuilds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespaceId() {
        return this.getNumberAttribute('namespace_id');
    }
    set namespaceId(value) {
        this._namespaceId = value;
    }
    resetNamespaceId() {
        this._namespaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceIdInput() {
        return this._namespaceId;
    }
    get onlyAllowMergeIfAllDiscussionsAreResolved() {
        return this.getBooleanAttribute('only_allow_merge_if_all_discussions_are_resolved');
    }
    set onlyAllowMergeIfAllDiscussionsAreResolved(value) {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = value;
    }
    resetOnlyAllowMergeIfAllDiscussionsAreResolved() {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfAllDiscussionsAreResolvedInput() {
        return this._onlyAllowMergeIfAllDiscussionsAreResolved;
    }
    get onlyAllowMergeIfPipelineSucceeds() {
        return this.getBooleanAttribute('only_allow_merge_if_pipeline_succeeds');
    }
    set onlyAllowMergeIfPipelineSucceeds(value) {
        this._onlyAllowMergeIfPipelineSucceeds = value;
    }
    resetOnlyAllowMergeIfPipelineSucceeds() {
        this._onlyAllowMergeIfPipelineSucceeds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfPipelineSucceedsInput() {
        return this._onlyAllowMergeIfPipelineSucceeds;
    }
    get onlyMirrorProtectedBranches() {
        return this.getBooleanAttribute('only_mirror_protected_branches');
    }
    set onlyMirrorProtectedBranches(value) {
        this._onlyMirrorProtectedBranches = value;
    }
    resetOnlyMirrorProtectedBranches() {
        this._onlyMirrorProtectedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyMirrorProtectedBranchesInput() {
        return this._onlyMirrorProtectedBranches;
    }
    get operationsAccessLevel() {
        return this.getStringAttribute('operations_access_level');
    }
    set operationsAccessLevel(value) {
        this._operationsAccessLevel = value;
    }
    resetOperationsAccessLevel() {
        this._operationsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationsAccessLevelInput() {
        return this._operationsAccessLevel;
    }
    get packagesEnabled() {
        return this.getBooleanAttribute('packages_enabled');
    }
    set packagesEnabled(value) {
        this._packagesEnabled = value;
    }
    resetPackagesEnabled() {
        this._packagesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packagesEnabledInput() {
        return this._packagesEnabled;
    }
    get pagesAccessLevel() {
        return this.getStringAttribute('pages_access_level');
    }
    set pagesAccessLevel(value) {
        this._pagesAccessLevel = value;
    }
    resetPagesAccessLevel() {
        this._pagesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesAccessLevelInput() {
        return this._pagesAccessLevel;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    // path_with_namespace - computed: true, optional: false, required: false
    get pathWithNamespace() {
        return this.getStringAttribute('path_with_namespace');
    }
    get pipelinesEnabled() {
        return this.getBooleanAttribute('pipelines_enabled');
    }
    set pipelinesEnabled(value) {
        this._pipelinesEnabled = value;
    }
    resetPipelinesEnabled() {
        this._pipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelinesEnabledInput() {
        return this._pipelinesEnabled;
    }
    get printingMergeRequestLinkEnabled() {
        return this.getBooleanAttribute('printing_merge_request_link_enabled');
    }
    set printingMergeRequestLinkEnabled(value) {
        this._printingMergeRequestLinkEnabled = value;
    }
    resetPrintingMergeRequestLinkEnabled() {
        this._printingMergeRequestLinkEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get printingMergeRequestLinkEnabledInput() {
        return this._printingMergeRequestLinkEnabled;
    }
    get publicBuilds() {
        return this.getBooleanAttribute('public_builds');
    }
    set publicBuilds(value) {
        this._publicBuilds = value;
    }
    resetPublicBuilds() {
        this._publicBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicBuildsInput() {
        return this._publicBuilds;
    }
    get removeSourceBranchAfterMerge() {
        return this.getBooleanAttribute('remove_source_branch_after_merge');
    }
    set removeSourceBranchAfterMerge(value) {
        this._removeSourceBranchAfterMerge = value;
    }
    resetRemoveSourceBranchAfterMerge() {
        this._removeSourceBranchAfterMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removeSourceBranchAfterMergeInput() {
        return this._removeSourceBranchAfterMerge;
    }
    get repositoryAccessLevel() {
        return this.getStringAttribute('repository_access_level');
    }
    set repositoryAccessLevel(value) {
        this._repositoryAccessLevel = value;
    }
    resetRepositoryAccessLevel() {
        this._repositoryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryAccessLevelInput() {
        return this._repositoryAccessLevel;
    }
    get repositoryStorage() {
        return this.getStringAttribute('repository_storage');
    }
    set repositoryStorage(value) {
        this._repositoryStorage = value;
    }
    resetRepositoryStorage() {
        this._repositoryStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStorageInput() {
        return this._repositoryStorage;
    }
    get requestAccessEnabled() {
        return this.getBooleanAttribute('request_access_enabled');
    }
    set requestAccessEnabled(value) {
        this._requestAccessEnabled = value;
    }
    resetRequestAccessEnabled() {
        this._requestAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestAccessEnabledInput() {
        return this._requestAccessEnabled;
    }
    get requirementsAccessLevel() {
        return this.getStringAttribute('requirements_access_level');
    }
    set requirementsAccessLevel(value) {
        this._requirementsAccessLevel = value;
    }
    resetRequirementsAccessLevel() {
        this._requirementsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirementsAccessLevelInput() {
        return this._requirementsAccessLevel;
    }
    get resolveOutdatedDiffDiscussions() {
        return this.getBooleanAttribute('resolve_outdated_diff_discussions');
    }
    set resolveOutdatedDiffDiscussions(value) {
        this._resolveOutdatedDiffDiscussions = value;
    }
    resetResolveOutdatedDiffDiscussions() {
        this._resolveOutdatedDiffDiscussions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolveOutdatedDiffDiscussionsInput() {
        return this._resolveOutdatedDiffDiscussions;
    }
    // runners_token - computed: true, optional: false, required: false
    get runnersToken() {
        return this.getStringAttribute('runners_token');
    }
    get securityAndComplianceAccessLevel() {
        return this.getStringAttribute('security_and_compliance_access_level');
    }
    set securityAndComplianceAccessLevel(value) {
        this._securityAndComplianceAccessLevel = value;
    }
    resetSecurityAndComplianceAccessLevel() {
        this._securityAndComplianceAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityAndComplianceAccessLevelInput() {
        return this._securityAndComplianceAccessLevel;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get skipWaitForDefaultBranchProtection() {
        return this.getBooleanAttribute('skip_wait_for_default_branch_protection');
    }
    set skipWaitForDefaultBranchProtection(value) {
        this._skipWaitForDefaultBranchProtection = value;
    }
    resetSkipWaitForDefaultBranchProtection() {
        this._skipWaitForDefaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipWaitForDefaultBranchProtectionInput() {
        return this._skipWaitForDefaultBranchProtection;
    }
    get snippetsAccessLevel() {
        return this.getStringAttribute('snippets_access_level');
    }
    set snippetsAccessLevel(value) {
        this._snippetsAccessLevel = value;
    }
    resetSnippetsAccessLevel() {
        this._snippetsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsAccessLevelInput() {
        return this._snippetsAccessLevel;
    }
    get snippetsEnabled() {
        return this.getBooleanAttribute('snippets_enabled');
    }
    set snippetsEnabled(value) {
        this._snippetsEnabled = value;
    }
    resetSnippetsEnabled() {
        this._snippetsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsEnabledInput() {
        return this._snippetsEnabled;
    }
    get squashCommitTemplate() {
        return this.getStringAttribute('squash_commit_template');
    }
    set squashCommitTemplate(value) {
        this._squashCommitTemplate = value;
    }
    resetSquashCommitTemplate() {
        this._squashCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashCommitTemplateInput() {
        return this._squashCommitTemplate;
    }
    get squashOption() {
        return this.getStringAttribute('squash_option');
    }
    set squashOption(value) {
        this._squashOption = value;
    }
    resetSquashOption() {
        this._squashOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashOptionInput() {
        return this._squashOption;
    }
    // ssh_url_to_repo - computed: true, optional: false, required: false
    get sshUrlToRepo() {
        return this.getStringAttribute('ssh_url_to_repo');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get templateName() {
        return this.getStringAttribute('template_name');
    }
    set templateName(value) {
        this._templateName = value;
    }
    resetTemplateName() {
        this._templateName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateNameInput() {
        return this._templateName;
    }
    get templateProjectId() {
        return this.getNumberAttribute('template_project_id');
    }
    set templateProjectId(value) {
        this._templateProjectId = value;
    }
    resetTemplateProjectId() {
        this._templateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateProjectIdInput() {
        return this._templateProjectId;
    }
    get topics() {
        return cdktf.Fn.tolist(this.getListAttribute('topics'));
    }
    set topics(value) {
        this._topics = value;
    }
    resetTopics() {
        this._topics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicsInput() {
        return this._topics;
    }
    get useCustomTemplate() {
        return this.getBooleanAttribute('use_custom_template');
    }
    set useCustomTemplate(value) {
        this._useCustomTemplate = value;
    }
    resetUseCustomTemplate() {
        this._useCustomTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCustomTemplateInput() {
        return this._useCustomTemplate;
    }
    get visibilityLevel() {
        return this.getStringAttribute('visibility_level');
    }
    set visibilityLevel(value) {
        this._visibilityLevel = value;
    }
    resetVisibilityLevel() {
        this._visibilityLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get visibilityLevelInput() {
        return this._visibilityLevel;
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get wikiAccessLevel() {
        return this.getStringAttribute('wiki_access_level');
    }
    set wikiAccessLevel(value) {
        this._wikiAccessLevel = value;
    }
    resetWikiAccessLevel() {
        this._wikiAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiAccessLevelInput() {
        return this._wikiAccessLevel;
    }
    get wikiEnabled() {
        return this.getBooleanAttribute('wiki_enabled');
    }
    set wikiEnabled(value) {
        this._wikiEnabled = value;
    }
    resetWikiEnabled() {
        this._wikiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiEnabledInput() {
        return this._wikiEnabled;
    }
    get containerExpirationPolicy() {
        return this._containerExpirationPolicy;
    }
    putContainerExpirationPolicy(value) {
        this._containerExpirationPolicy.internalValue = value;
    }
    resetContainerExpirationPolicy() {
        this._containerExpirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPolicyInput() {
        return this._containerExpirationPolicy.internalValue;
    }
    get pushRules() {
        return this._pushRules;
    }
    putPushRules(value) {
        this._pushRules.internalValue = value;
    }
    resetPushRules() {
        this._pushRules.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushRulesInput() {
        return this._pushRules.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_merge_on_skipped_pipeline: cdktf.booleanToTerraform(this._allowMergeOnSkippedPipeline),
            analytics_access_level: cdktf.stringToTerraform(this._analyticsAccessLevel),
            approvals_before_merge: cdktf.numberToTerraform(this._approvalsBeforeMerge),
            archive_on_destroy: cdktf.booleanToTerraform(this._archiveOnDestroy),
            archived: cdktf.booleanToTerraform(this._archived),
            auto_cancel_pending_pipelines: cdktf.stringToTerraform(this._autoCancelPendingPipelines),
            auto_devops_deploy_strategy: cdktf.stringToTerraform(this._autoDevopsDeployStrategy),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            autoclose_referenced_issues: cdktf.booleanToTerraform(this._autocloseReferencedIssues),
            build_coverage_regex: cdktf.stringToTerraform(this._buildCoverageRegex),
            build_git_strategy: cdktf.stringToTerraform(this._buildGitStrategy),
            build_timeout: cdktf.numberToTerraform(this._buildTimeout),
            builds_access_level: cdktf.stringToTerraform(this._buildsAccessLevel),
            ci_config_path: cdktf.stringToTerraform(this._ciConfigPath),
            ci_default_git_depth: cdktf.numberToTerraform(this._ciDefaultGitDepth),
            ci_forward_deployment_enabled: cdktf.booleanToTerraform(this._ciForwardDeploymentEnabled),
            container_registry_access_level: cdktf.stringToTerraform(this._containerRegistryAccessLevel),
            container_registry_enabled: cdktf.booleanToTerraform(this._containerRegistryEnabled),
            default_branch: cdktf.stringToTerraform(this._defaultBranch),
            description: cdktf.stringToTerraform(this._description),
            emails_disabled: cdktf.booleanToTerraform(this._emailsDisabled),
            external_authorization_classification_label: cdktf.stringToTerraform(this._externalAuthorizationClassificationLabel),
            forking_access_level: cdktf.stringToTerraform(this._forkingAccessLevel),
            group_with_project_templates_id: cdktf.numberToTerraform(this._groupWithProjectTemplatesId),
            id: cdktf.stringToTerraform(this._id),
            import_url: cdktf.stringToTerraform(this._importUrl),
            initialize_with_readme: cdktf.booleanToTerraform(this._initializeWithReadme),
            issues_access_level: cdktf.stringToTerraform(this._issuesAccessLevel),
            issues_enabled: cdktf.booleanToTerraform(this._issuesEnabled),
            issues_template: cdktf.stringToTerraform(this._issuesTemplate),
            lfs_enabled: cdktf.booleanToTerraform(this._lfsEnabled),
            merge_commit_template: cdktf.stringToTerraform(this._mergeCommitTemplate),
            merge_method: cdktf.stringToTerraform(this._mergeMethod),
            merge_pipelines_enabled: cdktf.booleanToTerraform(this._mergePipelinesEnabled),
            merge_requests_access_level: cdktf.stringToTerraform(this._mergeRequestsAccessLevel),
            merge_requests_enabled: cdktf.booleanToTerraform(this._mergeRequestsEnabled),
            merge_requests_template: cdktf.stringToTerraform(this._mergeRequestsTemplate),
            merge_trains_enabled: cdktf.booleanToTerraform(this._mergeTrainsEnabled),
            mirror: cdktf.booleanToTerraform(this._mirror),
            mirror_overwrites_diverged_branches: cdktf.booleanToTerraform(this._mirrorOverwritesDivergedBranches),
            mirror_trigger_builds: cdktf.booleanToTerraform(this._mirrorTriggerBuilds),
            name: cdktf.stringToTerraform(this._name),
            namespace_id: cdktf.numberToTerraform(this._namespaceId),
            only_allow_merge_if_all_discussions_are_resolved: cdktf.booleanToTerraform(this._onlyAllowMergeIfAllDiscussionsAreResolved),
            only_allow_merge_if_pipeline_succeeds: cdktf.booleanToTerraform(this._onlyAllowMergeIfPipelineSucceeds),
            only_mirror_protected_branches: cdktf.booleanToTerraform(this._onlyMirrorProtectedBranches),
            operations_access_level: cdktf.stringToTerraform(this._operationsAccessLevel),
            packages_enabled: cdktf.booleanToTerraform(this._packagesEnabled),
            pages_access_level: cdktf.stringToTerraform(this._pagesAccessLevel),
            path: cdktf.stringToTerraform(this._path),
            pipelines_enabled: cdktf.booleanToTerraform(this._pipelinesEnabled),
            printing_merge_request_link_enabled: cdktf.booleanToTerraform(this._printingMergeRequestLinkEnabled),
            public_builds: cdktf.booleanToTerraform(this._publicBuilds),
            remove_source_branch_after_merge: cdktf.booleanToTerraform(this._removeSourceBranchAfterMerge),
            repository_access_level: cdktf.stringToTerraform(this._repositoryAccessLevel),
            repository_storage: cdktf.stringToTerraform(this._repositoryStorage),
            request_access_enabled: cdktf.booleanToTerraform(this._requestAccessEnabled),
            requirements_access_level: cdktf.stringToTerraform(this._requirementsAccessLevel),
            resolve_outdated_diff_discussions: cdktf.booleanToTerraform(this._resolveOutdatedDiffDiscussions),
            security_and_compliance_access_level: cdktf.stringToTerraform(this._securityAndComplianceAccessLevel),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            skip_wait_for_default_branch_protection: cdktf.booleanToTerraform(this._skipWaitForDefaultBranchProtection),
            snippets_access_level: cdktf.stringToTerraform(this._snippetsAccessLevel),
            snippets_enabled: cdktf.booleanToTerraform(this._snippetsEnabled),
            squash_commit_template: cdktf.stringToTerraform(this._squashCommitTemplate),
            squash_option: cdktf.stringToTerraform(this._squashOption),
            tags: cdktf.listMapper(cdktf.stringToTerraform)(this._tags),
            template_name: cdktf.stringToTerraform(this._templateName),
            template_project_id: cdktf.numberToTerraform(this._templateProjectId),
            topics: cdktf.listMapper(cdktf.stringToTerraform)(this._topics),
            use_custom_template: cdktf.booleanToTerraform(this._useCustomTemplate),
            visibility_level: cdktf.stringToTerraform(this._visibilityLevel),
            wiki_access_level: cdktf.stringToTerraform(this._wikiAccessLevel),
            wiki_enabled: cdktf.booleanToTerraform(this._wikiEnabled),
            container_expiration_policy: projectContainerExpirationPolicyToTerraform(this._containerExpirationPolicy.internalValue),
            push_rules: projectPushRulesToTerraform(this._pushRules.internalValue),
        };
    }
}
exports.Project = Project;
_c = JSII_RTTI_SYMBOL_1;
Project[_c] = { fqn: "@cdktf/provider-gitlab.Project", version: "1.0.2" };
// =================
// STATIC PROPERTIES
// =================
Project.tfResourceType = "gitlab_project";
//# sourceMappingURL=data:application/json;base64,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