"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-route53-integ');
const vpc = new ec2.Vpc(stack, 'VPC', { maxAzs: 1 });
const privateZone = new lib_1.PrivateHostedZone(stack, 'PrivateZone', {
    zoneName: 'cdk.local', vpc
});
const publicZone = new lib_1.PublicHostedZone(stack, 'PublicZone', {
    zoneName: 'cdk.test'
});
const publicSubZone = new lib_1.PublicHostedZone(stack, 'PublicSubZone', {
    zoneName: 'sub.cdk.test'
});
publicZone.addDelegation(publicSubZone);
new lib_1.TxtRecord(privateZone, 'TXT', {
    zone: privateZone,
    recordName: '_foo',
    values: [
        'Bar!',
        'Baz?'
    ],
    ttl: cdk.Duration.minutes(1)
});
new lib_1.CnameRecord(stack, 'CNAME', {
    zone: privateZone,
    recordName: 'www',
    domainName: 'server'
});
new lib_1.ARecord(stack, 'A', {
    zone: privateZone,
    recordName: 'test',
    target: lib_1.AddressRecordTarget.fromIpAddresses('1.2.3.4', '5.6.7.8')
});
new lib_1.CaaAmazonRecord(stack, 'CaaAmazon', {
    zone: publicZone
});
new cdk.CfnOutput(stack, 'PrivateZoneId', { value: privateZone.hostedZoneId });
new cdk.CfnOutput(stack, 'PublicZoneId', { value: publicZone.hostedZoneId });
app.synth();
//# sourceMappingURL=data:application/json;base64,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