"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workdocs = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [workdocs](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkdocs.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Workdocs extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [workdocs](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkdocs.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'workdocs';
        this.accessLevelList = {
            "Write": [
                "AbortDocumentVersionUpload",
                "ActivateUser",
                "AddResourcePermissions",
                "AddUserToGroup",
                "CreateComment",
                "CreateCustomMetadata",
                "CreateFolder",
                "CreateInstance",
                "CreateLabels",
                "CreateNotificationSubscription",
                "CreateUser",
                "DeactivateUser",
                "DeleteComment",
                "DeleteCustomMetadata",
                "DeleteDocument",
                "DeleteFolder",
                "DeleteFolderContents",
                "DeleteInstance",
                "DeleteLabels",
                "DeleteNotificationSubscription",
                "DeleteUser",
                "DeregisterDirectory",
                "InitiateDocumentVersionUpload",
                "RegisterDirectory",
                "RemoveAllResourcePermissions",
                "RemoveResourcePermission",
                "UpdateDocument",
                "UpdateDocumentVersion",
                "UpdateFolder",
                "UpdateInstanceAlias",
                "UpdateUser"
            ],
            "Read": [
                "CheckAlias",
                "DownloadDocumentVersion",
                "GetCurrentUser",
                "GetDocument",
                "GetDocumentPath",
                "GetDocumentVersion",
                "GetFolder",
                "GetFolderPath",
                "GetResources"
            ],
            "List": [
                "DescribeActivities",
                "DescribeAvailableDirectories",
                "DescribeComments",
                "DescribeDocumentVersions",
                "DescribeFolderContents",
                "DescribeGroups",
                "DescribeInstances",
                "DescribeNotificationSubscriptions",
                "DescribeResourcePermissions",
                "DescribeRootFolders",
                "DescribeUsers"
            ]
        };
    }
    /**
     * Grants permission to abort the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AbortDocumentVersionUpload.html
     */
    toAbortDocumentVersionUpload() {
        this.to('workdocs:AbortDocumentVersionUpload');
        return this;
    }
    /**
     * Grants permission to activate the specified user. Only active users can access Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_ActivateUser.html
     */
    toActivateUser() {
        this.to('workdocs:ActivateUser');
        return this;
    }
    /**
     * Grants permission to create a set of permissions for the specified folder or document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AddResourcePermissions.html
     */
    toAddResourcePermissions() {
        this.to('workdocs:AddResourcePermissions');
        return this;
    }
    /**
     * Grants permission to add a user to a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage_set_admin.html
     */
    toAddUserToGroup() {
        this.to('workdocs:AddUserToGroup');
        return this;
    }
    /**
     * Grants permission to check an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/cloud_quick_start.html
     */
    toCheckAlias() {
        this.to('workdocs:CheckAlias');
        return this;
    }
    /**
     * Grants permission to add a new comment to the specified document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateComment.html
     */
    toCreateComment() {
        this.to('workdocs:CreateComment');
        return this;
    }
    /**
     * Grants permission to add one or more custom properties to the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateCustomMetadata.html
     */
    toCreateCustomMetadata() {
        this.to('workdocs:CreateCustomMetadata');
        return this;
    }
    /**
     * Grants permission to create a folder with the specified name and parent folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateFolder.html
     */
    toCreateFolder() {
        this.to('workdocs:CreateFolder');
        return this;
    }
    /**
     * Grants permission to create an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toCreateInstance() {
        this.to('workdocs:CreateInstance');
        return this;
    }
    /**
     * Grants permission to add labels to the given resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateLabels.html
     */
    toCreateLabels() {
        this.to('workdocs:CreateLabels');
        return this;
    }
    /**
     * Grants permission to configure WorkDocs to use Amazon SNS notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateNotificationSubscription.html
     */
    toCreateNotificationSubscription() {
        this.to('workdocs:CreateNotificationSubscription');
        return this;
    }
    /**
     * Grants permission to create a user in a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        this.to('workdocs:CreateUser');
        return this;
    }
    /**
     * Grants permission to deactivate the specified user, which revokes the user's access to Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeactivateUser.html
     */
    toDeactivateUser() {
        this.to('workdocs:DeactivateUser');
        return this;
    }
    /**
     * Grants permission to delete the specified comment from the document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteComment.html
     */
    toDeleteComment() {
        this.to('workdocs:DeleteComment');
        return this;
    }
    /**
     * Grants permission to delete custom metadata from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteCustomMetadata.html
     */
    toDeleteCustomMetadata() {
        this.to('workdocs:DeleteCustomMetadata');
        return this;
    }
    /**
     * Grants permission to permanently delete the specified document and its associated metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocument.html
     */
    toDeleteDocument() {
        this.to('workdocs:DeleteDocument');
        return this;
    }
    /**
     * Grants permission to permanently delete the specified folder and its contents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolder.html
     */
    toDeleteFolder() {
        this.to('workdocs:DeleteFolder');
        return this;
    }
    /**
     * Grants permission to delete the contents of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolderContents.html
     */
    toDeleteFolderContents() {
        this.to('workdocs:DeleteFolderContents');
        return this;
    }
    /**
     * Grants permission to delete an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    toDeleteInstance() {
        this.to('workdocs:DeleteInstance');
        return this;
    }
    /**
     * Grants permission to delete one or more labels from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteLabels.html
     */
    toDeleteLabels() {
        this.to('workdocs:DeleteLabels');
        return this;
    }
    /**
     * Grants permission to delete the specified subscription from the specified organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteNotificationSubscription.html
     */
    toDeleteNotificationSubscription() {
        this.to('workdocs:DeleteNotificationSubscription');
        return this;
    }
    /**
     * Grants permission to delete the specified user from a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        this.to('workdocs:DeleteUser');
        return this;
    }
    /**
     * Grants permission to deregister a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    toDeregisterDirectory() {
        this.to('workdocs:DeregisterDirectory');
        return this;
    }
    /**
     * Grants permission to fetch user activities in a specified time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeActivities.html
     */
    toDescribeActivities() {
        this.to('workdocs:DescribeActivities');
        return this;
    }
    /**
     * Grants permission to describe available directories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toDescribeAvailableDirectories() {
        this.to('workdocs:DescribeAvailableDirectories');
        return this;
    }
    /**
     * Grants permission to list all the comments for the specified document version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeComments.html
     */
    toDescribeComments() {
        this.to('workdocs:DescribeComments');
        return this;
    }
    /**
     * Grants permission to retrieve the document versions for the specified document.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeDocumentVersions.html
     */
    toDescribeDocumentVersions() {
        this.to('workdocs:DescribeDocumentVersions');
        return this;
    }
    /**
     * Grants permission to describe the contents of the specified folder, including its documents and sub-folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeFolderContents.html
     */
    toDescribeFolderContents() {
        this.to('workdocs:DescribeFolderContents');
        return this;
    }
    /**
     * Grants permission to describe the user groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeGroups.html
     */
    toDescribeGroups() {
        this.to('workdocs:DescribeGroups');
        return this;
    }
    /**
     * Grants permission to describe instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toDescribeInstances() {
        this.to('workdocs:DescribeInstances');
        return this;
    }
    /**
     * Grants permission to list the specified notification subscriptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeNotificationSubscriptions.html
     */
    toDescribeNotificationSubscriptions() {
        this.to('workdocs:DescribeNotificationSubscriptions');
        return this;
    }
    /**
     * Grants permission to view a description of a specified resource's permissions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeResourcePermissions.html
     */
    toDescribeResourcePermissions() {
        this.to('workdocs:DescribeResourcePermissions');
        return this;
    }
    /**
     * Grants permission to describe the root folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeRootFolders.html
     */
    toDescribeRootFolders() {
        this.to('workdocs:DescribeRootFolders');
        return this;
    }
    /**
     * Grants permission to view a description of the specified users. You can describe all users or filter the results (for example, by status or organization).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeUsers.html
     */
    toDescribeUsers() {
        this.to('workdocs:DescribeUsers');
        return this;
    }
    /**
     * Grants permission to download a specified document version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    toDownloadDocumentVersion() {
        this.to('workdocs:DownloadDocumentVersion');
        return this;
    }
    /**
     * Grants permission to retrieve the details of the current user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetCurrentUser.html
     */
    toGetCurrentUser() {
        this.to('workdocs:GetCurrentUser');
        return this;
    }
    /**
     * Grants permission to retrieve the specified document object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocument.html
     */
    toGetDocument() {
        this.to('workdocs:GetDocument');
        return this;
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the requested document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentPath.html
     */
    toGetDocumentPath() {
        this.to('workdocs:GetDocumentPath');
        return this;
    }
    /**
     * Grants permission to retrieve version metadata for the specified document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    toGetDocumentVersion() {
        this.to('workdocs:GetDocumentVersion');
        return this;
    }
    /**
     * Grants permission to retrieve the metadata of the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolder.html
     */
    toGetFolder() {
        this.to('workdocs:GetFolder');
        return this;
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolderPath.html
     */
    toGetFolderPath() {
        this.to('workdocs:GetFolderPath');
        return this;
    }
    /**
     * Grants permission to get a collection of resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetResources.html
     */
    toGetResources() {
        this.to('workdocs:GetResources');
        return this;
    }
    /**
     * Grants permission to create a new document object and version object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_InitiateDocumentVersionUpload.html
     */
    toInitiateDocumentVersionUpload() {
        this.to('workdocs:InitiateDocumentVersionUpload');
        return this;
    }
    /**
     * Grants permission to register a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/existing-dir-setup.html
     */
    toRegisterDirectory() {
        this.to('workdocs:RegisterDirectory');
        return this;
    }
    /**
     * Grants permission to remove all the permissions from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveAllResourcePermissions.html
     */
    toRemoveAllResourcePermissions() {
        this.to('workdocs:RemoveAllResourcePermissions');
        return this;
    }
    /**
     * Grants permission to remove the permission for the specified principal from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveResourcePermission.html
     */
    toRemoveResourcePermission() {
        this.to('workdocs:RemoveResourcePermission');
        return this;
    }
    /**
     * Grants permission to update the specified attributes of the specified document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocument.html
     */
    toUpdateDocument() {
        this.to('workdocs:UpdateDocument');
        return this;
    }
    /**
     * Grants permission to change the status of the document version to ACTIVE.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocumentVersion.html
     */
    toUpdateDocumentVersion() {
        this.to('workdocs:UpdateDocumentVersion');
        return this;
    }
    /**
     * Grants permission to update the specified attributes of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateFolder.html
     */
    toUpdateFolder() {
        this.to('workdocs:UpdateFolder');
        return this;
    }
    /**
     * Grants permission to update an instance alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toUpdateInstanceAlias() {
        this.to('workdocs:UpdateInstanceAlias');
        return this;
    }
    /**
     * Grants permission to update the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser() {
        this.to('workdocs:UpdateUser');
        return this;
    }
}
exports.Workdocs = Workdocs;
//# sourceMappingURL=data:application/json;base64,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