"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Applicationinsights = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [applicationinsights](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_cloudwatchapplicationinsights.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Applicationinsights extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [applicationinsights](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_cloudwatchapplicationinsights.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'applicationinsights';
        this.accessLevelList = {
            "Write": [
                "CreateApplication",
                "CreateComponent",
                "DeleteApplication",
                "DeleteComponent",
                "UpdateApplication",
                "UpdateComponent",
                "UpdateComponentConfiguration"
            ],
            "Read": [
                "DescribeApplication",
                "DescribeComponent",
                "DescribeComponentConfiguration",
                "DescribeComponentConfigurationRecommendation",
                "DescribeObservation",
                "DescribeProblem",
                "DescribeProblemObservations"
            ],
            "List": [
                "ListApplications",
                "ListComponents",
                "ListProblems"
            ]
        };
    }
    /**
     * Creates an application from a resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        this.to('applicationinsights:CreateApplication');
        return this;
    }
    /**
     * Creates a component from a group of resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateComponent.html
     */
    toCreateComponent() {
        this.to('applicationinsights:CreateComponent');
        return this;
    }
    /**
     * Deletes an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication() {
        this.to('applicationinsights:DeleteApplication');
        return this;
    }
    /**
     * Deletes a component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteComponent.html
     */
    toDeleteComponent() {
        this.to('applicationinsights:DeleteComponent');
        return this;
    }
    /**
     * Describes an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeApplication.html
     */
    toDescribeApplication() {
        this.to('applicationinsights:DescribeApplication');
        return this;
    }
    /**
     * Describes a component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponent.html
     */
    toDescribeComponent() {
        this.to('applicationinsights:DescribeComponent');
        return this;
    }
    /**
     * Describes a component configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfiguration.html
     */
    toDescribeComponentConfiguration() {
        this.to('applicationinsights:DescribeComponentConfiguration');
        return this;
    }
    /**
     * Describe the recommended application component configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfigurationRecommendation.html
     */
    toDescribeComponentConfigurationRecommendation() {
        this.to('applicationinsights:DescribeComponentConfigurationRecommendation');
        return this;
    }
    /**
     * Describes an observation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeObservation.html
     */
    toDescribeObservation() {
        this.to('applicationinsights:DescribeObservation');
        return this;
    }
    /**
     * Describes a problem
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblem.html
     */
    toDescribeProblem() {
        this.to('applicationinsights:DescribeProblem');
        return this;
    }
    /**
     * Describes the observation in a problem
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblemObservations.html
     */
    toDescribeProblemObservations() {
        this.to('applicationinsights:DescribeProblemObservations');
        return this;
    }
    /**
     * Lists all applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListApplications.html
     */
    toListApplications() {
        this.to('applicationinsights:ListApplications');
        return this;
    }
    /**
     * List an application's components
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListComponents.html
     */
    toListComponents() {
        this.to('applicationinsights:ListComponents');
        return this;
    }
    /**
     * Lists the problems in an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListProblems.html
     */
    toListProblems() {
        this.to('applicationinsights:ListProblems');
        return this;
    }
    /**
     * Updates an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        this.to('applicationinsights:UpdateApplication');
        return this;
    }
    /**
     * Updates a component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponent.html
     */
    toUpdateComponent() {
        this.to('applicationinsights:UpdateComponent');
        return this;
    }
    /**
     * Updates a component configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponentConfiguration.html
     */
    toUpdateComponentConfiguration() {
        this.to('applicationinsights:UpdateComponentConfiguration');
        return this;
    }
}
exports.Applicationinsights = Applicationinsights;
//# sourceMappingURL=data:application/json;base64,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