# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['idm_lp',
 'idm_lp.commands',
 'idm_lp.commands.members_manager',
 'idm_lp.database',
 'idm_lp.error_handlers']

package_data = \
{'': ['*']}

install_requires = \
['APScheduler>=3.9.1,<4.0.0',
 'pydantic==1.7.3',
 'python-rucaptcha==3.0',
 'vkbottle==2.7.12']

setup_kwargs = {
    'name': 'idm-lp',
    'version': '1.13.6',
    'description': 'LP модуль позволяет работать приемнику сигналов «IDM multi» работать в любых чатах. Так же он добавляет игнор, глоигнор, мут и алиасы.',
    'long_description': '### IDM multi - LP module\n![PyPI](https://img.shields.io/pypi/v/idm-lp)\n![GitHub](https://img.shields.io/github/license/IDM-Team/idm_lp)\n![GitHub repo size](https://img.shields.io/github/repo-size/IDM-Team/idm_lp)\n[![Downloads](https://pepy.tech/badge/idm-lp)](https://pepy.tech/project/idm-lp)\n\nLP модуль позволяет работать приемнику сигналов «IDM multi» работать в любых чатах.\nТак же он добавляет игнор, глоигнор, мут и алиасы.\n\n<!--\n4: 252535322122234232\n  1  2  3  4  5\n1 a  b  c  d  e\n2 f  g  h  ij k\n3 l  m  n  o  p\n4 q  r  s  y  u\n5 v  w  x  y  z\n-->\n\n## Оглавление\n1. [Установка](#установка)\n2. [Аргументы запуска](#аргументы-запуска)\n3. [Структура конфигурационного файла config.json](#структура-кофигурационного-файла-configjson)\n4. [Команды модуля ЛП](#команды-модуля-лп)\n\n## Установка\n### Heroku \n_Инструкцию ~~любезно~~ предоставил [Юн Дэмин](https://vk.com/id616052556)_\n\n`<nick>` - ваш ник в гитхабе.<br>\n`<name>` - имя репозитория.\n\n1. Регистрируемся на [GitHub](https://github.com)\n2. Создаем закрытый репозиторий\n    ![](https://sun9-5.userapi.com/ZdunWUy0_UtICPscb8DDDXlKXrYpjY2GRHZK1Q/-tt19NoXdC4.jpg)\n3. Заходим в термукс или гит на ПК и пишем следующие команды:\n    ```shell script\n    git clone --bare https://github.com/lordralinc/idm_lp.git\n    cd idm_lp.git\n    git push --mirror https://github.com/<nick>/<name>.git\n    ```\n    _Может появится просьба войти в аккаунт, вводим логин и пароль от аккаунта и все готово_\n    ```shell script\n    cd ..\n    rm -rf idm_lp.git\n    ```\n4. Заходим на наш закрытый репозиторий и там где написано `2.0` изменяем на `master`.<br>\n5. Далее заходим в `config.json`, вставляем токен от Kate Mobile и секретный код IDM.\n6. Регистрируемся на [Heroku](https://heroku.com) и выбираем python.\n7. Переходим по ссылке: [dashboard.heroku.com/apps](https://dashboard.heroku.com/apps) и создаем приложение. \n    Выбираем европу и название приложение любое, чтоб угодить хероку.\n8. После создания мы окажемся в панели управления, нажимаем на GitHub и входим в аккаунт.\n    ![](https://sun9-47.userapi.com/pLLeZCAo1P4sQR1brlFdBwHtfBWhBQGfuILR-g/edHTCYYZ2CE.jpg)\n9. Нам нужно имя закрытого репозитория, вставляем и нажимаем `Search`, выбираем нужный нам репозиторий и нажимаем на `Connect`.\n10. Листаем вниз и видим кнопку `Deploy Branch`, рядом с кнопкой будет `2.0`, нажимаем и выбираем `master`, далее тыкаем на кнопку `Deploy Branch` и ждем.\n11. Вверху нажимаем на кнопку `Resources`.\n12. Нажимаем на карандашик слева, включаем и тыкаем на `Confirm`.\n13. Переходим обратно в `Deploy` и мотаем вниз делаем все как по пункту 10\n\n### Windows\n\nСкачиваем и устанавливаем:\n1. [Visual C++](https://support.microsoft.com/ru-ru/help/2977003/the-latest-supported-visual-c-downloads) (Если не установленно)\n2. [Python](https://www.python.org/ftp/python/3.7.7/python-3.7.7-amd64.exe)\n\nОткрываем CMD (Win + R и вводим cmd)\nВводим команды:\n```shell script\ncd путь_до_папки\npy -m venv env\nenv\\Scripts\\activate.bat\npy -m pip install -U idm_lp\npy -m idm_lp setup\n\nЗапуск:\ncd путь_до_папки\nenv\\Scripts\\activate.bat\ncd idm_lp\npy -m idm_lp \n```\n\n### Linux (Ubuntu 16.04 Server)\n```shell script\nsudo apt-get update -y\nsudo apt-get install build-essential tk-dev libncurses5-dev libncursesw5-dev libreadline6-dev libdb5.3-dev libgdbm-dev libsqlite3-dev libssl-dev libbz2-dev libexpat1-dev liblzma-dev zlib1g-dev libffi-dev -y\n\nwget https://www.python.org/ftp/python/3.7.7/Python-3.7.7.tar.xz\ntar xf Python-3.7.7.tar.xz\ncd Python-3.7.7\n./configure\nmake -j {число ядер} && sudo make altinstall\n```\n`{число ядер}` можно узнать командой `nproc`\n```shell script\ncd /root/\nsudo apt-get install git nano -y\n\npython3.7 -m venv env\n/root/env/bin/pip install idm_lp\n/root/env/bin/python3.7 -m idm_lp setup\n```\nСоздаем сервис для запуска\n```shell script\nnano /etc/systemd/system/idmlp.service\n```\nВводим\n```shell script\n[Unit]\nDescription=LP\nAfter=network.target\n\n[Service]\nUser=root\nGroup=www-data\nWorkingDirectory=/root/idm_lp\nExecStart=/root/env/bin/python3.7 -m idm_lp --config_path /root/idm_lp/config.json\n\n[Install]\nWantedBy=multi-user.target\n```\nНажимаем `ctrl + x` выходим\n```shell script\nsystemctl enable idmlp\nservice idmlp start\n```\n\n## Аргументы запуска \n- `--logger_level [DEBUG | INFO | WARNING | ERROR | CRITICAL]` — Уровень логгирования\n- `--config_path CONFIG_PATH` — Путь до файла с конфингом\n- `--use_app_data` — Использовать папку AppData/IDM (Windows). При использовании этой настройки AppData/IDM и config_path складываются\n- `--log_to_path` — Логи в файл\n- `--base_domain BASE_DOMAIN` — Базовый домен\n\n\n## Структура конфигурационного файла config.json\n\n- `tokens`            - Токены вк в количестве 3х штук. Получить можно [здесь](https://oauth.vk.com/authorize?client_id=2685278&scope=1073737727&redirect_uri=https://oauth.vk.com/blank.html&display=page&response_type=token&revoke=1)\n- `secret_code`       - Секретный код дежурного. Можно получить на странице настроек дежурного в графе `секретный код`\n- `service_prefixes`  - Префиксы для выполнения команд модуля ЛП (добавление в мутлист, создание алиасов и тд.)\n- `self_prefixes`     - Префиксы для высылки команд для себя (аналог !с .с ...)\n- `duty_prefixes`     - Префиксы для высылки команд для дежурного (аналог !д .д ...)\n\n**! Остальные поля заполняются программно**\n\n![](https://sun1-86.userapi.com/10hU2v5Z8sV0ZBeDGWtOn4alEdiYZy2qY4_Ajw/_BeWOFmtcdw.jpg "Пример заполнения config.json")\n\n## Команды модуля ЛП\n- `{сервисный префикс}` пинг/кинг/пиу — пинг\n- `{сервисный префикс}` инфо — информация о модуле ЛП\n***\n- `{сервисный префикс}` префиксы свои — просмотр своих префиксов\n- `{сервисный префикс}` префиксы дежурный — просмотр префиксов для дежурного\n- `{сервисный префикс}` +префикс `[свой/дежурный]` — создание префикса\n- `{сервисный префикс}` -префикс `[свой/дежурный]` — удаление префикса\n***\n- `{сервисный префикс}` алиасы - просмотр алиасов\n- `{сервисный префикс}` +алиас `{имя}` {enter} `{команда которую получает модуль ЛП}` {enter} `{команда которую отсылает модуль ЛП}`  — создание алиаса\n- `{сервисный префикс}` -алиас `{имя}` — удаление алиаса\n- `{сервисный префикс}` алиасы паки — просмотр паков алиасов\n- `{сервисный префикс}` алиасы пак `{имя пака}` — просмотр пака алиасов\n- `{сервисный префикс}` алиасы импорт `{имя пака}` — импорт пака алиасов\n***\n- `{сервисный префикс}` игнорлист — просмотр игнорлиста\n- `{сервисный префикс}` игнорлист все — просмотр игнорлиста по всем чатам\n- `{сервисный префикс}` +игнор `[{ссылка}/{упоминание}/{реплай}]` — добавить в игнорлист\n- `{сервисный префикс}` -игнор `[{ссылка}/{упоминание}/{реплай}]` — удалить из игнорлиста\n***\n- `{сервисный префикс}` глоигнорлист — просмотр глоигнорлиста\n- `{сервисный префикс}` +глоигнор `[{ссылка}/{упоминание}/{реплай}]` — добавить в глоигнорлист\n- `{сервисный префикс}` -глоигнор `[{ссылка}/{упоминание}/{реплай}]` — удалить из глоигнорлиста\n***\n- `{сервисный префикс}` мутлист — просмотр мутлиста\n- `{сервисный префикс}` мутлист все — просмотр мутлиста по всем чатам\n- `{сервисный префикс}` +мут `[{ссылка}/{упоминание}/{реплай}]` `{задержка}` — добавить в мутлист\n- `{сервисный префикс}` -мут `[{ссылка}/{упоминание}/{реплай}]` — удалить из мутлиста\n***\n- `{сервисный префикс}` довы — просмотр доверенных пользователей\n- `{сервисный префикс}` +дов `[{ссылка}/{упоминание}/{реплай}]` — добавить в дов-лист\n- `{сервисный префикс}` -дов `[{ссылка}/{упоминание}/{реплай}]` — удалить из дов-листа\n***\n- `{сервисный префикс}` regex — Просмотр шаблонов для удаления\n- `{сервисный префикс}` +regex `{имя}` `{regex}` `{для всех:да|нет}` — Добавить шаблон\n- `{сервисный префикс}` -regex `{имя}` — Удалить шаблон\n***\n- `{сервисный префикс}` +потворялка — включить повторялку\n- `{сервисный префикс}` -потворялка — выключить повторялку\n- `{триггер повторялки}``{сообщение}` — повторить сообщение\n***\n- `{сервисный префикс}` eval/exec `{script}` — выполнение скрипта\n***\n- `{сервисный префикс}` -уведы — модуль будет удалять упоминания типа `@all`, `@online`...\n- `{сервисный префикс}` +уведы — не будет удалять упоминания типа `@all`, `@online`...\n***\n- `{сервисный префикс}` рп — просмотр РП команд\n- `{сервисный префикс}` +мрп `{имя}` `{падеж}`\\n`{форматер для мужчин}`\\n`{форматер для женщин}`\\n`{окончание для всех}` — просмотр РП команд\n- `{сервисный префикс}` -мрп `{имя}` — просмотр РП команд\n***\n- `{сервисный префикс}` секретный код `{код}` — установка секретного кода\n- `{сервисный префикс}` токен каптчи `{токен}` — установка токена рукаптчи\n***\n- `{сервисный префикс}` +автовыход — включить автовыход из бесед в которые вас пригласили\n- `{сервисный префикс}` -автовыход — выключить автовыход из бесед в которые вас пригласили\n- `{сервисный префикс}` автовыход +удаление — удалять диалог при выходе\n- `{сервисный префикс}` автовыход -удаление — неудалять диалог при выходе\n- `{сервисный префикс}` автовыход +чс — включить добавление в ЧС пригласившего \n- `{сервисный префикс}` автовыход -чс — выключить добавление в ЧС пригласившего \n***\n- `{сервисный префикс}` +слоумо `{время}`\\n`{текст}` — установка слоумо режима\n- `{сервисный префикс}` -слоумо — удаление слоумо режима\n- `{сервисный префикс}` слоумо — просмотр настроек слоумо режима\n- `{сервисный префикс}` слоумо +белый список `{пользователь}` — добавление пользователя в белый список\n- `{сервисный префикс}` слоумо -белый список `{пользователь}` — удаление пользователя из белого списка\n- `{сервисный префикс}` слоумо время `{время}` — изменение времени задержки\n- `{сервисный префикс}` слоумо текст `{текст}` — изменение текста предупреждения\n***\n- `{сервисный префикс}` +добавление `{текст}` — включить отправку запросов в друзья, пользователям, которые заходят в чат. При этом будет отправляться приветственный `{текст}`.\n- `{сервисный префикс}` -добавление — отключить отправку запросов в друзья, пользователям, которые заходят в чат.\n***\n- `{сервисный префикс}` выключать уведы — включить выключение уведомлений при входе в беседу \n- `{сервисный префикс}` не выключать уведы — выключить выключение уведомлений при входе в беседу \n***\n- `{сервисный префикс}` +заражение — включить ответное заражение.\n- `{сервисный префикс}` -заражение — отключить ответное заражение.\n***\n- `{сервисный префикс}` +автозаражение — включить автоматическое.\n- `{сервисный префикс}` -автозаражение — отключить автоматическое.\n- `{сервисный префикс}` автозаражение интервал `{интервал}` — установить интервал автоматического заражения.\n- `{сервисный префикс}` автозаражение аргумент `{аргумент}` — установить аргумент автоматического заражения.\n- `{сервисный префикс}` автозаражение установить чат — установить чат автоматического заражения.\n- `{сервисный префикс}` автозаражение — информация об автоматическом заражении.\n***\n- `{сервисный префикс}` +nometa — включить nometa.\n- `{сервисный префикс}` -nometa — отключить nometa.\n- `{сервисный префикс}` nometa сообщение `{текст}` — изменить текст сообщения.\n- `{сервисный префикс}` nometa задержка `{задержка}` — изменить задержку.',
    'author': 'lordralinc',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://idmduty.ru',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
