"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_events_1 = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'my-stack-dev', { env });
        const kaniko = new _1.Kaniko(stack, 'KanikoDemo', {
            context: 'git://github.com/pahud/vscode.git',
            contextSubPath: './.devcontainer',
            fargateSpot: true,
        });
        // build it once
        kaniko.buildImage('once');
        // schedule the build every day 0:00AM
        kaniko.buildImage('everyday', aws_events_1.Schedule.cron({
            minute: '0',
            hour: '0',
        }));
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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