# Generated by Django 3.2.4 on 2022-03-23 03:57

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('custom', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('population', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CommunityLeadership',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('startMandate', models.DateField(null=True)),
                ('endMandate', models.DateField(null=True)),
                ('status', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=4, null=True)),
                ('observation', models.TextField(blank=True, null=True)),
                ('aldeia', models.CharField(blank=True, max_length=50, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
            ],
            options={
                'verbose_name_plural': 'A7. Livru Lideransa Komunitaria',
            },
        ),
        migrations.CreateModel(
            name='Decision',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('decision_type', models.CharField(choices=[('Konsellu Suku', 'Konsellu Suku'), ('Xefe Suku', 'Xefe Suku')], max_length=20)),
                ('meeting_date', models.DateField()),
                ('decision_number', models.CharField(max_length=100)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('observation', models.TextField(blank=True, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A1 & A2. Livru Desizaun Suku',
            },
        ),
        migrations.CreateModel(
            name='Inventory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.CharField(choices=[('Mobiliáriu', 'Mobiliáriu'), ('Transporte', 'Transporte'), ('Elektróniku', 'Elektróniku'), ('Rai', 'Rai'), ('Uma', 'Uma'), ('Nesesidade Bázika', 'Nesesidade Bázika'), ('Animál', 'Animál'), ('Plantas', 'Plantas'), ('Seluk', 'Seluk')], max_length=30, null=True, verbose_name='Kategoria')),
                ('supplier', models.CharField(max_length=100, null=True, verbose_name='Fontes/Se mak fo')),
                ('name', models.CharField(max_length=100, verbose_name='Naran Inventária')),
                ('recieve_date', models.DateField()),
                ('condition', models.CharField(choices=[('Diak', 'Diak'), ('Diak Natoon', 'Diak Natoon'), ('Aat', 'Aat'), ('Aat Total', 'Aat Total')], max_length=30, null=True)),
                ('nu_serie', models.CharField(max_length=100, verbose_name='Nu Seri')),
                ('quantity', models.IntegerField(verbose_name='Kuantidade')),
                ('unitprice', models.DecimalField(decimal_places=2, max_digits=10, null=True, verbose_name='Folin Sosa')),
                ('brand', models.CharField(max_length=100, verbose_name='Marka')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A3. Livru Inventáriu Suku',
            },
        ),
        migrations.CreateModel(
            name='LetterOut',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('letter_date', models.DateField()),
                ('letter_number', models.CharField(max_length=100, verbose_name='Nú. Karta')),
                ('subject', models.CharField(max_length=200, verbose_name='Asuntu Karta')),
                ('destination', models.CharField(max_length=100, verbose_name='Diriji ba se')),
                ('attached_file', models.FileField(blank=True, null=True, upload_to='file/letterOut/', verbose_name='Upload File')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A4. Livru Ajenda Karta Sai',
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'verbose_name_plural': 'A7. Kargu',
            },
        ),
        migrations.CreateModel(
            name='UsedInventory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('used_date', models.DateField()),
                ('responsible', models.CharField(choices=[('Xefe Suku', 'Xefe Suku'), ('PAAs', 'PAAs'), ('Xefe Aldeia', 'Xefe Aldeia'), ('Populasaun', 'Populasaun')], max_length=50, null=True)),
                ('place', models.CharField(max_length=100)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'A3. Inventáriu Uzadu',
            },
        ),
        migrations.CreateModel(
            name='VotingResult',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('decision_on', models.TextField(null=True)),
                ('vote_afavor', models.IntegerField()),
                ('vote_kontra', models.IntegerField()),
                ('vote_abstein', models.IntegerField()),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('decision', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='administration.decision')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'A1 & A2. Rezultadu Votasaun Desizaun Suku',
            },
        ),
        migrations.CreateModel(
            name='Visitor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('visitDate', models.DateField()),
                ('entryTime', models.TimeField()),
                ('outTime', models.TimeField()),
                ('name', models.CharField(max_length=100, null=True)),
                ('sex', models.CharField(choices=[('Mane', 'Mane'), ('Feto', 'Feto'), ('Seluk', 'Seluk')], max_length=10, null=True)),
                ('visitor', models.CharField(max_length=100, null=True)),
                ('subject', models.TextField(null=True)),
                ('address', models.CharField(max_length=100, null=True)),
                ('contact_number', models.CharField(max_length=20, null=True)),
                ('signature', models.CharField(blank=True, max_length=20, null=True)),
                ('observation', models.TextField(blank=True, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('deficient', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.deficient', verbose_name='Kondisaun Fíziku')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A11. Livru Bainaka Suku',
            },
        ),
        migrations.CreateModel(
            name='UsedInventoryDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField()),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('inventory', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='administration.inventory')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('used', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='administration.usedinventory')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'A3. Detallu Inventáriu Uzadu',
            },
        ),
        migrations.CreateModel(
            name='MeetingTime',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('initial_time', models.TimeField(max_length=10)),
                ('end_time', models.TimeField(max_length=10)),
                ('facilitator', models.CharField(max_length=100)),
                ('community_representative', models.CharField(max_length=100, null=True)),
                ('attach_attendence_list', models.CharField(choices=[('Sim', 'Sim'), ('Lae', 'Lae')], max_length=4)),
                ('meeting_agenda', models.TextField()),
                ('discussion', models.TextField()),
                ('decision_takes', models.TextField(null=True)),
                ('diversus', models.TextField(null=True)),
                ('prepared_by', models.CharField(max_length=100)),
                ('prepared_date', models.DateField(null=True)),
                ('aproved_date', models.DateField(null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('decision', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='administration.decision')),
                ('lideransa_komunitaria', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='administration.communityleadership')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A9. Minutas Enkontru Suku',
            },
        ),
        migrations.CreateModel(
            name='MandatePeriod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.CharField(max_length=4, null=True)),
                ('end', models.CharField(max_length=4, null=True)),
                ('status', models.CharField(choices=[('Ativu', 'Ativu'), ('Desativu', 'Desativu')], max_length=8, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'A7. Periodu Mandatu',
            },
        ),
        migrations.CreateModel(
            name='LetterOutExpedition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sent_date', models.DateField(blank=True, null=True, verbose_name='Data Haruka')),
                ('sent_to', models.CharField(blank=True, max_length=100, null=True)),
                ('recieve_name', models.CharField(blank=True, max_length=100, null=True, verbose_name='Simu husi')),
                ('recieve_date', models.DateField(blank=True, null=True, verbose_name='Data Simu')),
                ('signature', models.CharField(blank=True, max_length=20, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('letter_out', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='administration.letterout')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A6. Livru Espedisaun',
            },
        ),
        migrations.CreateModel(
            name='LetterIn',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('letter_date', models.DateField()),
                ('letter_number', models.CharField(max_length=100, verbose_name='Nú. Karta')),
                ('origin', models.CharField(max_length=100, verbose_name='Orijen Karta')),
                ('subject', models.CharField(max_length=200, verbose_name='Asuntu Karta')),
                ('attached_file', models.FileField(blank=True, null=True, upload_to='file/letterIn/', verbose_name='Upload File')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A5. Livru Ajenda Karta Tama',
            },
        ),
        migrations.CreateModel(
            name='DecisionDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attendance', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=10, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('decision', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='administration.decision')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('villageAdvise', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='administration.communityleadership')),
            ],
            options={
                'verbose_name_plural': 'A1 & A2. Detaillu Desizaun Suku',
            },
        ),
        migrations.CreateModel(
            name='Complaint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='Data Keixa')),
                ('letter_number', models.CharField(max_length=100, verbose_name='Númeru Karta')),
                ('identity_number', models.CharField(max_length=100, verbose_name='Nú. Billete Identidade')),
                ('nu_e', models.CharField(blank=True, max_length=25, null=True, verbose_name='Nú. Kartaun Eleitoral')),
                ('nu_p', models.CharField(blank=True, max_length=50, null=True, verbose_name='Nú. Pasaporte')),
                ('owner', models.CharField(max_length=100, verbose_name='Naran Keixa Nain')),
                ('sex', models.CharField(choices=[('Mane', 'Mane'), ('Feto', 'Feto'), ('Seluk', 'Seluk')], max_length=10, null=True)),
                ('subject', models.CharField(max_length=100, verbose_name='Asuntu Keixa')),
                ('address', models.CharField(max_length=100, verbose_name='Enderesu')),
                ('contact_number', models.CharField(max_length=30, verbose_name='Nú. Kontaktu')),
                ('recieve_complait_name', models.CharField(max_length=100, verbose_name='Naran Simu')),
                ('recieve_date', models.DateField(verbose_name='Data Simu')),
                ('observation', models.TextField(blank=True, null=True, verbose_name='Observasaun')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('deficient', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.deficient', verbose_name='Kondisaun Fíziku')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A10. Rejistu Keixa Suku',
            },
        ),
        migrations.AddField(
            model_name='communityleadership',
            name='period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='administration.mandateperiod'),
        ),
        migrations.AddField(
            model_name='communityleadership',
            name='population',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.population', verbose_name='Naran Lideransa'),
        ),
        migrations.AddField(
            model_name='communityleadership',
            name='position',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='administration.position'),
        ),
        migrations.AddField(
            model_name='communityleadership',
            name='user_created',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='communityleadership',
            name='village',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village'),
        ),
        migrations.AddField(
            model_name='communityleadership',
            name='year',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year'),
        ),
        migrations.CreateModel(
            name='Attendance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=500, null=True)),
                ('sex', models.CharField(choices=[('Mane', 'Mane'), ('Feto', 'Feto'), ('Seluk', 'Seluk')], max_length=10, null=True)),
                ('instituition', models.CharField(blank=True, max_length=500, null=True)),
                ('position', models.CharField(blank=True, max_length=500, null=True)),
                ('signature', models.CharField(blank=True, max_length=500, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('decision', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='administration.decision')),
                ('deficient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='population.deficient', verbose_name='Kondisaun Fíziku')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year')),
            ],
            options={
                'verbose_name_plural': 'A8. Lista Prezensa',
            },
        ),
        migrations.CreateModel(
            name='AttachedExpedition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attached_file', models.FileField(blank=True, null=True, upload_to='file/expedition/', verbose_name='Upload File')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True)),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('administrativepost', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('letter_out', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='administration.letterout')),
                ('municipality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'A6. Aneksu File Espedisaun',
            },
        ),
    ]
