#!/opt/local/bin/python2.7

import tempfile
import weakref
from six.moves import queue as Queue
import subprocess
import time
import sys
import threading
from ifigure.utils.wx3to4 import wxTaskBarIcon, TBI_DOCK, EVT_TASKBAR_LEFT_DCLICK, IconFromBitmap
import os
import wx.aui as aui
import wx

from wx.lib.embeddedimage import PyEmbeddedImage
app_logo = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAAUwAAAFLCAYAAAC9a7XnAAAABHNCSVQICAgIfAhkiAAAAAlw"
    "SFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoA"
    "ACAASURBVHic7L1/jGTZdd/3Pfe+V9XV0/Nzdzg75JA7u5yVuEtSlLIKqF8Rl5YZixYVJZFX"
    "siLYkZVYshMkim3B+QEk9CaAYSBChBgxIsGAHTgBKGQDwZEoS1YoaiVIscxoIYq2VzI5pJbk"
    "kvtjZmemp6e7q+q9e0/+OPfXe13V/Xqmd7t79nzIt1Vd9arqvlfzvnV+3XOJmaEoiqLsjTns"
    "ASiKohwXVDAVRVEGooKpKIoyEBVMRVGUgahgKoqiDEQFU1EUZSAqmIqiKANRwVQURRmICqai"
    "KMpAVDAVRVEGooKpKIoyEBVMRVGUgahgKoqiDEQFU1EUZSAqmIqiKANRwVQURRmICqaiKMpA"
    "VDAVRVEGooKpKIoyEBVMRVGUgahgKoqiDEQFU1EUZSAqmIqiKANRwVQURRmICqaiKMpAVDAV"
    "RVEGooKpKIoyEBVMRVGUgahgKoqiDEQFU1EUZSAqmIqiKANRwVQURRmICqaiKMpAVDAVRVEG"
    "ooKpKIoyEBVMRVGUgahgKoqiDEQFU1EUZSAqmIqiKANRwVQURRlIddgD2BOiEYBzhz2MYwHz"
    "K/vZ/XsJDwCo36DR3E/c+TXGnaE7P0PPrAA48waO536BP84ff/WwB7Efjr5gAn8KwK8e9iCO"
    "BUQTME/38YrfAPCBN2o49xHPAPhb+9j/3wXwiTdmKPcVMwArhz2I/aAuuaIoykBUMBVFUQai"
    "gqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIoA1HBVBRFGYgKpqIoykBUMBVFUQaigqko"
    "ijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIoA1HBVBRFGYgKpqIoykBUMBVFUQZyHJaoUI4H"
    "U8iSA0eFNQD2sAeh3F+oYCoHxTO/xvg7hz2IyPcSfg/ABw97HMr9hbrkiqIoA1HBVBRFGYgK"
    "pqIoykBUMBVFUQaigqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIoA1HBVBRFGYgKpqIo"
    "ykBUMBVFUQaigqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIoA1HBVBRFGYgKpqIoykBU"
    "MBVFUQaigqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIoA1HBVBRFGYgKpqIoykBUMBVF"
    "UQaigqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIoA6kOewDKfcNPfC/hew97EAVPHPYA"
    "lPsPFUzloHgkbIpy36IuuaIoykBUMBVFUQaigqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqY"
    "iqIoA1HBVBRFGYgKpqIoykBUMBVFUQaigqkoijIQFUxFUZSBqGAqiqIMRAVTURRlICqYiqIo"
    "A1HBVBRFGYgKpqIoykBUMBVFUQZyHJao+H0AHz3sQRwT5vvc/z8BcOqNGMh9xtV97v8c9N/s"
    "ENxhD2C/EDMf9hgURVGOBeqSK4qiDEQFU1EUZSAqmIqiKANRwVQURRmICqaiKMpAVDAVRVEG"
    "ooKpKIoyEBVMRVGUgahgKoqiDEQFU1EUZSBHfy450YcBfOKwh3FMeBjMs8F7f5I+BeB9b9xw"
    "7ht+Bh/jnxm68+mfpB8A8PNv4HjuF6brP8+XD3sQ++HoCyYwBnDhsAdxTKB97v8g9NwOYW2f"
    "+0+g53UIw3/cjwjqkiuKogxEBVNRFGUgKpiKoigDUcFUFEUZiAqmoijKQFQwFUVRBqKCqSiK"
    "MhAVTEVRlIGoYCqKogxEBVNRFGUgKpiKoigDUcFUFEUZiAqmoijKQFQwFUVRBqKCqSiKMhAV"
    "TEVRlIGoYCqKogxEBVNRFGUgx2GJioPmkcMeQMGHAPxvhz0I5UizAeCbDnsQBd8P4O8e9iAO"
    "i7eeYDK/eNhDSBC957CHoBx5/PrPH51/s6d/kq4d9hgOE3XJFUVRBqKCqSiKMhAVTEVRlIGo"
    "YCqKogxEBVNRFGUgKpiKoigDUcFUFEUZiAqmoijKQFQwFUVRBqKCqSiKMpC33tRIRRkIMwAi"
    "MBEsQENfd8pYAvsDGwft47PfaN7UYyMCM/OBfdgBoIKpvGXhvXToyMjUWxTmpYLKwKEIqbrk"
    "ylsCZhHIclu6LwAOliUTwcMQ5MIdtpHd1+57bwf6Zve2vdnH9swzC78oAqjcFu3zRqAWpnLf"
    "0hHFBZcU0y6iGdxxAPBklrzDEowlsBu8+wCOjq37Zh7bs88CH/84L9mnY2GWovlGWp8qmMp9"
    "xTLLkYEkgOkx3vlYeo/i4cLCzDz//NILnckQHaTGPf/8kfEE35Bje/LJxQL39NPAc88Rnnqq"
    "+/yzz8pzkWeeicIKIIvnGyGcKpjKsWeoSPb3Ky3MReIZX99SReiHr558svthV6/mF9uRgWsG"
    "jn4Ap08fGcE8sGOLZ+vJJ3f+GAHACy8ATzzBeOop2fv555GEtRRLoG+FvqHCqYKpHFuWCuUS"
    "kYz3S3FM+1Lv8eKyc8ZmwXzppZ0feukScOVK/ns0JrTTfR/PIpiIcOXK0RHMgzw2MPDSSzY9"
    "cOlSFrbVVeDFF4HLl+Wx06flJVFIRQz7QviGC6cKpnLsWCSUe4okCoGkBY8DgKEsmpRFc04j"
    "AiAX9qVLwLVr3QFc6zYhZ6oN6IA0jgi4ds3uveObw4EeGwCMx3Js589nMXv1VWAyAS5cYLz8"
    "MnDxImNlBQAYq6tye/UqcOUKA2A8/zx13Pquy94RznsVTRVM5dgwVCjL2+hWp5rK8jGUj/du"
    "o61ChMbUBjdv5mulqoCzZ7sDuXUrD2S0ajC7fa+HGyCgro/OdXqgxwbg/HmLmzeBmzfzYxcu"
    "MG7cAABGXcvteCy3ly+LiK6siFgCjCefZLzwAgXLk3H+fHwn+RaLGOe9iubR+SIUZQkL44tL"
    "hLIsNo+lRACBTRZIDsUoUTwZlMUyWpnxFsDUrBhUVb5WTp6U242NIm6ZjUAeTSyZA7q0iABr"
    "j8x1eqDHJj9JFare+92+zagqYH1dBPPWLQ4WqGx1DVQV49VXGRcueAAcxBJ44YWdSaIc40yi"
    "ebdF8Ufmi1CURfQz1mUip2tJhvumqLUs7wNgMkkg0xbEFaXAGkpXFoMwpZHByZMVNjflQzY3"
    "ZTDGALQgzT46YWHrgzkBIpgH9GYHwEEeGwBsbtYwHRdfRCyLGYOZsbEht8yMqsr3oxC+/DLD"
    "OcYTT3SnIT33HELiqBv3DEXx+7U2VTCVI8uyrHZfKDsudhBBz+XfBgyCLwSyI5g98UxWarjd"
    "ohWL7e0RjAGmU/nwyWT5uEerFR+YYBqCMUdGMA/02ECAtSNsb0cXG9jeBiYTTrciivn2xAmP"
    "jQ25773HrVsG3nvUNePiRY+XXyZcvChWJ8A9a3NHsoiIaD+WpgqmcuRYKpRlHLJ0vYPg+UIg"
    "430fxJKNERGVmTsdsUyvi6656X7Gtl21MGYEALBWBrOo6H02k2zs6EQFOzqYk0EGmM/HB/Nm"
    "986BHBsVd4hGsBYwRkQr3l9dZcxmSEI5HosIbm15WMtg9iDyWFvzuH1bRPPGDRHLV18lXLjg"
    "8eKLjMuXuxZnTghlS3MfoqmCqRwpdrUqqbAqTU8oySTL0sOIQCLcDyLpjemIaLrlnZZm6aJv"
    "24lF04horawA8zmhWVCLGF3L0WqF+oA0jgxhZeWA1PcAWFm7u2NbqEcENM0YxgBNEwWT0TQi"
    "lCKiHO57TKdROD2YZdvc9DBGxPPMGQeAQlwTGI/lPa9eZVy5Io89/TTj2WepL5pDUcFUjgy7"
    "ieXOWGThegfr0cPAk2zRyiwfS/fja2C6bnp83/Q5cn/TrlYwRlSibQFjdp3qwuMTNR+khbm9"
    "vXIwb3bvcDU5wGMjwJgxmgao6zJ2ycGCZ9S1x3zOIPIwhtE0IpSjkQNRFE4HZo87dwjMHidP"
    "Oty4QagqEckrVzyuXjUd0QwjQJEIGhLPVMFUDp1+FnxprJK6FqVfJIqlMMLAFfe9sUkw42PJ"
    "RY/vzYWFGT53265aEEXBpE5Wt213ime9WqM6KAvTIon1UWB0kMdGBKIxRiMgilXbyv26Fsuy"
    "bbNQGuOTK07kMJt5jMcOzCaIpgjmxgbBWtdJyPVFU9iRPd9LNFUwlUNlRxa8tCqDkOYYo8li"
    "CYLnIIbGijAGcXRkRSxJBDI+F/8uhbUUTLE8ex2NiLBJkwpEY7QtwTlCXWehXDQXfXyi5np5"
    "UmhfGEuo66NjYU5O3t2xLXJ7iQDnJqgqDkKJ5IYTMdqWAXhUlU/WpNy6IKQO87kDs8No1IJI"
    "hBMgnDwJ3L5NuHkTcI7w4IODRHMvVDCVQ2NPF5yWWZWmI4SeRDBduPVk0/2F4hmFM8U4s2vu"
    "S7c8fPaWXa3g3AREQF3LBSgXe/eAnBM/0q6MDqz0xtij5ZLT6OCOjQjwfoz5HMiCJYLpnMQw"
    "mcUdB0Qsm8ajqhyYWxC5YFm2aBoD71uMxwRjCJubgDHlFyTvL2LZ/5UbPBtIBVM5FBaJZXc2"
    "zpIYJWeLMokhgkCWWxRQsvI8dlqiIqC2mzlHL0YKwna1WsH7lVScLsJIO6zL6KqPV2sckIXJ"
    "xhKMOSBz9QAYHdyxhW6WE3gvlqVzkvSRkiGGtR5EDOdEMAGHunZoWwZzi6pqATjIPP8WxlBw"
    "wwnGAMz5C7p5U2ZnvfwyMJsBly/7TkOPgVamCqbypjNYLGHgqR+j7Ilh2NqeaLZUdYUTNrnr"
    "UWg7CSAmeGtDDLMQTxC2zKRGXa/AOUmD18HCco52WJkAUE9qPigv2lQA0ZGxMDE6wGODAYxZ"
    "gTFirdc1h/PJGI3EJRfRjILpMZ87VFULZgvnKlgbXXELZoOmIXhPYCaMRgARwxjg1Cn5OqtK"
    "5qYDFGppFzbrWGZlqmAqbypDxLIs++kkb6JlCYuWLJypOvejaCaxDEIaRbalquvKW5vem1Ni"
    "qChPIhNjmDW8XwWzWC5tS7BWLMoFGXNeOTHG+MTBnC+JYa4eyJsdAAd7bAYwRo5N7nMozeJQ"
    "ZiSiWdcOgGTC67pF2zpY28A5B6I5vDdoGouVFULTEKqK4H0WS++BjQ2G91Ln+eqrUro0Gol7"
    "nmcDyWfvggqm8qaxUCyL+soyoRPjlY57QolSHOW2pSic1Q7xFNGscgyztEyZ4E0VrNjwd0gi"
    "eSbAGDgmbNoTNZjXQKGFEZFYMX7xYmBcr67wAWkcm4rg/cEo1AFwkMcGMgTv1xBFSs4nd4Sz"
    "rh2cYzgnomlMC2YRSmMaeG/hfYPV1RmYgdFI6mRXVyX+OZ3Gesxc02mtuPxVJe57f+45lluZ"
    "bz3BJPo7hz2EgkcOewBvFkvFEjvF0kcLEBaOcoyyFMvWVEEgwxafi6IZhLIlm5JA8XEHC2cs"
    "PFVoQfBUBdc9uPxM8LYCQ5an2KzWRjDmBLyXCywi1gt1YmUAUK2s8GjtYE4cmbr+/V/4wYN5"
    "s3uHttcfPLBjE+u8fLNYrC7iWVUebevhvcQvjZEEjzENnKtRVTO0rYUxJnwPBsaIaDYNgzlO"
    "sxQXXyxOxoMPxsQP4epVwpUr8v31ZwEt4K0nmMB/edgDeKuRWiTEv5eJZayRjMmZKHJRME1X"
    "IFtToymszJaqLKhROGHhbN7fkUXLBo4qOJutzxYmCGhwz4OV6clg066OwLwG701I/Ih1KdZm"
    "Li2KwjlaHfPkgEQFsLTx8ncd1JsdBAd2bBLykDeLZUfSVCOWHEntpQhptCxbMDdgnqNtaxBN"
    "QVQBMKGuU9ztqopWpcdkIvPOpX7TADC4fp3x4IPZygS438l90ZTJt6JgKm82vaL0KKALy4WM"
    "2ZHh7luTzZL7LVVoIKKZBLYQ09bUaGFEaEu3nixceC7GSqOVy8ZgiyYjeH8yzSOP1onEyXYc"
    "rq/HK2Z0ZLzoo4s0IhbBjOGOGHsUOFiXPpUQAQ2sbQDM4FwFY2LyR17vHGM8jq9jNI1DXftQ"
    "5C61nLdvm5CN96iq0srsZswX1I6qYCpvKJ3u570ET7cInXaIZbIkUclmajQohDL+beJjdUru"
    "NKYOIlmh4QrOijXaUN5XxNVmkTVVUeRuwMHa3DYr4pILlJIH4qLvpBqPeXRk8jRHFzIA84mO"
    "MBGJUElZkIhaLlp3AFp4PwfRCEQ1nKthrUHbioUvRfCSXY+vkU3ceiITNo/r10U48/IiOzLm"
    "fVQwlTeMvlgCWCyWZQa8FMueFdmgTmLYBAFtqcIcdYhPVmI5UoUWYkU20W03I8xRYY4KjRkl"
    "d95RhSa8NhW9p2YeMr6ZHVfwfpLcbxO6C/dd8YipR6iOTunkkcUQgWglWZfpcRPdcrllllk9"
    "znkQtSCqAdRgrmCtDVMiDYjEsvReituJXJp7vrLisL1tk5VpjIExPsRRs1u+ByqYyhvCIrHs"
    "Nu7dWyyzNVkIJdUd6zI+J8IplmhDNVozQkMV5qZGY0aYo0ZjR5izRROeE8Gs0cZkD0miKc32"
    "CeVFDdUVgDGIgJYtWpsnU3vfndsJAH71BNszb8ZpPt6QAbYQ1voozqGxkqD2Xu57z6jRoDZb"
    "wS0XsQQsvJfYpbR8cyFW6ULpUYu6lrnm87nFZOKwuWkwHstrzp2jsD7TTrf8mWeoXLo3ooKp"
    "vKEsEsvUq7KY4rhQLG0QxUIcRQyje12IZRDTFhZzO06W5JxGmAfBnJtxfp0Rq1RKknJmPlqW"
    "N+bn8NrsHWjcaWysn3vklJtcnrU0ch7mlFQiLbdG+IqBffTNOsXHGYMXq+8ZsuOWgwHB1WO/"
    "fvttzWexNn8ZRCZUKsj0SWtbAC2ABsY0IKrgnIW1VXLnV1elJEySPzIz6OWXqeOWP/vs0jWA"
    "VDCVA2dHCVFfLMuC9N7snIViSXXHuozC2cRMuRmhQY15sELnNMbcjjCjGjMaoTFjzMwovU+7"
    "oDbTM+F68xBem74Lr21fwpnK4M+dM3jPhHCxxsrbR8DbR4xzcsXssYoj7b2LEuDBGvTlGcxz"
    "t+nBn/7K+MOz1eqr2w/PfgexUQfg4FwL71tYO4dzczDXqOsG3jcpOy7ZdBFLmUJJuHgRKN3y"
    "/rrnBSqYyoGyI8kTug7lRhplt6DcGKNTUxlEsxTLOepkUc7NqBPLlOdGmFONuR1jFqzJGY0x"
    "s9G6FMFMWfEglnMe4Usb78VXNq/g0pjxow9U+MFHgW/UEOSR4+Ex8B+eB37gLNsfuWre+Ttf"
    "HX1w+vD8/4XMAhKhZK4BjEBUgciCyMI5qdWczw28NxiN8pzzc+eAnc04lqKCqRwYC5M84fE8"
    "3ZDSDB5HeZ53LP9JFmQQyznVaND9u2UbxDKIqRljhkrEkkaYmXzb0BhzG/YNxe2eDFpYfHXr"
    "UXxp4wP46BmDf/xug0eOTtdJZRfOVMAnrsA+/rnq0elN/xWcab4MogbOjUA0AnMdMugVjDGo"
    "awPnJHbJTGkCwsYGoW1lm80Ily5hxxrnPVQwlQNh1yRPtDRTl/OY6LGp9KdFrpVMLrdZIJam"
    "+NvIY3MaYYoac7OCKY0xt2NMMcLcSgwzZtSl6YbFa/ML+OL6t+KR8Rifetzim7Vk8thxpgL+"
    "9iW2f+Na9fjG2falkASqQFTDe7EugQqzWRVmAhkwG9Q1hQL32HGK0jrmV68uFMuygF0FUzlQ"
    "csVxLyNOWSwdFtVbBusS2R2fLxDLeeGmx/jklEaY2TGmtIKZiRbmGPNQThRd8BmP8MKt74B3"
    "D+J/fcTi+88e6qlS7pEPnADoa3QGgIUxFt5X8N5CsucW1kZrMscsZzPCaCS/6CdPArdu5TfM"
    "iZ+lmD33UJQ96CR5yhZthXWZloWgnlDGuklbWJUxK75ELOdmlFzuKY0wpTG2McbUjLFtVjA1"
    "K5jRSLLiwXrdcKfwmet/Bk+tnccff7OK5f3AN6wAd+Y0kcC4l4SOMfnWe4uqkiVFYq/SvGwF"
    "4c4dwpkzwPXrkimPPPdcL2uZjU61MJV7opwn3pn2yACbopflAqsy3kbLMiV7UjY7ztgJGXBI"
    "wmdOMakzwsxORDTNCqZmLMmdUGfZhmL0680FfO7md+Lj77D4qYuD4/vKEeflBphU3GxKbptC"
    "F6lcLmSMdC7y3sAYgrW0Y7rj+vq+/kGoYCr3RoxX9mbycHFbdiAq+1SWxellYXosVp+bURbS"
    "MFOnCWI5pRFmQSSnNMbUrmCGUa7VDGL5la1H8aWNb8Enrhj8Ga0lv6/47CZQj3k9PRDb7cXl"
    "jmNz56rKz/U5fZpx/frgz1TBVO6a3eotd7RqM3GpiKJNW3CXdxSnF3PGWxRlRBRccRphZneK"
    "5dyOJBMeuht9ceN9uLX9Dfjd9xq8R8uE7jue3yTeWGlfQ+x1KVMpOYlj/BGvKg/vZcbQ3VBM"
    "3VTBVO6Kvesty6UlestKmKJA3VRoQyOM1tY7BFSsTBtikiNJ6tgVzCgkeexYxDLsH938r24+"
    "ivXpY/jM+w3edkBrdilHh1cb4O+/Bu/e1X49NR6Wtctd6nDELLdtG6ZZpoYesv/aGuPWLeDB"
    "B2MrOGFBQ+GIJn2Ue6KstwQV9ZZFGVEndtlrALxzbnh37nhLlcwBN1EwQ6LHjEUsaZzmi0ex"
    "fG32EL6y8c341ONWxfI+5ce/BDc71X4Jp/hG6JMp3Yhis2HZpMWbtHETUczd14GNje6bXr26"
    "5+eqYCr7ZldXPAplLE7vxy0XxC5TI+A0z7uwMONMHRrJzJ24mTijZ4TWjFJbt/X2LP7o1rfj"
    "l95j8O6js3SYcoD8w9fAv7uF6ezt03+BuJokUQNjWljbhK7sLaxtYa1DVUVrMy9TIZam3F67"
    "Brz0EnDlCuP553d8XtlEWF1yZV/s5Yr7RSVEaX2d3vTH1EQjNNDoW5ZUo+GQGTe1WJVmjFkV"
    "YpYhthnrLLfcCfzh69+Nf/CoxQcPrOG5clS444D/7Mtwv3gT7dbDs38GA+nCLt3YpekG0IBI"
    "RFPawcla5sZ4MDtMp7JcBcA4eTKv9ROtzl1m+QDHQzCvAnjmsAdxTGj3uf/PAXhoPy+ILriH"
    "rJYYhJFaqsjBUGtrmnNFjalNU41phtpMzcRO7dhMzYrdprGd0tjOqomZmhU7pZGdmRU7o9rO"
    "zNjOaWTndmTmGNmZGVdTO65mZmznZlxNzbiem1E1o3HVkK1aUxsHaxzItDy2X3/pvZf/1qXa"
    "/sC54XODlaMNA/jiFPhnG8B//RK52yvu69vfOPssjJ9C1iKfg1k2YA5jZvC+CXPLG3jvUixz"
    "NBJLs7Qwb9wAzp0TkXzhBeCJJ3YdD/GCNuyKsohe40fqbVIwfO2aRVVZWGthTBU2mdvbNDLX"
    "N875zVsN78eQPocjADWqagznVkC0AmbZrJ2AeQxjxvBe5gwbU8FxtfbFyXf+2Glz8mcf5nsO"
    "M11rgN/dAL46B643hJdb9q808LectLW92/e9IHOgq3rBO2w44C98Ee51t3cT24PiLz4I85fP"
    "Lw7L/aPr4L9/DQsWXX/z2PbgL2yRNYZbu8K31882V3HOvQyiFs61IJoDmALYAtEdeL8BazfA"
    "vAHv74BoE9Zuw/spvJ+FbY7RaA7vW6ytNbh+3aFpHC5elJjnc88xrl1jPP10sjq1vZtyrxCe"
    "fZZw/jzhqaeyaL76qjQ6kG7WNmwyn3cyqUIHmUVbDWtlaptzNUYj6ThjjIirMWMAYzCLwHpf"
    "h4WvLJjN6pcnT354hdb+p7sUy3UHfPIm8OvrcM9tgF9viMYTvz6veXNq/RQWc0y4geVm13Oy"
    "Gw2NJ6+N3rusjean14Hf3sbWxvn5v87vSAvXlRnI7uNZry48fse8/S+fX/z0//wK3Ocm7Rcx"
    "8TEzwjs6o+97RGGtnt3eQzyYsEwFO7zL30bFc4hoOTDiypFzEM3g3BTGbIN5CuYZmKcwZgbn"
    "GtS1tHtjdhiN5HZzM1qYHjGGefEi4+pVmRopGXLGM88AH/94RywBFUxlIIV1Kbe5ZyDhxRcN"
    "Ll82sFbE8vRpg81NGxogWKysWMznYm32xdK5ClVVwfsa1opgiqUpm7WjIJRRMMVaZbYAzPir"
    "4/c9zubBT1xhu1/T73NbwM++AveLrxPMqr9x50T7Kt7pb2DV3ZkNWK6gWKe8XKZCbqWxbd73"
    "tfqd33OGuVoyyH96m/zmWvN1nG2vofvZwxWqK2h9b6DDyVvVu546ubxp5xenZHCp/TrGfnvH"
    "OEohvxcRXfaDEB8XgWUwuLNEBdDA+zmMmYZVI7fh/TaMEbFklgbCzG1wwR1mM4+69phMPJwT"
    "0bxxI9ZmMq5c6ZYWLei2DqhgKgPYuQZDzx2/fJlw7ZpBVYlg3rkj/QeJlgllDfm3l7vLABW8"
    "r1DXNrjlIzCPQTQGkbjpWUgtjLH25frRC1vVO3/1fWzH+7Atf+Um8N99De2XZvDbZ9svuW9s"
    "voo6WTFA15qSyZ59kQCySDLH5/N56i2QdnKjuvhDDy0XqF+9Be/f4a6jTECU9/eyNneKdpy0"
    "Wt5P8LY58+0nF7/Vaw3QeCCI5c6xMDPyejsont8f/eOJFqgsMheL0BnGeHgfkztNEMQpvN+G"
    "tVtwbhtE27B2G207C2IaBbMB4DAauSCesp065XH9ehbMgePXsiJlOM88ky+655/viub589Rx"
    "xWczccVXVmwSyiiSznVdcRHOCszignsv7ni0LkU8Y59DsVyv24unbtTv+fTjbM8O/Nn/kxnw"
    "kT+G+wsvYutz5+Z/cOfxrU+5i/OrqHkKKU+Ji2y54MrJRpSzr2LhyCZrZMflX3PZipAvQA8z"
    "2zJnl03N/PocuN6AcMLdTu8Rl5WNa3HHz5PPFCtLxiZbHG8cf1xtcdF45jQmJrus/+cfbQOT"
    "MW8VxxNXbnTpM2Q8MSMt56e/SYxx7y3uJ+8jfzPPAMxgzBQSp9wGs2xEm/B+E0QiltZugWgL"
    "gLjl1s5h7RzzuXw/dd1iOo3j9zh50uPmza47DgDPPSfn6ZnlOWa1MJXhfPzjQBTIJ5/M92PC"
    "R6xKsSyNWe6Kl8JZVVk8nauDiNZwTqzLKJaArEENWEzN6olXxt/864+zfXhAm0iPuQAAIABJ"
    "REFU09+pB/7214n/7ivw83PN55uHmy8BRV0ekQ+WTK7Ni+5gjKd1XVIK1hyF+yYsxoX0N1Fu"
    "9LBePfCeVfbnqsUGym/eBsar/uaUkmh3b2NGN07/kxkrXUs39nfM4zIAbLA8Y3szsTQ37Jkn"
    "15abqy9sA83Id8U7j8eF8+PDbbmOeJfsVi9323e+Np/7uFZP/GESgZ4HUZyCWaxM5q1gcU5D"
    "lnwOohaTSYP5vAXgMB5LUTuzx/o64+xZObelOx5n+AR3vB+/BFQwlT3YEbsEYlfqLJY3bhic"
    "O5fFcjazmEwsmmanULZthaqyIXFj4Zxkuts2CuUIzo1hrViWcYVAsUANALP21ZUnP36J7ZDG"
    "vy9sAx/71+Rujtz1zcdmn8OIp4hWEzOH+rxy7WufBBTg0MhhpzvMbMJyuzlWK/vY3v60crt6"
    "6IfP7eqOu/UT7hV0RUkW7YqiKeIRy2HK2Kl8N8yyPo0ItwnnTNxbETUTXfbRlj33kVPLx/PZ"
    "LfJbY78OWbbWBWs3Wq5tGI9P45H90plJb0SUG2CUyA9T2SyjGwKJPxBxqqNzLljOYoUSzdC2"
    "U1TVFHU9hXNROKdgblBVso4PIImf7e0omA5raw43b3pcu8Y4f77rjj/7LHZbzwdQwVT2h4jk"
    "ZCK3L79scPEipR6ERBbTqQ1utghJ2+60MCXBY0Nn7ApNM0JdV6HcqLQsc5mRWLHWvjJ69D3W"
    "rP3UQ721wBfwf74O/MSfkNu+MP+cf7D5mogiSnF06TZOpYs1e6WFWcbWJJlDSSxFKGsQxYs+"
    "PpfGZzfN2z728PKs9aduE3DZxWRPFKcGCIXZgIMx2SLO44i30aIlENkgliHTbGRMnBvxTabm"
    "ge+4uHw8f7DFHmf97fC55XjKMEBc39snS9KYODZOQm1t17qMYlnSFdCu1S/hB4/SzW/bOep6"
    "Bu+nsHaGupbseNNEV7yBtS1mMxHJuMXvtrQuy+3pp1N2fBkqmMpSknUpazTnh6W4V4Thxg1J"
    "9sREz+qqrAHdNCKUo5EtYpbRDY8WpjxW1xViVtyYnCGXrLhFEEtsm7XJ6/U3/sL7d8+Itwz8"
    "9S+T/0c3uNm8PP3nWPO3gJ5IStGzuGsxtiWzRsTlzG5nbtgQ3ezodkfLVyy4aHX64JJLEmjT"
    "njxBZJ+YLHZJvzAFpsweE3cniaMIZYyZNml8YvFmayzf5rBIFEtx16kYCwAwPMz21Jx48sTy"
    "HMfVbSK8PbjkMiaJLUqBuAhXzFpHS91aH84R0jgBBNHOH5YTZ9F6z657DjNE619+xOR7atG2"
    "Lep6jqqKcc45mmaO0WgW3PQmjZG5gfctxmOJ75aCCXi89BLj0qWdyZ5d3HFABVMZQhm7FLJ1"
    "eeuWwalThM1NsTDLDRALM66vkkuIZKsqccXruob3o6KESBI/Od5p4dmufXXyrf/ju9jsFrec"
    "eeBjn4f7/xq/vnll+hmMMEduzpATNsxyEcVkijFtinFZKx1ujPFwDkkQBYkHem+D+84hhmmD"
    "WHZidmbdvu3fObvcmvv0OkCr/npyvWVedMzuxou/DZliDs0lMjF2KVamRc7Wm3DeszsPEDbt"
    "qYdX2E/M4njq6y0w8yBMeCuNR87ZHMAsCZX3bRI0cclz7DG2WCstzkw3ppnPVxbQaP1J8i3+"
    "kLUYjxvMZg7GzOFcA2vnMGaOpmmSWM7nDVZX83krxfLUKRnvyy8z2rZrXRa1l7uhgqnsF7lA"
    "o3V57hzhzp2c8JnNJOET3fFsYVpUVYX5XIRSXHKxKJ0TsZRET45dyr9PA2ZTvzy68uQYk//4"
    "bcvFZ8sDH/1juM+yv7b17unvw1CMAbrg2rVhjWqp0yuzz23rk3Up9X4x/tdN9ki5kA0CBhhj"
    "guWa44sFJ+9Ub//3dimo/+QtuDsn/CspwZFjl02ylOS+77i9eUzRJTfB0svWr7wnOtbeHXv2"
    "QyeXn8OYIZ+LlZctXu+bUBAeRbNBTAYBPliYOUlmrdy3FtitrjSfXw7xTkZVOXgPtK18d9ZG"
    "t1rEr6rmiFY4s4jlfN6iquZYXW0wnbahUF1CGmtrDrduyVhffZVx8WJ2yZ97DnjqKRnBHtYl"
    "cAwEk4i+BcDusq9EnmbedTZKB/rH9LMAHlnyrNwwpNU/CCBLICu3sASqCKYmmBHBjAxobGDG"
    "BLtiYMYGdhIfyxuNLOyIQGMLMzKoJga0YmFWDMyKhZ1YUG3lPSsDsoTZqXpy8984979/YPmF"
    "fscBH/ljz/+KbzTbD3wOWPdPgj2DWwY7BloP33hwy3AzDzgGt+E2bgywj7E+TkGJ1cc+hwc/"
    "8i8gqw2a4KZTsvpythhgxnjbnJvcwmPsjZnN6MSHTi2+/jyA37lN5pT177Bfrx4iD29aeAvj"
    "TcPOOHjy5MkzE4gRogMEI630ogtLFmyIGM54S4YtjLdsvCXrDRu2IIZk0mnDnvnQO5YnfF7Y"
    "AgBfnX3Jfptx7I0nZ1r2piVnWzjTGmccMYE8MXlyDOJYkwku5E+CuESAL1xuBKPYM5jQfv7f"
    "av6XZIXmuHHMwIuwSfMM6TwUhdDaFk0jUyQnkwbOiQsuYinW5WTSYmPDYX3dpx6ZTdONXcaZ"
    "PQPrMI+8YAK4AOAHDnsQxwQLiTcN5cMAPrDrHqbUKB/+aTFAnAtVPEuVjgkeHLeAmQN+DpiR"
    "bDQGqAbsGHAjuTVjgKeAmQBmRW55BtAIMDVAFcAVTrz+Qfy9RwwuLultue6AD7/g8AV6iaan"
    "PrOCxj8EH8YRm9i4mYyHG4DngG/lPjzALriIMb6G4vIhoD7zdYiVJZZiLFT3HsGaiiU9BkRk"
    "GkzqKV2YNgbfdYqxrKj+DzcBS0zjGb+NPME4yNYwjAt/e4DYgOJ5jpERQgoTMBhsAYaBrwi+"
    "YngLuW8J3rA0TSHG9pywrGAdAP5wi+A8r6xs46LxBNMA1hnYlmBagp17GE+glmFYxiY/LWFc"
    "nsN9+ScSzpc8158dRNTAuK0U54xusljRjKoSgasqsTLbtht/FmuzwWwWQywSsyzF0nuH06cd"
    "rl0Twbx0aWeyp2SPmUvHQTCVI0O0oro164ABKGzpfsjVhFAmYABbARxuYUUYUQdBDSKJCjDh"
    "eRBGm+/Dh9ZW8OcfWDwix8C//3mPL9DXMD31GRG/EJoUcYxiGQQTTRDOkHz1bbhAwo+BITH9"
    "KAqTAeBjuQ/gXHTJ5b5kxE0RSwxWOFB7ix86t/xs/sY6QNYDYj8CHiAv4kMMEMvFm+yuJEUI"
    "fqOIICVrE2XxVzdCQJLct0R4eLxcEP5gk1GZkL8JQhijq8YD5AnkAMMG5KTZH/mwbxDGwsqU"
    "4fRmjcZjkR8m3g6Z/lwHG+87J1l4a7NwxvCKiKXcl8J0F8RSXPe+WLatx4svMi5fls8oXfFC"
    "NHlBWKVEBVPZH4wiCVJs1BNNGMAUohlqzkVMKrE2qQLsSO6bOjwWXmMMMD+H1e1H8Q8+sNSD"
    "xH/+osfzs1uYngtiiZDU9dGSLMSSg9XrZbYcfCsHFK1LY0QsEX4UqFhMK5bJxHKeWFokZUW5"
    "/lFimgQy2GwMPnp2+fX3yzcBtj6ISpDDIJBRgIriprQfwhCJg5drw3di8nOS9iFwfAEzGmfx"
    "rWu7e55fmBLsGOlzo2VrPIGcWJXGIQm6WMBBVLl4HYq/+1ZbOgYCvJ+hqhhtG5+RTZr+Rvfc"
    "wdo8UydXNuSmGqNRLB3KZUSlWJZxyyWu+G6xy4gKprI30fKKFiYtEEouRKZvbZbiaavwd1WI"
    "ZBTMYF2SBXyFE+vfgX/4qMUDS/6V/tyrwP9xY46tB347iJ8Ti9I34tq7qYhkup0Fy7LNYpkE"
    "BaEOMMZrjYQZ0pOIheN5dk/olgQp2I+zaQgA5g3h0RXGQ0vCCHMGnt8knJr4JCzUsybDrxPi"
    "XztSJ+FBLl7DUSKzCqcXkid85NTSbxk3W0mcnYEP3ydELDlbmeTkzckD1lN4jJMlGq1LioMo"
    "rcyiFIpAIupSbM6wVkQzFq1LzDEKZrlGTy4Bk/nhWSTj4ydPOty44ZeK5T5iln1UMJUFBNeJ"
    "erdA1zqgQkRNFMdcEthx16OYcimW0TWvwmbTe4zvfBP+7KkaHzu7eIS/swH8za+02H7wOYCm"
    "wbpsgwUZxNJNAQQL082K552IYRKTMrTAYazhPMiFLi6iWJJx2qFYk1JeZCEzfsJsGiLrLH7s"
    "wvIz/M83gBOW5XAdCiuSxGJbZFUu/Krid1MIJSF0wC9eTATr7a7xyz/aBtZscLM5u9pRPE34"
    "AOMLK9MFN53zvhTjmB3xLI4j6ibAYYqjPCoxYUZd5+mguQ2bx2gkme7p1GM8zgLJ7JNgxjV9"
    "zp0TkXzxxRDsWCiW+7IuARVMZU+KuFNMNKSLtB/LjBZmtEQL4SRTiGoQTtjCDY/16QaYn8fJ"
    "2cP4ufcsdsXvOOCHv+CwffozgF0X8eNWrEiei3XJU8Bvy30/ledj7DJOI0/ib8L9aBXbsI/J"
    "PqYIJdIsHnG95SBENPNJYNDW3OKHHlh+DX5qneCsQ5VCjyQxwBgSQGltYqdbS+UVnq9/WTYk"
    "hA+CvSmPMe60hN0K1v9oGxKojEIXxkQMccmZQN6LQMZ4a9yCyKe/gZSkyrrdjWXKPn6WBj+Z"
    "MObzLJoAYzZjjMdiXW5vi3CurOR54XHz3uP0aYfr1xmvvupx4YIIZoxZHoBYAiqYyn6gQjw7"
    "2fNSMBeIaDZ7xDU3MZYZLMp0K/ud3HovfuZdFqeWhC5/6sset+tXgPFXRdh8ky1LngJuG2i3"
    "RCi91FvDyUxDSQiF7HZMPCQruDiekFUOZl4u/I7ztZmzVRktThFQuM3q9PtWgUuj5afyk7cA"
    "Mi6LSREzJOdBZaklEMQHO4UzDJqJ5DeIffKm8w8c0DqDy2PGyi79yf5wi9AAGJEJCRwEizFa"
    "nCFDXsQtTbQoS7EMAyCOwhgG1I9jEoC6nmE2A8ZjxnSKtKpjds2zex6XmJBSrlIoRRxlfvgy"
    "9/uexRLQ9m7KUEqxLB8r3fX0fArldV13E0UxWqGlGx9decL29AF8aEms7VPrwLM3WkzXPgPJ"
    "cs+LBM8UaLeDRTkNgrkNtFMAc8DNiwx5zKQ7pMw6+WCtxq1z7DJI53JyJ7riWSwJAE22qgf+"
    "o/PLr8M7DvjjbaC2XLjhXOgzFZd4733KLkXxoUJ12VD+fYqZc4hgPnWq9131+INNhqXwYxLF"
    "23O2fJlyrNKz3DpOmXNyWTRN+Nu4kFV3YqWa8Fi8hcwaktlDsnRE/jsvJ9EUW4sTJxo41+Lk"
    "yRbOxUyfw/nzDi++6HH1anTDZcmJAxJLQC1M5V6IVkKkL56LxJSK+GDesbPTZHwLv337LP6D"
    "B7svv9ECP3rVYfvU7wEmJHCSqx2z4dtiYUZ33M3kynVhX46XSbQwQ6s0A+RyqZ5REptYyCyf"
    "mPAJMYUQS4iuuqNqum1O/uAu7vhvbwAnKy9CFJMhUTSTu0rRq15w3jlY+Lm+kg2FqnERVAZn"
    "L4AZI2/w3UsK6CNfnRFsxdn6djEWSTDgIIriesdEUBTN9HcqkeKcAIr1o0HsU0KIgCCKSPHL"
    "+I+AmbG2lr+E27fL5XE9Tp+WtXekq1S2KPsuuJQOHYhYAiqYyr3QN1ii8JR/R8FJ4lNmnuO/"
    "2RT0AmCwsfpH+Mk/+Tb8vdc8viFVfTOe2wDujP8EGH0tWIVNIZbBFXfRuizqLl0j+ydXPFhp"
    "HBSJkMUy9bEI4xZxp1BzGTPjea68JHqigAI3qoc+eJL5gWrH2Un8+i3CnBwm0Yor6jBFaKIl"
    "x3l4/TdJYyu0gCDCifwcs4xs1hp82x4lRbcdsFIjFMpHyzKPzYBkfMFFNzFuWbrj0T3nsG8e"
    "mpzf8msHgNXVBhth2aCTJxkbG3J7+zawvi4CeeYM49Spne51tz3bIktS7ssc8XsWS0AFU7kX"
    "kvggX8BxFlCyzFDsE929KF7FLBtZlkAeG38d07f9Ej4zewifma/I+zEDJzaA0deDWIZZOzEj"
    "7oNV6acioFxmxhtksU5+NnYULkZrMwpqylEQh1k+JpQRxbZu/XIiOn27etePP7R7qOtXbzGq"
    "WH8JZJHkHBMUmylnm5Omx+HKuCBWJtIW/0Y8UgKcJ9QE7NVsedMDq4ginS3eWEwPF8dJyaaj"
    "+Fg/AZRm/MR4ZvwUsTSJSD7p1q1yaehcj9m2svzt9evY0bvypZeAtu1ak88/H9cU71uTXDbU"
    "uBexBDSGqQyFS4trx5PZ2imtSSpEygezhENJjw+xwziVMt3Ggr8GmLwEnPgCsPoFYPXzIpY+"
    "uuDz4HpP822MWbppEMtiVg/HmT9F3DKOpWi+nqQveYcEEFGY/mhSYxHmKvUBNaFItaHRdNuc"
    "/oElpVCALOH7tTlJ/BKUZpgiJkuCVZnc4oKdfc2DOJalRUV+LT7eOoN/c4B1WZXH7Rkgk8fn"
    "OM38yfHN3i3nkqi0n++56+HHAY5BjoEzZ1qcOSPzwq9dczh7Vv4xNI1Lt+fPy/0XX4zTGx0u"
    "X47JHfnynnyym+iRZSY6B32vYgmoYCp7keb/dh7sCmO5Jesy1x0j1BsjtiOM4pUELRSVu6YQ"
    "tVb+9m2xlbN1Qp2l28rWZay9jO54SggFK7MvlMX1lo4pbgByxt8A0i7NFFZljl9K4gd0o7r4"
    "p08zry2fmITfvC3xyyiWckthXnaw7ACQWXxpxtlACGG+NJ/cUCfhU7rr5Az+9Ondv+YbLTA2"
    "QSRjUi5+ndHC7Cd80vhL0cwiagprdKnbXiZsZjOHl16SfywXLsjjFy86XL0qX9TWltw+/zx3"
    "v7gF7njPBT8IsQRUMJXdKN3s/OBOazK61NzbkhUZH2u7WznHO7rRUehik4yyttIX9ZVuG+Dt"
    "7I6nRE+c0VNMgUyfmbuR5fBAcQyJfrKqJ5Ley3IZUlqUJOrU7epdf+nB5Z2AAODXbgFTigmf"
    "KD6cL/9wauHKuqJiPMwylFR9wNkVBxcF6/lQjDf49rXdRiWCWRHCuDgnbaLRzRwlE2UsMhWs"
    "L7A8EY4tFbQnV78ozgc8rl6V7dIlh0uX5Et64YX8i3blitw+8YRkvaM1+eyzO4XyDbAqS1Qw"
    "lQX0/o0lj4+7IpMsyWKLcUkqHwvztjmIV18UfbQKp3lz2/kx1xNGtxVqLTcBvyV/t3H/6Irv"
    "4YZHhVrYa6FI/hgDUCUNg72PVqVN7nishZqZlWZm1r53ycqQkV9fJ4wql05xOQc7Fa8zACoK"
    "vstSohi/7MVaO/1QgCyeDGw6wrfssf7RjRawodRU/p9nG6XCzjCWPNbsUPSFE4ue6/2dBPPK"
    "FY/19dJyFHEEOJQFZWvyqafy/aefXmRdhuM/OKuyRJM+yjBS70UUF2u49T60duuJZGxwEWf4"
    "cAt4kr95LvcBUQ12AJfdikqrqny/KLZFvNKHKZA8E4F0hVvfMd0gF7+JJS6cP6Yzeyn+TXGM"
    "VGTFq1S0Lm46AYC5Ub3j+88x77Y++pdnwIYD1kYMRDccEBe4nEeemoCU4+7dt8G6BDpxy2Bn"
    "pkNpW4N3r+xesA6IYOZzbfJpKRyKzqK9IcbZSUxFizkVR8X4LIf75Xea7okpLauQdpFFyRaJ"
    "3lIhfCNEskQtTGU4ncRPYWHG5E7KervCwotWZZtjlD7GLKdhRk6wGttNwG0C7QbQ3uluLmzt"
    "htw2myF+GWf0zKQw3YVSIsTi9MKy3NWqBMS0KovrQ9MQqghiWVZFSVFu6QbQiQHu+KfXgUnl"
    "xXosM81991e6IYUhLcyyAaBsVRbJHsRkT6jBbL3Bh/YoWAdEMNNvQ3CnS0eXGNI/GTHOmsue"
    "yppLxBhr8R5x//R49/T3rcS8xUXJdj7Xf4Pk++x5oPeIWpjKAMI/xdIyi2JpQlefaCXC9G5b"
    "dGocJd8hnRxSiZFDmlNuQjejeIERAbFvZepGNC+2ojGwD0IZBbu0LhnIzTW4MBVo8RbLjKTL"
    "ksQv49pEzLFhp4jmbXNmlTH68B6JlU/eAubksMoxJphd8JzMyRlvuVmgAYX5xp0YZnhVEXce"
    "e4PvPrm3jtxogYY9xuXUyziuiBfLuMzWd6W4nDfee46LR4oC/bz3EhatsSP9P99wcVyECqay"
    "O31XPE0/WeCOs8uuNwjgmG2NYkmh5Q1LUsM7affmWoAaEUwf+2FScPuAbvyxzeIYs+YpC15Y"
    "tCk7H4njLu4ualXHQGoUEpuEkKVQRpTnj+d2TDR5vX7kpy7A7uWu/dZtwmjMnfxuKsHxRTNe"
    "SAc5+Z2KY6bu+Y+WZPjxiv0v09/hOLdbg28bIJivNuE79h4pZln8G5DMefFvoohr5vhkEFTE"
    "U90VV6CIcw5kodV4OFoJ4K0pmD9y2AMo+ACA/+qwB7GY0trpPR6tTPbhQnbIllmhJT5cVKk+"
    "nIMIhoAYecjqjJVYct5ksWrLzyuy7L6fyJkjzfpBYVnG9m2pyUYxewfI/T37W+qqVDQ8NpWB"
    "MbKCpXQmyiVGLY34jr3w44/tvk76v9oSGbPkw0wehAYXJsf9fOFYxumScZpjCIWk+eEcs+II"
    "5URRWrNYOk8YE/DOXZqARF5tGFQkkVLSyXP4jYvSlc8jxXMawgZUjHvHLdC9X3y7e4/u6PCW"
    "E0xm/oXDHkOEiG7hyApmQVmwzihNimDFBbc5ueWFz0jZEsmvcZD1elywKlvIojQUEh7RIg2i"
    "52PDyCI+GpsAc+mClyVMPluRaeDIVmWnn6fJW+wMzyQzjyQBZYIbHtchl/UziIiu1e/86Fle"
    "2uQ48unbkNk96dTJeRGxNNI2LVqWcZw+ClO3c3rqpF5Y+xznlsdaTDAaZ/AdexSsR15rABO/"
    "q/ANxm5DyaDlIoZJQFq/J/7ziGLrOVnI6LzncMvyqPKWE0xlHyzojBOeyFZmEk2Hzpw8gmRy"
    "PQqBje67hXRyqJC6FZEVsXTI1iAQMqxFQgnBlU/1leVMoeiGF654udREHJspYpTl50twNYUs"
    "83IalYFcKxJgjctRAHTiVvXIX3ts92QPAPzfNwFnPGqGJE+ioc0k7dyirqVsOReCU/xgUbF+"
    "DxAK1sOB9cKCxhl8zx5x1ciNFjAk4YLy8ymGU+Kbp5lI0aPoWZA9V34/7vdxQAVTWc6Of+uc"
    "b9K0x7hfdM2RLzCHHLOMrrj32d2FQ4gRIpUc9Yq08xVYZODT/biQWeygXrji5QHkJhpIMVVb"
    "ZMNRiCaHsIKxeWxURQvTdl6wXj3woEW1WxdzAGgZ+MwG4cRErEgxhOMc7MJS7FecEyfBJBRN"
    "NYwByGcrkxAK1ovzRQANKFiP3GoJZHz6vM5YOtntXixz0Q9qtI5L7hPxVMFUhrHj4ogXZmFl"
    "9t0wKuJxJu5TNA/urDYZrZhgDab4Y2nFFlZmWYDOwWWPy94mV3yBdRn7cHbWHyobGVtJRMX1"
    "hcSozL0vY0mRMXTi9frdP/3Q3tbl798BVixL6aRHnjXjGEQ2xC4pJ1zKsXIWzY5AhnOU6i7j"
    "FEnkU77ZEr5llw7rJRsOGFcky3D2vmLEOe7xXKa4cF8AqfcXLbx/nFHBVPag53JR72HvUx4g"
    "dGeTeGKnY1F04YPAeZdFCoV4lRcVF5+XlpQoXO5yhlFq7FFe7BTikcjiaQqB7m/lGkRxmrip"
    "Y0IqPph3nPKK3zIP/OiDuyd7AOBTtwE2IdYbM8kx/ud8Cv9S6paEHWKZs+JBWC1Ssif1vySk"
    "THnrDN49Wb4mep9ND0ziUsP976EcT/kYsNMlL+PXOx47/qhgKnuzzLqM1wLHOCOyaHKxr49i"
    "6ZBWj4z64wuxXOTe+dKCLUUzfFhaXLAc5wKBL7Pg/eWAy1UtYx1oXBtdVrEsu6sTALLX6od/"
    "6AHGbo02Ip+8CYndxmmFzLlfpI/zYrrdgDjVuJY/UuE4Q2InzmSMFiYXNTzOEx5f3XtsQNGp"
    "qGzunLLg/Thlfv545bcPBhVMZW86WtmzehgQE8kgJVs4/Ic5xAKjktpgDYai9s4qk4U7X35W"
    "xy2P8dDSoozPxdf0rVXKWymSKSRQWLpxid+c7EFyyWM5EbMBw4zXq8s/9fjeM+W2PfAvtwin"
    "Jq7bhIKBVNsYBbSIFcpHJfMuCaQHwuO9JXXjD1cUUSa8f7LX6ISbsVNRcd6TCx3CBwAk811m"
    "8ePY+jHP+xgVTGUgfde89M0RLMAgmlEwk3UZC8CD+clxbnkRT0T/QkThYvcEEyyuLBWfLy9G"
    "agIcLabSqkRv68Qwy7hqiF+aNPuIkF1ywq36bY+OQe8fYMH97gawVnFQVoIBdYTTJHe8SJTE"
    "RE9Zg5mK+CFlRek3IYpneF1w0cdscGVl7/F1zmAUyviDGMMEYCy0/t+CqGAqd0eZeS4z2Z5C"
    "3qaMYXHhTsfZP8UsoGQBUlf/4ut3zF8vXHAgv7YzLhQWa88VTzWXwf2mIjxp6yLZEyxNptjz"
    "0oCITr5ePfrTF4ddO//POqFBiypOCw2t3GKXckQ33JfnrH+OUbjL8UfDAGktH8Q3Ci9lsKfB"
    "gnnCAK1fJIhFHHUX7peEzhBUMJV90Avgl25559bnB6LF17FAqVugnorbF114PXEsrc5OVj66"
    "3AFaIJIobjtbCAukcqfSJTcAhWlBRIRtOoGZOf3nzg0L4P3KTYa1XmbM+KIlWiorCofIuQi8"
    "nI5KndNSWM7s829L+q1gxMXRNh3h3SvDxnjSAvN7iEcy+C0jmiqYyj5ZJJq0QDwLFS2TB1Hc"
    "vC/uo2vFlBnZ8nNQfHQ0tJaJZRm7LOOWffc7rpFuqiySFLPjYSNDIahIo+ujy3/pPGhI9vlm"
    "C7w4I5xeleSOjDu74tkw52xpxnBs7/iZGbCSIIozTqPFmU51aI7CIFgCzg28uldMNHBDUXxh"
    "uOfv4i4FcZHXcIxRwVTugiWi2bEGqRC3OPMmilvhikfRK0WzvMBK4SDkSTylZbqwHrAXuyzd"
    "7jLZw0bqLuPMnmRddpJC8oZM1q5X7/xP38eDinV+63ZeTpe4N7uH4zLg8xlZAAAgAElEQVQP"
    "1M0cxdhlkVNJ6fC0TzgMcOc0RpwnXBrtT6XGSRflc/JEHi4EfIkHQLTgqe7+94sVqoKp3CW7"
    "iGbpoqeEQWl+FiZSNpW6Yhjfs0P5eaVl2Uv8JBc7CF4sGSqL1FE8x0bmjVNhVaJwyTn47a9X"
    "F795lfHowNjgr8XldJPPTMkVj+uRU4xr9sSEOIhWmfwhYEfxennIzIA1cA3hsYFjjEwM4EGw"
    "/QRP8UOYrc/jL3x3iwqmcg+UvhsKt7mwNtNupaAWAhKfX2SllH+XAluWtlC5cy9uWcYso+sd"
    "kz39mT3J/S634jWAOXWzevRvXBp+zfzT9dxwI6/ljZT0MVEogyjKxKheOCK6xIakNrM0wovC"
    "9dK6d97g/au972APJgaYxm5JUZDL7zN+BgGp2Lb/Pffc7/vFqixRwVQOgAXWJoqHyjhnmVUv"
    "LZl+HHPH25cx0GLfjkseEzhF3HKRO94pKwoWZpkV70zbJICIsGVOVo058bGzw0Toa3Pg9Sas"
    "EBk8+LxuN3LjYJa3z/WX4TSZUM4eEzmFBZ9m9YSTzOX5JmAMwmMDEz6RE5axnbJMMaRShlUK"
    "T8GQzIdfNqGhL5I7PIXjy6BYjKLsTczClA9Fi6V4vlwDnH2e/x3/7m9RVWI5UUou9dzwJG6F"
    "292prSwK0pm6IprKi6q8jyley8DK9dEjf/UCGzvQYPr0OnCiDi3bOKyeCAAweZ1uUCgzysXh"
    "6AhooaDpN4GSSEXPPue3RFDJD6/BjKwZgKPFX9bYFrWd6bGSRWKYrNTSE7g/LE0VTOWA2UU4"
    "++JZ1meWj5VbOdunvOaS+xcvxgVWZV80y2mQncx4mDdOcStccSLAV5Zu27f/xNuG+5f/5BYw"
    "g0s1luk2uOQo1/YuV2VMp6c0N4Fy5k0SyLRzfEruTx3w7n0K5kkbT2ewKqNIps/xXYuyI9IF"
    "94kwLkMFU3mDWCCcQFc8O677IsFEvl1kyVBPLHfEL3vWpemJaG7fhpTwKcuOgvlGGw+e/O5T"
    "jLcP6Fwe+c3bhHEl4yYAcNxxyU2RBk/9MYvDpdBkI68DLjtwKP3h8txQebYIjgkX6uFjBYBT"
    "VYif9sMlycuWc82dZT8kQLDje95NNI+5e66CqbzB9AWw/zQv3tJrseC1pR/an71TimPfuiwF"
    "s2dpmsIdj2IZyp/WNh46+9cGtHGLfH4bmHuGjU2Vo1EYVlekOAXScXeFxr4BTkbEMK4gmSzt"
    "GMsszkyw9tgDq4NHmjljo4Wa35epW7bEJPHUjkEchTS+Ufjulq5RdswtUBVM5U1kicu9cNee"
    "ZVnGw6IrntzxwqrknhsexTNal2W9ZUzyhBV0dyR8QEDzANZQ2T81sHM5IMtRjCofIg55Rk/e"
    "GGCCCYuuBTu2OEXRDcfOY0+HHtxlE8Qq/NAwJOO9X75hBTDpuMvPZVl+lyCzs/oueT+jv6NC"
    "4nhblH1UMJXDZYc73n++DNgVIhkTPOi54DuSPGVBevF8WUqEwhUvxZUMVrcew3/xEJn92EW/"
    "fAu+peBOhzCtrIdjpO4SJs30yWuS57W9KcYu+2U9FKW1jC2W50kSN6tm/yL12AQYcRQ7LqxK"
    "eT7WhIool+MCOjWiKVEUwwjH26Lso4KpHA9K37MUyr5Y7hDIfjyzKCWK1mVZf1nOL/cj+OlD"
    "+LHzw4fpAfzubaJRhSyWnXIiSP1luC9Kk4OQeZWJ0hdmgH2IH2ZLUs4Ldyw9BuHEXVqYLYeW"
    "cZ0fMYT56eGxUv/62XAAaXpluH+/oYKpHH12zA0npHXD+3WWfSszud19US3mjfenQgbBNFuX"
    "8bGzw+dkA8BnN4HKcmPCtKVsPVInK05p/nipQb17ZYa8Y2UWGewolikpg0FNjfu8ewXYdNGC"
    "R45dBvFkEtece8/1bVnuT5OVR8N/j797roKpHE06Itn7u7MmT88FX9ZkI02TLNfrCcJp6+Kx"
    "cEkkd3x/l8hvrANu7NeJSTLhLI02YrInxjClPjNblLHvell2CqJCOKmwIoEdscPwDLOUCO2X"
    "VSNt3lx6pyCMJjQtBrrudxJqdAS2I+go1hu6T9xzFUzlCLHsgiqEMi1nUbjlZok7ziHJUxah"
    "l8vnmlo2toVYhvfcfjveXlf44MBVFyO/dAvtfMXfiq50EkQPUCiCz5Zm3EK8csdKi/nwmeOS"
    "EQso4p13K5gAcHmF0XoCx9hk+NwcpSjc7ySOOwbTFch+wuqYo4KpHD061uQCd3xRomfRFhM4"
    "ZXPgstdlZ+543F9EbW3zvfhb79if8swZ+IM7ZOxKezs21pA54ySF6s5LsqecChltyxj2A3re"
    "bGFdMmfDckeDjLA7gDNDpyP1eGICOJg4MMQsfBa97FrHWGeKeZbueRDLpaVFxxgVTOWIsIt1"
    "maY8lomenhguFM8idmmq0LC4EEyU7nksSwIwv4CTmOAHH9jfEfzeBjAZ8xYZtB3LMrjnsUtR"
    "bBpsQDt6YSZXPOVXCgutnPHUjx8WWfLTd2lhftMqioXVAIYPtZgMDqdGjPZQXtQNwHZd89LS"
    "vI+EUwVTOVossi65uL9XdnxZ7BJWSolsORUyCmdO9ACEtc0n8N++w+774vjUOvHWqnsZJEVE"
    "MU6JWFbECGuSR/EsV4rsLjyWbsti9dINjlZc+vSYIAJO2bsTqMdWgDrFcAEYIzOLooAWcYSy"
    "OT7v+Dunefq1mcc98aOCqRwB9rAuk2gGAeQ9xDIWsJti5k5M8iBkxlEuclbUXrbnUDVn8Bcf"
    "3P9R/NI6u/mae5XC3MWY4DEeIIfOWj6xNjO622mF3E7lTnn8hYgCWBgTJIIF4cRdWpiPrQBN"
    "iGGKRSkZKA6uOZvY7b34X2FldhI/RQLofkr8qGAqh0tpcCyLXZrSojRZ4JYle0ywJvuiWo1C"
    "oqc3d7yovVy98wT+5tsNhixBUbLhgC9skcFpdz1U4YTMOIXmGxzccuQOTTHhE46zM5886mPa"
    "t5dEiXO6S/1hhoV0HrobHlkBtlxhDZrQuNgAvpwmGcUwxko7TTri4dyfiR8VTOVwWXoRhQut"
    "7KzeKViPxee7ueM9IfWxWD2IJcfngxK0a6DZefyVC/s/jN+6DaxO/G1YasDgVEKURBKpVqcs"
    "KcpuO2cR7ZwGg8564IvOW3mX6a7mkgPAiIBHVhhzFlccyLFL+QyfsuUS38TyxA+Kv++jOKYK"
    "pnI02M26NP1SoiX1loumQZYJIFu64nE6ZHw/wsrm4/grF+iuynJ+6Rb526vua4hpncL1Np6S"
    "dRnnkcdemGUdZvZtwykpSy1LtxzYOZuGcorobi1MAPjoGUIbrMwkiOG3iW2YCWSATgd4k/dP"
    "tZopWrkgjnmMDU0VTOUQGWhdciGWKTO+RCBLIY2xTtOLW5pQXmQKC9NPgO134K9fvLur+Zdv"
    "gv0Z9zK89yDyaYZPWou8296tbCCcE0NIBexxFOKiFxbaImuzR3sPxtxHTjNqNtn1Nnm6JFNw"
    "09mLSBqTBLIz55yQajl3xDGPOW+5JSqI6M8f9hgKPnDYAzgSxLrETn9Lyn8va7Kx0A3vxy6L"
    "FSHLdXpi/DJk4OvNb8CPPAC8bZ99JAHghW1gm9lh1d2SZpXMYlVKsw3DcbaPdF83ZdF6LB7i"
    "IDZF8if/nlB+wPvyiR3n0YOx7u5emL7zJHDHGZypCdYwPBgmiSZJiZEl+V2AJILIATvimKVz"
    "HoVywWJvx423nGAC+MRhD0ABdlw4yfoobpc12VhmXUbRjFZoWls8Tn2M1mWR7DEG8CPYrUfx"
    "31y5O4frn9wE+xP+FTAzjHHE8CjauSFtHIN+RZMNgSk8XxadJ2Ety4rkbyrLi2LskwgOwLrD"
    "XbNmJVv+NU9YIQAWYMdiWVpxy+P8STbhoynZkMgrXFK3Aip1kL/7sR0F1CVXDpdi1suOXpf9"
    "uGXaFs0XLyzIfs9LWHHJS7FMbjvBbl3Bv32GcXl8d4fw7E247ZPuayDyYHbk4YgJ5KSkyDBg"
    "uIhjli543x0vxZSCRbmo3Vt/TaNw24Jxs72744j82bOA83nGD4NFLAmpqbCs61aUFRXRk1RE"
    "j/LrzEsFAzmO2bdLjzoqmMrhk/onxvv9jHgxm6ef/d7ReKP/fCxSj3HLXpMNVBhtPrbvaZCR"
    "2w74l5tkcLp9FRTsSc+SJc8V30AqG6K8tk88/NLa5GidiSiSMfnxTi1mduX7p/Jae28a9D2n"
    "GFWIY3qI1VuGkz0Fi9N0w8wyjRJZGAuLuFN0f4xRwVQOgQUXTj9+GTPky4SyYyUWUyXL2GV0"
    "wdMqkEE0iyYbtPUwvvUE4f2rd3ckn1oHJhN/C8a3ADyMcQRyZZd1KVwXt5l6SZ4yI55n/QBJ"
    "c5K1KZUCVLZ86xSCB4ElxuvNvfm9334SuONIGtQR4KM4GoYPcwI4iKZkydGxMlMX+Eh0HO6D"
    "0iIVTOXw6Ldw67vi/ez4Xo02+t2IYnLHFO3b4n4hC7+6+Tj++0t3WbgI4Bdvwq2fcC8hRiqZ"
    "HYG8Cev1SGf1UHsZM+Sp9rJwy4HCh8XOmsy4rk9SJeQi97g/GETA6/cQwwRkiYv3rgIzNiKK"
    "USSTQFIhmj0rs3eb+7MX4h6szuPolqtgKm8yy66NBRZmv5RoUewyTXss6jM7ohnjlnV+zoRS"
    "ouk78ciownedvLsjYQC/dpOAs+4VGOPB7MDs4LwjT0W3IqT7uYC9tDC7yZC0SFpRW0nGdEW0"
    "I5R5X0OMW/cYwwSA7zvDoVlJngLpieFD/X+cOslgcdGL/5Wi2f89zItlHhuN7KCCqRwOZYJn"
    "t2mQS5eg6MUuo6jaupsdL1eENHXxntJk43+4B+vys5uAM9xg3N6G5I4diFopXJdkT6q9dCzL"
    "5ka3PIhkXDWytDqBQkzLx8hI5KKIZ4qVGdWTQObesuSR7zsDOG9ToXosaY2JHx8L2aM7Xrrl"
    "KVlUQJBi+2PulqtgKodHGX8rm2z045f9JXPL+8liLCzN2GQjNgdOGXKS1zGA2UN4gFbwfWfv"
    "fvi/cgvcnJDuRBDb0YG5JcfOhFKiWLhOTDCxLH1hVjwIYIxjIj+GILw7xCbpZN6fwNg4AAvz"
    "W9eAs5YwY5uacXjDadYP4JOQRnd9mVueYpqdxE8ST5JDOB4mpwqm8iayJNlTlhLFLHl//vgi"
    "K7NsENxvvhG7E8WOROXiZiCc2Hwvnrlk7yl49n/dgJud8l8DkQOzB5ED4IjJSbKHUi9MALn3"
    "Zc967LSCA9L56I+NUlf2sG/sPh8FlwiGGLfvoXC95K9eYMBbJOfbBHe8IvjKhA4jSJZnp7So"
    "P1Wy75b3ZywdE8tTBVN58+knezqiuYsrnpoBl9nxYp/SFY9xS1vMG48t3JoHMPEn8cP7bBBc"
    "8noLfGGbDE411+A9A3BwzoGoIYZPc8Y7yR2DWG60IyveWUkyi2pH+v7/9r4mRpIsSeuz99w9"
    "IvKnKrMmc2qyt7QUS64Qxc+BXqGRQKIPnLjMSqsWghEHhOCyu6z2xGEPrRYnOCBxXXEALayE"
    "Shz2wEoIoSmBBkY7Kq2YbdXMjpKmerpmcnIzpyqr8ifC3d97xsGe+XseEdVd3VmdldnjJnl7"
    "hEdURJhn++efmX1mr1ueI25xkhF151R2hWF83Hx+39T+4TYwdSbKiJAq5cS9fGa3OJqiScck"
    "FzVP3JNGXT8bAHOwN2xzOcx8UPDLpql3ofp8scckzaWOcMu1mjrC7ewefucti+ICROy/HgOj"
    "lfAUxD7qLz2sbRFCJysygTvNJWXguVS03quQ6z79+1yHScoy9fzl/5YII8v4k/PP75va7RL4"
    "+jpj6m3WSx63eOqTgD1fVZI6FpmH6b2Q/HpE4As2AOZgl2QvCcdzoDQZu+wWN1OwzEBvodiT"
    "V8tj/lJBU0e5KTtz67DNFv7xVy/mzX9+Bney5p50YnXJXwrDDPDdaDcf0qJnGbtcVimPkezc"
    "BKP8/OnyvLrlOETd8YYC/s/ZxfxT+43bQMEFdJAwk0TpTFotZwRL0tJpoLQ5VcyjCebPUWYC"
    "cP9+Xke/8jYA5mCXawvaS6TnHRXJgXMJWCI73gnWdShwtvREPmwjssvx6V/Cb32NMLnA//kB"
    "wH8/JoONsI+ovQSzh7UOWQ6TAmTdHgbI9yvhOXAS+mwTQCdQ7yrk+h5SQXzsJ1fA1ecgkGF8"
    "5/Tz+5fb390EXCA4UGKXcQAHGx0sLEM6umlGYOn6MTTHLgHt+unA9N13u++iawCcA2AO9gYt"
    "Mstl8qKFkDxjnHn1vPc4AudC3jJ+ZlgBzd7CP/vaxa7LPzoBTMEzjMMZiDyM8TDGwTkHoKXW"
    "s+lC6bjoGWgBFPsFoLSmD2UIk4NpNy5O36WV8zyUZ4Y1Ad87fz3YUxLwzS2gCUWshMdF0SjE"
    "DiDqUsnKKzuqjHyvP3sIyQcb7AKWFTGQV8bnquScA6eG2FlFnGNFHBbdOuMKmlEsWJ39Rfyj"
    "bWDzgjO6/tNTCtN1/yMZDIkAwIHZwVoXdZhORerKMufzlV2LJDSKpWw25lw1HfGYAirNsdO5"
    "81lYxkED1AGvxf7pbYb3Rpih6i9JwnG9twWVFkUJEeuwDXUhGyLM6s81LPwMgDnY5VsMLbtL"
    "fb7DR8EylxblzJLzsD3TYJJqLjOwVE0nj2DO7+Kfv3Wx/+UDgP9wBHa32o90OhFUtB6CA7Oj"
    "IOPdjIKeD0hLViABJ5bkMzuRUbKOd2bAupD/nMOe1YLxg+mFXO3sr6wAb1VAHXQFSamQs5F8"
    "ZohfLhPYuS9i133nZPY3v4YscwDMwS7BsoukA8v8tbkKeQ6S86DZFYTmQnYdHtwtbJZX1Qn2"
    "bBffuCUX/kXsW88BLvgcY38CLfQIULYwpgXQUkDoDdzoQB5zYXjGOBX44nT2Li+p++5YHCCc"
    "A2U3mDedZ2MY33sNlXK1f/JVILAFelOK8lZIXkCTjlmqdbKiDN0fPOih5lXPYw6AOdjl2nx3"
    "j14/y1imssNcdM7KNiN77DSYWhVX4LSJ3gSL6mwX7/3Cxf93/7eH8M9vuA+76jiRA1ELohbM"
    "DsY44hiSM3UssweMcyCpAJg/Tx0/yqapA0vBJurC9G4UnGoymVFTwB+fvT7seecGgJDNtCSA"
    "jYnZkhiK6xxMZZRzDJLnV5EEgHfeeW2/8TJsAMzB3qwtG+uWM03OjnXMMgJtvkyu5ip1iQoF"
    "GRBQ38GvrMkk8YvYNAB/+IyALfdxF47H7h4ALoJmSzBeijXUDdyQ8Lvr6VlkmBlopqIQd0Ao"
    "+GNSsB4YBLM4Ki4Wmgob8J3T15cj/KsrwCwQPDJtJULXEqm/VUeARgfkv4uJVuTvAgC8//6V"
    "ZpZq12GJigMAf/Cmf8Q1sc86duFbAB5/Ab/jJabrLBiKQEegkkAFwZQEMyKYkYEdGdDYwE4M"
    "7NjATCyoksc0Ntl7LOzYwq4Y2EmBYtXKsZG8H5ZA1oxPfvHmr32luCBcAn/wFCgm4Rglzzop"
    "EZGE4yJabwE4V/nDdkT/yxCH4OCNITaegwlgYhMlisq2YgOQCRQsTLCgYNkGCwoF7Pxzb9kE"
    "CxtKGF+w9QUXvoBlyzYYNmxh2BhCCPS9n9H2c8908/PPF+nMEvDVCvy8okMGz0wZvC+NCw23"
    "3qL1hl0oyBWOnGnYcwtvPIJpOVhvAvvUji4aJDAI0o8kWsxrUQG68oDJzH8M4Fff9O/4Mhr/"
    "Kv/2ZXxPlpdKMebensHursbWFicnJYwpYG0FogptO4IxI3g/AtHiFsIYzCNYO4H3KyBaBfMq"
    "jJkghAmIKjCXAEyxv/J3/vaNi/vxu4dwL266D7vquIbjxrRglpCcyO3vtn+y/0v1H6GqpmCu"
    "wdwgBHmd2WM0CpjNgPEYAAyILNq2BFEJ5yoYU6EsK3g/QggjFMUIIVQARmAegXkMaycAVgCs"
    "AliJPo/Eb2cB2BvT8PX/8oxu/YOti/vOAH7agJtfdv8DJpyA6BzsT8D8HNYew7kTWPsCzKcw"
    "5hwhzBBCjRBqVFUD71t43+LmTQfA4/FHAXfvvoa5SpdrQ0g+2Ju34+OklwGAuk7hWVEACrTe"
    "m7gneA94b+CcxN8cdUf6Ht0aGnOg8i9/zonqaoct8N1TImy6HyMv9nivYJk2a0Vi1LYylIPZ"
    "o6r0sWwhhEyWlI7rYz1ubYD3+m+4Oy6j5HwmmvcAOA4BYQD8Yt09+b2ffeaoY6l9OAMqyw7k"
    "dRaSJACIGG0LlKV8LzPgunFJjNHoWjDHV7UBMAd7M7a7u/z4bJazUcBlC9RYC3ifHpelvI8y"
    "jZIxCSyJgMaM/vyYw0UTZL/7Z2C76g9QUgsiDyIJw6Uy3sCYNm5Jk1kUkttUAByNPEKQx5NJ"
    "AsfZjLv3FEVAWfbWmoyvcRTIp+PyWQmI5XelbOam+7P/+Zzo7DXoMf/VPkK77j+K38/d7yKS"
    "3yugzigK2QBGVaneaK40DuDu3fT83XevDagOgDnYl8tCoJ4gehyme1OyF8GMH0yBf/kTCmc7"
    "7QfwvusZ7xil5C4bAA6AskttmQyoKo/ZTABmPE4Ad3bGmE65xzzL0qNpQu9YYpseAqo+gmMn"
    "lofkrxO4AoyS63IlHP/7w4vlB39UA79/RFzfrr8PWXddvscYKXjJcwFR5xhty2BmNA2QA+XN"
    "m4yjI2B/P334gweyf++9awGaA2AO9mZsb2/58fG4qxEDQGQrYhKGp/eGABjDPQZDXfOgHC+4"
    "LS23P/ycIm7HwN/bI99stY+wws9hjAPQAhCwBBoURZPlMh2c8ygKATFmAcvRKAGabpNJwHgc"
    "OtYJBDSNgGbOMBUovRew8j7AOWGXIfjuewSw9d8yAD7dqT/4nY8pHLSfz//zAHzjh3DhVvun"
    "qDCFivQB13132pQly98j/V3k8fExsLXF2NlJf9N33ukD5RUXsw+AOdibt42N/kWjea+y5JgP"
    "SxeehHmyGSNgI+vpSHio08+7RcPAzQ3/k9/+EfxnpTAM4Lc+ovAjDi/815ofIoTELmWrQdRA"
    "2GUD51oUheuBWFV5jEb9/OX8NpmEjonmOUzmBJbGuIzR5YAsrFb3+u8kdAZWwkl703/864/x"
    "mUl2y8A3/hT+/xbhp80vtI+gQClpCNcx7PTcoyh8x3JHoxAZqfy9NjYYh4fy4Xt7wMOHi+ec"
    "r3a/5ACYg12+PXwI7O4ynjxBdwEpC8lZSdui9zxfQsx72ReFMC7N7XGcT5mE5Vy/VX//f9d8"
    "+i9+/Oqg4Rj45h78f3zOp6d3Z9+O4bXrANL7BkANohmYmw445D0JLGezflFnbU22edDUIlAC"
    "SwEf5/phuczd9BG8BTSV3SpwSh5V38/1Tv2D//YC7vcOX+LsEvtwBvyND+C+G/hn01+cfhei"
    "MxV2Lf42IBK/vc/BUkHfYzZLf7v1ddlvb8t+d5fx9ttXGhyX2QCYg12+6YVy545cQM+e6Ss9"
    "+XXM6UkhpCi0YizFD60eOxe6aUEakiYgEYZDCGd/bvbdf32A9u/vwf/kU6aRf/sE+FuPyP/h"
    "lJ+d/YXpA5Q8jYxSQJJZgbIG0HSAmQ/hYHaoawnFz88X85Hr64ugqcCaQvJ+yCs3Bh8BVgtK"
    "AliSJlDxvLBcLQJZ9ud3Z9/5zY8x+43HFD5p2fJTD/ybn4L/+gfkv7/mHp390vTbMNTG3G0D"
    "QJi1tSKXMkYKXrkqoCw9qipgNAo4P083wadP9W98bY2uOAMe7EtgS3SYsd8PBgcHFmVpURRF"
    "1GGWIBItpnNJh2mMaAy9H8fXVZM5hvcTEE1AtALmVTCPQTQGUMGYAiFIO5Cnotqvfrk4Lu5+"
    "cwvm62tMf20FWDHAhzXw/2rg3x2R+2HN7uwr7fd5u/0IBG17bADMAJyB6AzMpwjhFNbKnugc"
    "1k4RQo2imAGoMZ1KQWg0arGy4nByokxSLrqNDeDFCwNjLGazAqurBYwp0TSixfR+NKfHrBCC"
    "nIcQ5Jwwj2HMGCGswJgJmFdAJBpVohLMaey8N8Xq49GvfM3TzV+7RfZvrjPdmwAHrRR2vnUC"
    "//tHBEz80dlO+wFWwvPIrFsIm54COAfzGQDRXYZwCmPOEMIZjDkHc4OikJuJ6k9Fgym53bb1"
    "2NlJedb79zlWyedXYr+SNgDmYF+49QDz/n3Cu+8KaD5+bHH3rojXnz8vYG0CDBWwq3h9OXCI"
    "kBsYg2gFgAAGMImAOUIIMvONyIKIwEyYmVX8rHhrvTEbVJsbzDC25Gld8sl01R9gy/0YBNU4"
    "OhDVEMA4B3AOolOEcAaiExijQDHF2dkM47EItsuyQaqiO6yuOjx/3gdMIoIxJm5yw6jrEpNJ"
    "2d0w5CbR9x8ouxuGcyMUxRjME1gron3mSXduBDQtiFSrSjgut+2pubU2M19xDa2WBRpfhtOz"
    "UXgWttofoeIpdGydMmth09Po9ykAuVEUxSlCOIe152jbGYyZdWL1EAQwQ5BZoc55bG977O0F"
    "7O52KQO8/z7w3nsDYA42GLDAMIEHDwzeeSexTMDi+FgA09qyx7Jy0FRm6f0IRVGCeQTvx5F9"
    "CtM0ZiUyrkkHGAIwFswmAseyUmzKkxqjesk2bjm7Ou9YFSBgKQxLc5l1BhgtJpMWp6cea2sO"
    "z54FbG5qHlbOx7NnBpubBqenAphEBZqmwmRSom0TYCrrVnape715CGCOoV0/gNww1HegiP5T"
    "53++mJqmL7SAphKpEFoYo2A5hbWncO4c1p6A+by7YYQwRdM0mEyEXU6nbTwHDmtrLZ4+FXZ5"
    "+3auAMhTMLgOgHnlWyMHu/7GcUgb4lyiKCWR50+eSC5T81zzeT0dcqFFBe81n2cgmscWgLA0"
    "7wsANQCCMTJLLASOHShFx7QUNIxhhEAgkvflhSNjXKevJBKwIBLALIopiKZwbgbnGlRVqhqX"
    "ZYvZTH7v+bnkWdfWBCQ2NwMODzl27Mggke3tgONjgrUBKyse06mJVXUDHe5RFA7eW2guUyVE"
    "xlgwE5glrA9BzoOK9lUzCZSQrpw44inWLnSIrzFSRJNiEiMEXb+zq5QAAA8ASURBVNBNwFLy"
    "tVNYew7vpyiKczg3Q1HM0LYq2ncoCjkPgO9E+swBx8ccP7cHkNfRBsAc7E2ZgOadO4yDA5EQ"
    "ra8HnJ7KRTYaCVi0bWoBdE7F2tICKYMvBAQFQGswi1ZTgYCIY/GjQAgFtIVSQZMo6Te1WyYE"
    "D2OamLucAZiBaNqF5MK0ZjBGih9N00bg9qhrj6qSqvF4nDp7nj4VUNre7jPMw0MDa0PXrXR2"
    "FrC66lHXFpOJQ9saOGdjhToxcmsJbWtQFOiYM0ARBEmmOmUdOVIskr59eZ16OtbELENW7a+7"
    "UJx5Bu/POzZZlhJ6G5MKXnUtN7XpNERJkWwbG/K5T57kYCmPJRz/Yv9Pe402hOSDXYq9NI8J"
    "GOzvW+zsmC4sl3zeYmiewlPN4ZXwvoIxJSRfKeF7COMuh2dtBWYZxCGgaTqmpeGotcrEtCIt"
    "obhKh4yZApCQXPZThCD5OmNSgYO56XKXmrtbWxPGdXgYsL0toHHnTgJMPQfPnllsblqcnkpa"
    "oq7LeA7m/Zc9UMX8rLwuoXcFZin4SDEoDuPgKjLsIrJSMycQ56hndVCdaQgtrK1jEWsK56Yw"
    "ZgpmYdvM6rvcOKTYUwNQ39vYa98v9jx6xLh3byEchwwXvvJgNDDMwS7XYoI/PpOwXDWVGxsB"
    "L14IKzk/FxmRMKPENquqjf3laciGhJ+CAIk1SWgdghYuSgACGDqsQ1gooEJrLfJYK1VxogbW"
    "zmJ+UlimtTO0bY2qkr1OKdLiznTaF6oDAUdHnIFl0oI+fizDRcqScfu2TAdWydBoZNA0BmXp"
    "ugEjzhmUpQ4fkR76ohCfi4JjJxShLPM+c5EcGVOAWQpAIci5kxsFEPWqkHBaByE3CKGOOdkp"
    "jJnBuVknpzKmjkCZ/K9rYef5oJGcXe7tAffuMR48WOjwuQ5gCQyAOdglWZfHFLCk7vCjR4SV"
    "FQHMoyMRohNJz7UxfdAoCi1YpPDTGAnBQyBUlebKtOvHRbZUQcFSmJYChgCMAIa+3yEEBxmo"
    "UXegwVxH8Ky74wKsbWSVrttCEOBYX9eWxhwsEzDoVJ87dwIODwnb2wIyq6se5+cC6nVtosbU"
    "wFrqcpbWyo3COXR7aUkMcE6HdMg0paIo4X0ZbxYpj6t5zpS7VS2r9sbXsUIuIFkUNZxToFSw"
    "1HMgvp+fpwlKmo7Y32c4x2ga+TsnsLwWIJnbEJIPdmn20mr53p7BeGxw547k51680LBcNgnL"
    "yxiKV3Ev1W/vS4RQoSgKeC9hN1EZw9Uie6+NObwCACEEA2sZxgAhKCOV8FlyeBpi16jrFmU5"
    "645J1VjeE4KE4FUlYagAZgrF8x7r5QWPpBY4OrIoCgtrbee7/n6iEm1bdWkIPea9+E5UACjB"
    "XMLaIp6X9FzCcYMQiui7fr+OaXPwXhsAVEokPlpbw7mmC73lWNuF4Qqa5+cOo5Ew7RCkQKeV"
    "8b09xu5uwIMHjMPDTnsZf8C1AaGBYQ72JiyvlgNNk0aC6dgyKfQIo6oqh6aRQkW+2IHm4TQE"
    "195y76Uv27kiXswFrFXAVHZpYr+5AoYul+sjw2wjO5XhGm3boKoatG3bFTpCaGJVXNmlMMu1"
    "Nd9JiPb3GXXNcZxZHzAfPiS8/TZjb48xHjPKMsAYHVfnARDq2mBlRfwuS2WV+cg7YW9EHItH"
    "HswFvJcCWVG08F50qCEUne9ASl/k55xIROZl2cI58bVtW1gr+6rSziaHEBrUtYtFLofx2MWW"
    "zYCbNyVvK6mGeXZ5bSvlA2AOdmmWyYvE7t8Htrc1nyW5vYMDisNoE2iIREjBE2jj6B0NR/P+"
    "8qKQ4kXTlLFyXURwtFF6JOFsyuHJvxVZkchpEtNy0LbHqmrRtg7WJrBQsEysSkDz+FhAGwjY"
    "2VmqOQQAvP22gOZkwlHIDRweEm7dAl68IEilXVIPRIS6FjDV9AORyoH0/Nk4xUhHwEkILt1O"
    "plMXGEPxJkMgSu2m3oeY81X9pYsgKUWwqnIRPCUNIWDZLtwslFXLbxGfp9OlQHmd2CUwhOSD"
    "XbL1ALPfKplC08NDi+1tCc9zQTdREZdy0FC1gHNl95qEpQWIbNQtaofP3NKTWQ5VWJZ238hg"
    "CwVMY4RtSW94Km6UZYu6FoBUsEwT2D02NjwODgLaNsS85cvCcTkHwjQJjx8bjEYGOztp6Q71"
    "P4naS4xG6Tx4r6mHAmVp4/lQJi3+t62NrDI/1+h+k2hVk0pA/E296hqmq//MwkC1dz6/WXgv"
    "8q+trZcJ1Hvn4boB5jB8Y7BLtSUXiFxAMuqL8fgxdyzp2TOpGK+spIJKWQpgad6sKCRk1lyb"
    "Fmi0MGHMNGooVQ4zja2M0s5IdA5jRJStr4tAfYq2zYs+TbYX1pWD5eqqw/p6KnQoWD56NA8S"
    "i+Ahw0gktFZGenQUcHycKv3yPcro8uUwkv9yDpLMSXSpsyi0PweR+n8G6dJRIb60NkrXkpwr"
    "Y6ZdmyNzjaZJQ0aYhVmfny+C5caG74pcy3x9//1P+n/hytvAMAe7dPsUltkvgmxt5UzTRiZp"
    "O0bZNEXvmISltmNZeXdLUfTzfzKMWHJ/1gpQOceRXaW5kwrWVeUwm/kuZ8fs41ANqYg/fRpw"
    "69Y8s8or4y+72Pq+P3liUJYGt28bHB9LEYjIxl5zYZvjsY2Mu8j81vOQM0zTKQzSd4nvohLg"
    "bj0ga/2C/8wOReFQli4T5bvuNZ0RqmApEqJ0s+hrLnvnYADMwQZ7RetA8/33KXZ6JNDQqnlZ"
    "St5ta8vgxQsLYyzW1iym0wSQApgaehaoKgFJ5xQ0RLuooJEDJiDFJuck96m6ybYNESgTcJSl"
    "61oeR6OUs5sHixwsHz5knJzkhQ5gEST6k5wePTK4dy/vs58HzXTT6N8sFChzwEzaTTkf8j3i"
    "M7JCW1pTSFtDE2Dmw5Bdd0xvFoDkbOf9z8Hy/n3kVfF4Eq4l8AyAOdgbsSUsU/d9pnXnDnVM"
    "U0EzAUcOEJKrI7KoKoO2FdBQwMhzd85RtvSFrEFTFP1Fx9LaOmkYcFotMu1DWAQLBUsNtV+F"
    "YUr3k54Dg5xp56C5vm5wdmYj0xR/x2OLprE9dql5W22ZBCj6nX9vHzDlPORT332czel7QKlr"
    "FYXgceOGx9GRFLmkIi5gOZ3O3yyuPVgCQw5zsDdkcxeNPL5/Xx8zHj3irmCytaUXpUz9CcFh"
    "MlHdo+bUpHIrUpfUpaLtfZrbVAF6/3nKU4qusukey2emxc7ke0VnqQWOg4M+WAICFq8GlvKa"
    "rpz44AHw8GGSWAEBBwciRl9fd3jxQvKlo5HkUb1vs8lAqotMj3Vt8L6faUuvaw5Y/ZYRdbNZ"
    "OsdnZ3LuV1el5TENQhFW/iUHS2BgmIO9YVtgmjnTSuFpYltPnxrcumVwcqIdK6arhNe17TEr"
    "ZVejEaFpEsOsKsQVDYHEsBhVNb+0ra7uGDCZCKvSyUOSr0xtf5qzm04/nVmqfjS/9vLUxIMH"
    "hPV1qZwD1OU0rZVNZ2iq3/k5yNll0yz3P1laI6muxf+6ThOj8oXbVlY8Tk7Schqqd5VhInKj"
    "WA6WPf8HwBxssAsYydSg3qG58FRymru7hP19g50dHVaRA0d/y0PRutZxZ4TRCKjrBBqy2Bpj"
    "NgNGo3y9bd0vrrsTgs60FFH6zk7ouliAvE/6lcDipakJBc3JhHo3DZlu9HLfiQxmM4PJJPme"
    "+59bXQP5mkmjUcB0yhiPF31fX1flAsP7gK2tBJS5/7nf/bkB1x4sgQEwB7sC9kqg2a+gy/7p"
    "UwGNjQ3CyYmAxdoa4exMe6UTYMxmhMlEPn02o245X2bGdApMJlr40MXYZLGykxPpTb95U0e0"
    "palDzjHu3l0mSv9MzOoTQfOdd+Sx3jQAwsGBFsMIx8c5cCaf9fky/9WmU13WOLFsPQerq+I7"
    "c8CNGwKUOs+zP0ikLxvSAs+XECyBATAHuyI2BxrxULdfvh0cGNy+TTFMJzx/LiBx4wbh9DQx"
    "S/0sWrLotTKs1dV+7pGZO6BgZty6FXBwwF2r37LtAmDxCUWwxXPw5Il0K+3sEI6OEnASEW7e"
    "1JtHYpYv8z9d/PkAZ5lL+vy5PN7YkGlLzGmWp2hlpd3xFVIQXxawBAbAHOwK2SeCZs628m1/"
    "X1v9CNvbi6D64oWAxvo6cHKyCJh6MesSv/kmQzlk/zKg/IQQPD555QvsU28a0kZJqCpCUcim"
    "wKnvefZMmSbFm4f4vdz/5PuNG4znz/vnQXK0y28Or8CqP6v/18EGwBzsStnS8Hx+L62Eemz5"
    "dnQkIHrrFvDsGWFzEzg+XgTMjQ1Z5ndzUy7+oyN0IBkCY2dnESAePkTGqrBkr08+88X1KaCZ"
    "fH70qA+cd+70z8en+b+xIb9NfX/6VKY2bW0lP/f3RdjunGy7u8tAMvfxSw2WwCArGuyKGcsk"
    "2f5FKO106WJ9++2c+aTK9uPHqR+6bT1u3RJh9eamw+Ghx8aG621tK8c3Nx0ODtK/296WkWQ7"
    "O7LCoX6+yn363z8PImCpf38usFjy7+bBifHggYjCd3dl0PKdO0kH+uSJnIOtLfEl979tk++H"
    "h77zHZBzpe+XzwjY2fG4c0fWJspXeVzOLl+L/1fdBsAc7Epa74KTfOAicOQicUDAQ4FjZ8d3"
    "APrkScD2tk7RSdv2tqzBAwhAPn4cFkAyB4pFoATmgOF1AMUSwOl/3+FhHzjVfyAHT12hUfyv"
    "a987B+q7Aqz63v8M+ex792SO5SeH5K/N/6tsQ0g+2JW2JSE6sKxAknKc6dijR4R79+TI3t6y"
    "/CVimIn4fllCQWwZIF56+LkkRI+HFx7LPqUr5t+3eA5e5ntKOQDqV2pvTMcy+7IDpdoAmINd"
    "C3sF4Jh/3n+tDyT58RwcsGS9mfR4rvqdveELv4g+1f8kw5q/eYg9fCjv1XMg06H6voul532Q"
    "7L+WDvxcAcgAmINdK3sJcMSXMssB5LPZsgti8dgbWuVwqf+pSyjZ5/F/ESCBlwDizxtQqg2A"
    "Odi1tJeE6r23XODjX/rBVwUoPuHGsRxAX90+0b+r4v+bsgEwB7v29ong8RrsqoPEz7v/l2kD"
    "YA72pbSLgMh1B4hXYN8vtevu+xdtA2AONthgg72iDTrMwQYbbLBXtAEwBxtssMFe0f4/U4pA"
    "UwOVBpYAAAAASUVORK5CYII=")


class RedirectOutput(object):
    def __init__(self, stdout):
        # store normal stdout
        self.stdout = stdout
        self.redirect_list = []
        self.sys_stdout = sys.stdout
        self.sys_stderr = sys.stderr

    def write(self, string):
        t = threading.current_thread()
        for x in self.redirect_list:
            if x[0] == t:
                   ##Do not put a print statement here!!##
                wx.CallAfter(x[1], string)
                if t.name == 'MainThread':
                    try:
                        self.stdout.write(string)
                    except IOError:  # may fail to write to stdout on macapplet
                        pass
                return
                # if string != "\n":
                #wx.MessageBox(string, "Error!")
        if t.name == 'MainThread':
            try:
                self.stdout.write(string)
            except IOError:  # may fail to write to stdout on macapplet
                pass
        else:
            if string == '\n':
                wx.CallAfter(self.stdout.write, string)
            else:
                wx.CallAfter(self.stdout.write,
                             'Thread ('+t.name + '):'+string)

    def add(self, t, method):
        self.redirect_list.append((t, method))

    def rm(self, t):
        self.redirect_list = [x for x
                              in self.redirect_list if x[0] != t]

    def flush(self):
        if hasattr(self.stdout, 'flush'):
            self.stdout.flush()


filepath = os.path.realpath(__file__)
pp = os.path.dirname(os.path.realpath(
    os.path.join(os.path.dirname(filepath), 'ifigure')))
piscope_path = os.path.join(pp, 'piscope.py')


class JobMonitor(threading.Thread):
    #    tempfile = os.path.join(tempfile.gettempdir(), 'piscopemac_'+os.getenv('USER')+'_'+str(os.getpid()))
    #    os.mkdir(tempfile)

    def __init__(self, task_queue, stdout,  *args, **kargs):
        super(JobMonitor, self).__init__(*args, **kargs)
        self.task_queue = task_queue
        self.stdout = stdout

    def run(self, *args, **kargs):
        #        self.p = subprocess.Popen(['/opt/local/bin/python2.7', '-E', piscope_path,
        #                                   '-l',  tempfile ],
        #                                   stdout = subprocess.PIPE,
        #                                   stderr = subprocess.STDOUT,
        #                                   universal_newlines = True )

        environ = os.environ.copy()
        del environ['PYTHONHOME']
        del environ['PYTHONPATH']
        self.p = subprocess.Popen(['/Users/shiraiwa/piscope_dev4/mac/applet/dist/piScope.app/Contents/MacOS/piScope', '-l',  tempfile],
                                  stdout=subprocess.PIPE,
                                  stderr=subprocess.STDOUT,
                                  universal_newlines=True,
                                  env=environ)

        for line in self.p.stdout.readlines():
            self.stdout.write(line)


class TaskBarIcon(wxTaskBarIcon):
    TBMENU_OPENNEW = wx.NewIdRef(count=1)
    TBMENU_OPENED = wx.NewIdRef(count=1)
    TBMENU_CLOSE = wx.NewIdRef(count=1)

    def __init__(self):
        wxTaskBarIcon.__init__(self, TBI_DOCK)
        #self.frame = frame

        # Set the image
        icon = self.MakeIcon(app_logo.GetImage())
        self.SetIcon(icon, "piScope")
        self.imgidx = 1

        # bind some events
        self.Bind(EVT_TASKBAR_LEFT_DCLICK, self.OnTaskBarActivate)
        self.Bind(wx.EVT_MENU, self.OnTaskBarClose, id=self.TBMENU_CLOSE)

    @property
    def frame(self):
        import wx
        app = wx.GetApp()
        return app.TopWindow
    
    def CreatePopupMenu(self):
        """
        This method is called by the base class when it needs to popup
        the menu for the default EVT_RIGHT_DOWN event.  Just create
        the menu how you want it and return it from this function,
        the base class takes care of the rest.
        """
        menu = wx.Menu()

        names = []
        if self.frame.IsShown():
            wname = self.frame.proj.getvar('filename')
            if wname is None:
                wname = 'untitled'
            else:
                wname = os.path.basename(wname)

            names.append('Main Window:'+wname)
        for v in self.frame.viewers:
            if v is not self.frame:
                names.append(v.GetTitle())

        for name in names:
            f1 = menu.Append(wx.ID_ANY, name)

            def func(evt, name1=name):
                self.OnRaiseOpened(evt, name1)
            self.Bind(wx.EVT_MENU, func, f1)
        if (len(names) != 1 and self.frame.IsShown() or
                len(names) != 0 and not self.frame.IsShown()):
            menu.AppendSeparator()
            menu.Append(self.TBMENU_CLOSE,   "Close All Figures")
        return menu

    def OnRaiseOpened(self, evt, name1):
        if name1.startswith('Main Window'):
            self.frame.Raise()
            return
        for v in self.frame.viewers:
            if v.GetTitle() == name1:
                v.Raise()

    def MakeIcon(self, img):
        """
        The various platforms have different requirements for the
        icon size...
        """
        if "wxMSW" in wx.PlatformInfo:
            img = img.Scale(16, 16)
        elif "wxGTK" in wx.PlatformInfo:
            img = img.Scale(22, 22)
        elif "wxMac" in wx.PlatformInfo:
            img = img.Scale(128, 128)
        # wxMac can be any size upto 128x128, so leave the source img alone....
        icon = IconFromBitmap(img.ConvertToBitmap())
        return icon

    def OnTaskBarActivate(self, evt):
        if self.frame.IsIconized():
            self.frame.Iconize(False)
        if not self.frame.IsShown():
            self.frame.Show(True)
        self.frame.Raise()

    def OnTaskBarClose(self, evt):
        for v in self.frame.viewers:
            if v is not self.frame:
                wx.CallAfter(v.Close)


class MainFrame(wx.Frame):
    def __init__(self, parent):
        wx.Frame.__init__(self, parent, title="piScope log")
        self.tbicon = TaskBarIcon(self)

        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

    def OnOpenNew(self, evt):
        self.queues.append(Queue.Queue())
        thread = JobMonitor(self.queues[-1], self.redirector)
        log = wx.TextCtrl(self.nb, -1,
                          style=wx.TE_MULTILINE | wx.TE_READONLY)
        log.AppendText(filepath+'\n')
        for key in os.environ:
            log.AppendText(key + ':' + os.environ[key]+'\n')
        self.redirector.add(thread, log.AppendText)
        self.nb.AddPage(log, thread.name)

        self.threads.append(thread)
        thread.start()
