# coding: utf-8
# -----------------------------------------------------------------------------------
# <copyright company="Aspose" file="ParagraphLink.py">
#   Copyright (c) 2019 Aspose.Words for Cloud
# </copyright>
# <summary>
#   Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
# </summary>
# -----------------------------------------------------------------------------------
import pprint
import re  # noqa: F401

import six


class ParagraphLink(object):
    """Paragraph link element.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'WordsApiLink',
        'node_id': 'str',
        'text': 'str'
    }

    attribute_map = {
        'link': 'link',
        'node_id': 'NodeId',
        'text': 'Text'
    }

    def __init__(self, link=None, node_id=None, text=None):  # noqa: E501
        """ParagraphLink - a model defined in Swagger"""  # noqa: E501

        self._link = None
        self._node_id = None
        self._text = None
        self.discriminator = None

        if link is not None:
            self.link = link
        if node_id is not None:
            self.node_id = node_id
        if text is not None:
            self.text = text

    @property
    def link(self):
        """Gets the link of this ParagraphLink.  # noqa: E501

        Gets or sets link to the document.  # noqa: E501

        :return: The link of this ParagraphLink.  # noqa: E501
        :rtype: WordsApiLink
        """
        return self._link

    @link.setter
    def link(self, link):
        """Sets the link of this ParagraphLink.

        Gets or sets link to the document.  # noqa: E501

        :param link: The link of this ParagraphLink.  # noqa: E501
        :type: WordsApiLink
        """
        self._link = link
    @property
    def node_id(self):
        """Gets the node_id of this ParagraphLink.  # noqa: E501

        Gets or sets node id.  # noqa: E501

        :return: The node_id of this ParagraphLink.  # noqa: E501
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """Sets the node_id of this ParagraphLink.

        Gets or sets node id.  # noqa: E501

        :param node_id: The node_id of this ParagraphLink.  # noqa: E501
        :type: str
        """
        self._node_id = node_id
    @property
    def text(self):
        """Gets the text of this ParagraphLink.  # noqa: E501

        Gets or sets paragraph's text.  # noqa: E501

        :return: The text of this ParagraphLink.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this ParagraphLink.

        Gets or sets paragraph's text.  # noqa: E501

        :param text: The text of this ParagraphLink.  # noqa: E501
        :type: str
        """
        self._text = text
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ParagraphLink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
