# **Gumly**

[![APM](https://img.shields.io/apm/l/python?style=plastic)](./LICENSE)


GAVB Utilities for Machine Learning Yum

The library consists of a collection of methods that can be used in order to help Data Scientists and Machine Learning Engineers during the development of Machine Learning applications seeking to reduce the time spent and complexity of coding.


## **Library Motivation and Description**

During the development of ML projects at GAVB, Data Scientists have the necessity to code some features for projects repeatedly. So, MLOps area identified the opportunity to create some standard functions that can help as it can be used many times by data science area in each different project.
Thus, it is possible to work with this framework that brings basically two main advantages: 
1 - Projects executed in less time than usual, due to the code reusability;
2 - Establishment of a standard coding structure for projects.

## **Functionality**

[Value Validation](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/value_validation.ipynb)

[Dimensionality Reduction](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/dimensionality_reduction.ipynb)

[Feature Engineering](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/feature_engineering.ipynb)

[Files](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/files.ipynb)

[Hyperparameter Tuning](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/hyperparameter_tuning.ipynb)

[Metrics](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/metrics.ipynb)

[Geo Location](https://github.com/GAVB-SERVICOS/Gumly/blob/main/exercises/geo_location.ipynb)


## **How to install**

```
pip install gumly
```


## **Release Notes**

[v1.0.0](https://github.com/GAVB-SERVICOS/Gumly/blob/main/CHANGELOG.md)
