<a id="mypy-boto3-robomaker"></a>

# mypy-boto3-robomaker

[![PyPI - mypy-boto3-robomaker](https://img.shields.io/pypi/v/mypy-boto3-robomaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-robomaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-robomaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-robomaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-robomaker?color=blue)](https://pypistats.org/packages/mypy-boto3-robomaker)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.RoboMaker 1.18.4](https://boto3.amazonaws.com/v1/documentation/api/1.18.4/reference/services/robomaker.html#RoboMaker)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-robomaker docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_robomaker/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-robomaker](#mypy-boto3-robomaker)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `RoboMaker` service.

```bash
python -m pip install boto3-stubs[robomaker]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[robomaker]` in your environment:
  `python -m pip install 'boto3-stubs[robomaker]'`

Both type checking and auto-complete should work for `RoboMaker` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[robomaker]` in your environment:
  `python -m pip install 'boto3-stubs[robomaker]'`

Both type checking and auto-complete should work for `RoboMaker` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[robomaker]` in your environment:
  `python -m pip install 'boto3-stubs[robomaker]'`
- Run `mypy` as usual

Type checking should work for `RoboMaker` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[robomaker]` in your environment:
  `python -m pip install 'boto3-stubs[robomaker]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `RoboMaker` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`RoboMakerClient` provides annotations for `boto3.client("robomaker")`.

```python
import boto3

from mypy_boto3_robomaker import RoboMakerClient

client: RoboMakerClient = boto3.client("robomaker")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RoboMakerClient = session.client("robomaker")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_robomaker.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_robomaker import RoboMakerClient
from mypy_boto3_robomaker.paginator import (
    ListDeploymentJobsPaginator,
    ListFleetsPaginator,
    ListRobotApplicationsPaginator,
    ListRobotsPaginator,
    ListSimulationApplicationsPaginator,
    ListSimulationJobBatchesPaginator,
    ListSimulationJobsPaginator,
    ListWorldExportJobsPaginator,
    ListWorldGenerationJobsPaginator,
    ListWorldTemplatesPaginator,
    ListWorldsPaginator,
)

client: RoboMakerClient = boto3.client("robomaker")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_deployment_jobs_paginator: ListDeploymentJobsPaginator = client.get_paginator("list_deployment_jobs")
list_fleets_paginator: ListFleetsPaginator = client.get_paginator("list_fleets")
list_robot_applications_paginator: ListRobotApplicationsPaginator = client.get_paginator("list_robot_applications")
list_robots_paginator: ListRobotsPaginator = client.get_paginator("list_robots")
list_simulation_applications_paginator: ListSimulationApplicationsPaginator = client.get_paginator("list_simulation_applications")
list_simulation_job_batches_paginator: ListSimulationJobBatchesPaginator = client.get_paginator("list_simulation_job_batches")
list_simulation_jobs_paginator: ListSimulationJobsPaginator = client.get_paginator("list_simulation_jobs")
list_world_export_jobs_paginator: ListWorldExportJobsPaginator = client.get_paginator("list_world_export_jobs")
list_world_generation_jobs_paginator: ListWorldGenerationJobsPaginator = client.get_paginator("list_world_generation_jobs")
list_world_templates_paginator: ListWorldTemplatesPaginator = client.get_paginator("list_world_templates")
list_worlds_paginator: ListWorldsPaginator = client.get_paginator("list_worlds")
```

<a id="literals"></a>

### Literals

`mypy_boto3_robomaker.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_robomaker.literals import (
    ArchitectureType,
    DeploymentJobErrorCodeType,
    DeploymentStatusType,
    ExitBehaviorType,
    FailureBehaviorType,
    ListDeploymentJobsPaginatorName,
    ListFleetsPaginatorName,
    ListRobotApplicationsPaginatorName,
    ListRobotsPaginatorName,
    ListSimulationApplicationsPaginatorName,
    ListSimulationJobBatchesPaginatorName,
    ListSimulationJobsPaginatorName,
    ListWorldExportJobsPaginatorName,
    ListWorldGenerationJobsPaginatorName,
    ListWorldTemplatesPaginatorName,
    ListWorldsPaginatorName,
    RenderingEngineTypeType,
    RobotDeploymentStepType,
    RobotSoftwareSuiteTypeType,
    RobotSoftwareSuiteVersionTypeType,
    RobotStatusType,
    SimulationJobBatchErrorCodeType,
    SimulationJobBatchStatusType,
    SimulationJobErrorCodeType,
    SimulationJobStatusType,
    SimulationSoftwareSuiteTypeType,
    UploadBehaviorType,
    WorldExportJobErrorCodeType,
    WorldExportJobStatusType,
    WorldGenerationJobErrorCodeType,
    WorldGenerationJobStatusType,
)

def check_value(value: ArchitectureType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_robomaker.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_robomaker.type_defs import (
    BatchDeleteWorldsRequestRequestTypeDef,
    BatchDeleteWorldsResponseTypeDef,
    BatchDescribeSimulationJobRequestRequestTypeDef,
    BatchDescribeSimulationJobResponseTypeDef,
    BatchPolicyTypeDef,
    CancelDeploymentJobRequestRequestTypeDef,
    CancelSimulationJobBatchRequestRequestTypeDef,
    CancelSimulationJobRequestRequestTypeDef,
    CancelWorldExportJobRequestRequestTypeDef,
    CancelWorldGenerationJobRequestRequestTypeDef,
    ComputeResponseTypeDef,
    ComputeTypeDef,
    CreateDeploymentJobRequestRequestTypeDef,
    CreateDeploymentJobResponseTypeDef,
    CreateFleetRequestRequestTypeDef,
    CreateFleetResponseTypeDef,
    CreateRobotApplicationRequestRequestTypeDef,
    CreateRobotApplicationResponseTypeDef,
    CreateRobotApplicationVersionRequestRequestTypeDef,
    CreateRobotApplicationVersionResponseTypeDef,
    CreateRobotRequestRequestTypeDef,
    CreateRobotResponseTypeDef,
    CreateSimulationApplicationRequestRequestTypeDef,
    CreateSimulationApplicationResponseTypeDef,
    CreateSimulationApplicationVersionRequestRequestTypeDef,
    CreateSimulationApplicationVersionResponseTypeDef,
    CreateSimulationJobRequestRequestTypeDef,
    CreateSimulationJobResponseTypeDef,
    CreateWorldExportJobRequestRequestTypeDef,
    CreateWorldExportJobResponseTypeDef,
    CreateWorldGenerationJobRequestRequestTypeDef,
    CreateWorldGenerationJobResponseTypeDef,
    CreateWorldTemplateRequestRequestTypeDef,
    CreateWorldTemplateResponseTypeDef,
    DataSourceConfigTypeDef,
    DataSourceTypeDef,
    DeleteFleetRequestRequestTypeDef,
    DeleteRobotApplicationRequestRequestTypeDef,
    DeleteRobotRequestRequestTypeDef,
    DeleteSimulationApplicationRequestRequestTypeDef,
    DeleteWorldTemplateRequestRequestTypeDef,
    DeploymentApplicationConfigTypeDef,
    DeploymentConfigTypeDef,
    DeploymentJobTypeDef,
    DeploymentLaunchConfigTypeDef,
    DeregisterRobotRequestRequestTypeDef,
    DeregisterRobotResponseTypeDef,
    DescribeDeploymentJobRequestRequestTypeDef,
    DescribeDeploymentJobResponseTypeDef,
    DescribeFleetRequestRequestTypeDef,
    DescribeFleetResponseTypeDef,
    DescribeRobotApplicationRequestRequestTypeDef,
    DescribeRobotApplicationResponseTypeDef,
    DescribeRobotRequestRequestTypeDef,
    DescribeRobotResponseTypeDef,
    DescribeSimulationApplicationRequestRequestTypeDef,
    DescribeSimulationApplicationResponseTypeDef,
    DescribeSimulationJobBatchRequestRequestTypeDef,
    DescribeSimulationJobBatchResponseTypeDef,
    DescribeSimulationJobRequestRequestTypeDef,
    DescribeSimulationJobResponseTypeDef,
    DescribeWorldExportJobRequestRequestTypeDef,
    DescribeWorldExportJobResponseTypeDef,
    DescribeWorldGenerationJobRequestRequestTypeDef,
    DescribeWorldGenerationJobResponseTypeDef,
    DescribeWorldRequestRequestTypeDef,
    DescribeWorldResponseTypeDef,
    DescribeWorldTemplateRequestRequestTypeDef,
    DescribeWorldTemplateResponseTypeDef,
    FailedCreateSimulationJobRequestTypeDef,
    FailureSummaryTypeDef,
    FilterTypeDef,
    FinishedWorldsSummaryTypeDef,
    FleetTypeDef,
    GetWorldTemplateBodyRequestRequestTypeDef,
    GetWorldTemplateBodyResponseTypeDef,
    LaunchConfigTypeDef,
    ListDeploymentJobsRequestRequestTypeDef,
    ListDeploymentJobsResponseTypeDef,
    ListFleetsRequestRequestTypeDef,
    ListFleetsResponseTypeDef,
    ListRobotApplicationsRequestRequestTypeDef,
    ListRobotApplicationsResponseTypeDef,
    ListRobotsRequestRequestTypeDef,
    ListRobotsResponseTypeDef,
    ListSimulationApplicationsRequestRequestTypeDef,
    ListSimulationApplicationsResponseTypeDef,
    ListSimulationJobBatchesRequestRequestTypeDef,
    ListSimulationJobBatchesResponseTypeDef,
    ListSimulationJobsRequestRequestTypeDef,
    ListSimulationJobsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWorldExportJobsRequestRequestTypeDef,
    ListWorldExportJobsResponseTypeDef,
    ListWorldGenerationJobsRequestRequestTypeDef,
    ListWorldGenerationJobsResponseTypeDef,
    ListWorldTemplatesRequestRequestTypeDef,
    ListWorldTemplatesResponseTypeDef,
    ListWorldsRequestRequestTypeDef,
    ListWorldsResponseTypeDef,
    LoggingConfigTypeDef,
    NetworkInterfaceTypeDef,
    OutputLocationTypeDef,
    PaginatorConfigTypeDef,
    PortForwardingConfigTypeDef,
    PortMappingTypeDef,
    ProgressDetailTypeDef,
    RegisterRobotRequestRequestTypeDef,
    RegisterRobotResponseTypeDef,
    RenderingEngineTypeDef,
    ResponseMetadataTypeDef,
    RestartSimulationJobRequestRequestTypeDef,
    RobotApplicationConfigTypeDef,
    RobotApplicationSummaryTypeDef,
    RobotDeploymentTypeDef,
    RobotSoftwareSuiteTypeDef,
    RobotTypeDef,
    S3KeyOutputTypeDef,
    S3ObjectTypeDef,
    SimulationApplicationConfigTypeDef,
    SimulationApplicationSummaryTypeDef,
    SimulationJobBatchSummaryTypeDef,
    SimulationJobRequestTypeDef,
    SimulationJobSummaryTypeDef,
    SimulationJobTypeDef,
    SimulationSoftwareSuiteTypeDef,
    SourceConfigTypeDef,
    SourceTypeDef,
    StartSimulationJobBatchRequestRequestTypeDef,
    StartSimulationJobBatchResponseTypeDef,
    SyncDeploymentJobRequestRequestTypeDef,
    SyncDeploymentJobResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TemplateLocationTypeDef,
    TemplateSummaryTypeDef,
    ToolTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateRobotApplicationRequestRequestTypeDef,
    UpdateRobotApplicationResponseTypeDef,
    UpdateSimulationApplicationRequestRequestTypeDef,
    UpdateSimulationApplicationResponseTypeDef,
    UpdateWorldTemplateRequestRequestTypeDef,
    UpdateWorldTemplateResponseTypeDef,
    UploadConfigurationTypeDef,
    VPCConfigResponseTypeDef,
    VPCConfigTypeDef,
    WorldConfigTypeDef,
    WorldCountTypeDef,
    WorldExportJobSummaryTypeDef,
    WorldFailureTypeDef,
    WorldGenerationJobSummaryTypeDef,
    WorldSummaryTypeDef,
)

def get_structure() -> BatchDeleteWorldsRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-robomaker` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-robomaker docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_robomaker/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
