import { ILayoutRestorer } from '@jupyterlab/application';
import { ICommandPalette, WidgetTracker } from '@jupyterlab/apputils';
import { addIcon, clearIcon } from '@jupyterlab/ui-components';
import { LogConsoleWidget } from './logConsoleWidget';
export const logConsole = {
    id: 'jupyterlab-ros/logConsole',
    autoStart: true,
    requires: [ICommandPalette, ILayoutRestorer],
    optional: [],
    activate: (app, palette, restorer) => {
        const { commands } = app;
        let widget = null;
        const tracker = new WidgetTracker({
            namespace: 'roslogconsole'
        });
        restorer.restore(tracker, {
            command: 'jupyterlab-ros/logConsole:open',
            name: () => 'roslogconsole'
        });
        // Creating some buttons for the widget toolbar
        commands.addCommand('jupyterlab-ros/logConsole:checkpoint', {
            execute: () => widget === null || widget === void 0 ? void 0 : widget.checkpoint(),
            icon: addIcon,
            label: 'Add Checkpoint'
        });
        commands.addCommand('jupyterlab-ros/logConsole:clear', {
            execute: () => widget === null || widget === void 0 ? void 0 : widget.clear(),
            icon: clearIcon,
            label: 'Clear Log'
        });
        commands.addCommand('jupyterlab-ros/logConsole:open', {
            label: 'Ros log',
            caption: 'Log console for ROS.',
            isVisible: () => true,
            isEnabled: () => true,
            isToggled: () => widget !== null,
            execute: () => {
                if (widget) {
                    widget.dispose();
                }
                else {
                    widget = new LogConsoleWidget(app);
                    widget.disposed.connect(() => {
                        widget = null;
                        commands.notifyCommandChanged();
                    });
                    app.shell.add(widget, 'main', { mode: 'split-bottom' });
                    tracker.add(widget);
                    widget.update();
                    commands.notifyCommandChanged();
                }
            }
        });
        palette.addItem({ command: 'jupyterlab-ros/logConsole:open', category: 'ROS' });
    }
};
