import { ReactWidget } from '@jupyterlab/apputils';
import { UUID } from '@lumino/coreutils';
import React from 'react';
import { Log, Checkpoint } from './log';
export class LogConsolePanel extends ReactWidget {
    constructor() {
        super();
        this.setLevel = (level) => {
            this.level = level;
            this.update();
        };
        this.setTopic = (topic) => {
            this.topic = topic;
            this.update();
        };
        this.setLogs = (logs) => {
            this.logs = logs;
            this.update();
        };
        this.addClass('jp-LogConsolePanel');
        this.level = 1;
        this.topic = '/all';
        this.logs = [];
    }
    render() {
        const logsLevel = [];
        for (let i = 0; i < this.logs.length; i++) {
            if (this.topic == '/all' || this.logs[i].name == this.topic) {
                if (this.logs[i].level == 0) {
                    logsLevel.push(React.createElement(Checkpoint, { key: UUID.uuid4(), log: this.logs[i] }));
                }
                else if (this.logs[i].level >= this.level) {
                    logsLevel.push(React.createElement(Log, { key: UUID.uuid4(), log: this.logs[i] }));
                }
            }
        }
        return (React.createElement("div", { className: "lm-Widget p-Widget jp-Scrolling lm-StackedPanel-child p-StackedPanel-child" },
            React.createElement("div", { className: "lm-Widget p-Widget jp-OutputArea" }, logsLevel)));
    }
}
