import { ReactWidget } from '@jupyterlab/apputils';
import { HTMLSelect } from '@jupyterlab/ui-components';
import * as React from 'react';
export class LogLevelSwitcher extends ReactWidget {
    constructor(logConsolePanel) {
        super();
        /**
         * Handle `change` events for the HTMLSelect component.
         */
        this.handleChange = (event) => {
            this.level = event.target.value;
            this.logConsolePanel.setLevel(this.level);
            this.update();
        };
        /**
         * Handle `keydown` events for the HTMLSelect component.
         */
        this.handleKeyDown = (event) => {
            if (event.keyCode === 13)
                this.logConsolePanel.activate();
            this.update();
        };
        this.addClass('jp-LogConsole-toolbarLogLevel');
        this.logConsolePanel = logConsolePanel;
        this.level = 1;
    }
    render() {
        return (React.createElement(React.Fragment, null,
            React.createElement("label", null, "Level:"),
            React.createElement(HTMLSelect, { className: "jp-LogConsole-toolbarLogLevelDropdown", onChange: this.handleChange, onKeyDown: this.handleKeyDown, value: this.level, "aria-label": "Log level", options: [
                    { label: "Debug", value: 1 },
                    { label: "Info", value: 2 },
                    { label: "Warning", value: 4 },
                    { label: "Error", value: 8 },
                    { label: "Critical", value: 16 }
                ] })));
    }
}
