import pandas as pd


def parse(_dict, scalar_value=False):
    data = None
    if scalar_value:
        df = pd.DataFrame(_dict, index=[0])
    else:
        df = pd.DataFrame(_dict)
    df = df.rename(columns=_map)
    data = df.to_dict("records")
    return data


_map = {
    "lastModifiedDateTime": "last_modified",
    "startDateTime": "start",
    "endDateTime": "end",
    "organizer": "organizer",
    "displayName": "display_name",
    "businessPhones": "business_phones",
    "mobilePhone": "mobile_phone",
    "surname": "surname",
    "givenName": "given_name",
    "mailNickname": "mail_nickname",
    "userPrincipalName": "user_principal_name",
    "notificationUrl": "notification_url",
    "changeType": "change_type",
    "expirationDateTime": "expiration",
    "resourceData": "resource_data",
    "subscriptionExpirationDateTime": "subscription_expiration",
    "clientState": "client_state",
    "tenantId": "tenant_id",
    "subscriptionId": "subscription_id",
    "organizer.user": "organizer.user",
    "organizer.user.id": "organizer.user.id",
    "organizer.user.displayName": "organizer.user.display_name",
    "organizer.phone": "organizer.phone",
    "organizer.phone.id": "organizer.phone.id",
    "organizer.phone.displayName": "organizer.phone.display_name",
    "organizer.guest": "organizer.guest",
    "organizer.guest.id": "organizer.guest.id",
    "organizer.guest.displayName": "organizer.guest.display_name",
    "organizer.spoolUser": "organizer.splool_user",
    "organizer.acsUser": "organizer.acs_user",
    "organizer.encrypted": "organizer.encrypted",
    "organizer.onPremises": "organizer.on_premises",
    "organizer.acsApplicationInstance": "organizer.acs_appllication_instance",
    "organizer.spoolApplicationInstance": "organizer.spool_application_instance",
    "organizer.applicationInstance": "organizer.application_instance",
    "organizer.application": "organizer.application",
    "organizer.device": "organizer.device",
    "joinWebUrl": "join_web_url",
    "preferredLanguage": "preferred_language",
    "officeLocation": "office_location",
    "jobTitle": "job_title",
    "createdDateTime": "created",
    "isReminderOn": "is_reminder_on",
    "reminderMinutesBeforeStart": "reminder_minutes_before_start",
    "hasAttachments": "has_attachments",
    "webLink": "web_link",
    "start.dateTime": "start",
    "start.timeZone": "start.time_zone",
    "end.dateTime": "end",
    "end.timeZone": "end.time_zone",
    "location.displayName": "location.display_name",
    "location.locationUri": "location.location_uri",
    "location.locationType": "location.location_type",
    "location.uniqueId": "location.unique_id",
    "location.uniqueIdType": "location.unique_id_type",
    "location.address.type": "location.address.type",
    "location.address.street": "location.address.street",
    "location.address.city": "location.address.city",
    "location.address.postalCode": "location.address.postal_code",
    "location.address.countryOrRegion": "location.address.country_or_region",
    "recurrence.pattern.daysOfWeek": "recurrence.pattern.days_of_week",
    "recurrence.pattern.dayOfMonth": "recurrence.pattern.day_of_month",
    "recurrence.pattern.firstDayOfWeek": "recurrence.pattern.first_day_of_week",
    "recurrence.range.recurrenceTimeZone": "recurrence.range.recurrence_time_zone",
    "recurrence.range.numberOfOccurrences": "recurrence.range.number_of_occurrences",
    "recurrence.range.startDate": "recurrence.range.start_date",
    "recurrence.range.endDate": "recurrence.range.end_date",
    "organizer.emailAddress.name": "organizer.email_address.name",
    "organizer.emailAddress.address": "organizer.email_address.address",
    "responseStatus.response": "response_status.response",
    "responseStatus.time": "response_status.time",
    "attendees": "participants",
    "@odata.context": "odata_context",
    "@odata.etag": "odata_etag",
    "applicationId": "application_id",
    "includeResourceData": "include_resource_data",
    "latestSupportedTlsVersion": "latest_supported_tls_version",
    "encryptionCertificate": "encryption_certificate",
    "encryptionCertificateId": "encryption_certificate_id",
    "notificationQueryOptions": "notification_query_options",
    "notificationContentType": "notification_content_type",
    "lifecycleNotificationUrl": "lifecycle_notification_url",
    "creatorId": "creator_id",
    "isDefaultCalendar": "is_default_calendar",
    "hexColor": "hex_color",
    "changeKey": "change_key",
    "canShare": "can_share",
    "canViewPrivateItems": "can_view_private_items",
    "isShared": "is_shared",
    "isSharedWithMe": "is_shared_with_me",
    "canEdit": "can_edit",
    "allowedOnlineMeetingProviders": "allowed_online_meeting_providers",
    "defaultOnlineMeetingProvider": "default_online_meeting_provider",
    "isTallyingResponses": "is_tallying_responses",
    "isRemovable": "is_removable",
    "teamsForBusiness": "teams_for_business",
    "transactionId": "transaction_id",
    "originalStartTimeZone": "original_start_time_zone",
    "originalEndTimeZone": "original_end_time_zone",
    "bodyPreview": "body_preview",
    "isAllDay": "is_all_day",
    "isCancelled": "is_cancelled",
    "isOrganizer": "is_organizer",
    "responseRequested": "response_requested",
    "seriesMasterId": "series_master_id",
    "showAs": "show_as",
    "onlineMeeting": "online_meeting",
    "onlineMeetingUrl": "online_meeting_url",
    "isOnlineMeeting": "is_online_meeting",
    "onlineMeetingProvider": "online_meeting_provider",
    "allowNewTimeProposals": "allow_new_time_proposals",
    "occurrenceId": "occurrence_id",
    "isDraft": "is_draft",
    "hideAttendees": "hide_attendees",
    "responseStatus": "response_status",
    "appId": "app_id",
    "passwordCredentials": "password_credentials",
    "iCalUId": "uid",
    "body.contentType": "body.content_type",
}
