# Generated by Django 4.1.7 on 2023-04-19 05:32

import django.contrib.postgres.fields
import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("directory", "0001_initial"),
        ("wbcrm", "0001_initial_squashed_squashed_0032_productcompanyrelationship_alter_product_prospects_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="Address",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("type", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("street", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("city", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("state", models.CharField(blank=True, default="", max_length=255, null=True)),
                (
                    "country_or_region",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Country/Region"),
                ),
                ("postal_code", models.CharField(blank=True, default="", max_length=255, null=True)),
            ],
            options={
                "verbose_name": "Address",
                "verbose_name_plural": "Addresses",
            },
        ),
        migrations.CreateModel(
            name="RecurrencePattern",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Pattern type"),
                ),
                ("interval", models.IntegerField(blank=True, default=0, null=True)),
                (
                    "month",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(12),
                        ],
                    ),
                ),
                (
                    "day_of_month",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(30),
                        ],
                    ),
                ),
                (
                    "days_of_week",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(default="", max_length=256), blank=True, null=True, size=None
                    ),
                ),
                ("first_day_of_week", models.CharField(blank=True, default="", max_length=255, null=True)),
                (
                    "index",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Pattern index"),
                ),
                ("range_type", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("start_date", models.DateField(blank=True, null=True)),
                ("end_date", models.DateField(blank=True, null=True)),
                ("recurrence_time_zone", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("number_of_occurrences", models.IntegerField(blank=True, default=0, null=True)),
            ],
            options={
                "verbose_name_plural": "Recurrence Patterns",
                "verbose_name": "Recurrence Pattern",
            },
        ),
        migrations.CreateModel(
            name="TenantUser",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "tenant_id",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="User tenant ID"),
                ),
                (
                    "display_name",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Display Name"),
                ),
                ("mail", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("phone", models.CharField(blank=True, default="", max_length=255, null=True)),
                (
                    "tenant_organization_id",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Organization tenant ID"),
                ),
                ("enable_synchronization_activity", models.BooleanField(default=False)),
                ("is_internal_organization", models.BooleanField(blank=True, null=True)),
                (
                    "profile",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="tenant_user",
                        to="directory.person",
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Tenant User",
                "verbose_name_plural": "Tenant Users",
            },
        ),
        migrations.CreateModel(
            name="Location",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("unique_id", models.CharField(blank=True, default="", max_length=255, null=True)),
                ("unique_id_type", models.CharField(blank=True, default="", max_length=255, null=True)),
                (
                    "display_name",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Name"),
                ),
                (
                    "location_uri",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Reply URL"),
                ),
                ("type", models.CharField(blank=True, default="", max_length=255, null=True)),
                (
                    "address",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="wbintegrator_office365.address",
                        verbose_name="Address",
                    ),
                ),
            ],
            options={
                "verbose_name": "Location Meeting",
                "verbose_name_plural": "Location Meetings",
            },
        ),
        migrations.CreateModel(
            name="CallUser",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("acs_user", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("splool_user", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("encrypted", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("on_premises", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("acs_application_instance", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("spool_application_instance", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("application_instance", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("application", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("device", models.CharField(blank=True, default="", max_length=256, null=True)),
                ("is_guest", models.BooleanField(default=False)),
                ("is_phone", models.BooleanField(default=False)),
                (
                    "tenant_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="call_users",
                        to="wbintegrator_office365.tenantuser",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Calendar",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="Last modified")),
                ("is_removable", models.BooleanField(default=False)),
                ("is_default_calendar", models.BooleanField(default=False)),
                (
                    "allowed_online_meeting_providers",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=256), blank=True, null=True, size=None
                    ),
                ),
                ("calendar_id", models.CharField(max_length=1000, unique=True, verbose_name="Calendar Id")),
                ("can_share", models.BooleanField(default=True)),
                ("can_edit", models.BooleanField(default=True)),
                ("can_view_private_items", models.BooleanField(default=True)),
                ("change_key", models.CharField(blank=True, max_length=255, null=True)),
                ("color", models.CharField(blank=True, max_length=255, null=True)),
                ("default_online_meeting_provider", models.CharField(blank=True, max_length=255, null=True)),
                ("hex_color", models.CharField(blank=True, max_length=255, null=True)),
                ("is_tallying_responses", models.BooleanField(default=True)),
                ("name", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "odata_context",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Odata Context"),
                ),
                ("data", models.JSONField(blank=True, default=dict, null=True)),
                ("is_shared", models.BooleanField(default=True)),
                ("is_shared_with_me", models.BooleanField(default=False)),
                ("is_enable", models.BooleanField(default=True)),
                ("outlook_verification", models.BooleanField(default=False)),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="office_calendars",
                        to="directory.person",
                        verbose_name="Owner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Calendar",
                "verbose_name_plural": "Calendars",
            },
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_enable", models.BooleanField(default=True)),
                ("subscription_id", models.CharField(blank=True, max_length=255, null=True)),
                ("change_type", models.CharField(blank=True, max_length=255, null=True)),
                ("notification_url", models.CharField(blank=True, max_length=255, null=True)),
                ("resource", models.CharField(blank=True, max_length=255, null=True)),
                ("expiration_date", models.DateTimeField(blank=True, null=True, verbose_name="Expiration Date")),
                ("application_id", models.CharField(blank=True, max_length=255, null=True)),
                ("creator_id", models.CharField(blank=True, max_length=255, null=True)),
                ("client_state", models.CharField(blank=True, max_length=255, null=True)),
                ("latest_supported_tls_version", models.CharField(blank=True, max_length=255, null=True)),
                ("notification_content_type", models.CharField(blank=True, max_length=255, null=True)),
                ("odata_context", models.CharField(blank=True, max_length=255, null=True)),
                ("encryption_certificate_id", models.CharField(blank=True, max_length=255, null=True)),
                ("encryption_certificate", models.CharField(blank=True, max_length=255, null=True)),
                ("include_resource_data", models.CharField(blank=True, max_length=255, null=True)),
                ("notification_query_options", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "type_resource",
                    models.CharField(
                        choices=[("CALLRECORD", "Call Record"), ("CALENDAR", "Calendar")],
                        default="CALLRECORD",
                        max_length=32,
                        verbose_name="Type of the resource",
                    ),
                ),
                (
                    "tenant_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="subscriptions",
                        to="wbintegrator_office365.tenantuser",
                        verbose_name="Tenant User",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
            ],
            options={
                "verbose_name": "Subscription",
                "verbose_name_plural": "Subscriptions",
            },
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                ("auto_inc_id", models.IntegerField(default=0)),
                ("nb_received", models.IntegerField(default=0)),
                (
                    "uuid_event",
                    models.CharField(
                        blank=True,
                        help_text="UUID obtained from Microsoft",
                        max_length=1000,
                        null=True,
                        unique=True,
                        verbose_name="Event UID",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        blank=True,
                        choices=[("CALLRECORD", "Call Record"), ("CALENDAR", "Calendar")],
                        default="",
                        max_length=32,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "subscription_id",
                    models.CharField(
                        blank=True, default="", max_length=255, null=True, verbose_name="Subscription ID"
                    ),
                ),
                (
                    "change_type",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Change Type"),
                ),
                (
                    "resource",
                    models.CharField(blank=True, default="", max_length=1000, null=True, verbose_name="Resource"),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("data", models.JSONField(blank=True, default=dict, null=True)),
                ("changed", models.DateTimeField(auto_now=True, verbose_name="Changed")),
                (
                    "tenant_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="tenant_events",
                        to="wbintegrator_office365.tenantuser",
                        verbose_name="Tenant User",
                    ),
                ),
                (
                    "id_event",
                    models.CharField(
                        blank=True,
                        help_text="Event ID obtained from Microsoft",
                        max_length=1000,
                        null=True,
                        unique=True,
                        verbose_name="Event ID",
                    ),
                ),
                ("is_handled", models.BooleanField(default=True)),
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
            ],
            options={
                "verbose_name": "Event",
                "verbose_name_plural": "Events",
                "permissions": [("admin_event", "Can administer call and calendar events")],
            },
        ),
        migrations.CreateModel(
            name="CalendarEvent",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "odata_context",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Odata Context"),
                ),
                ("odata_etag", models.CharField(blank=True, max_length=255, null=True, verbose_name="Odata Context")),
                (
                    "created_calendar",
                    models.DateTimeField(blank=True, null=True, verbose_name="Created in the Calendar"),
                ),
                (
                    "last_modified_calendar",
                    models.DateTimeField(blank=True, null=True, verbose_name="Last modified in the Calendar"),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="Last modified")),
                (
                    "categories",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=256), blank=True, null=True, size=None
                    ),
                ),
                ("change_key", models.CharField(blank=True, max_length=255, null=True)),
                ("transaction_id", models.CharField(blank=True, max_length=255, null=True)),
                ("original_start_time_zone", models.CharField(blank=True, max_length=255, null=True)),
                ("original_end_time_zone", models.CharField(blank=True, max_length=255, null=True)),
                ("reminder_minutes_before_start", models.IntegerField(default=15)),
                ("is_reminder_on", models.BooleanField(default=False)),
                ("has_attachments", models.BooleanField(default=False)),
                ("subject", models.CharField(default="(No subject)", max_length=255)),
                ("body_preview", models.TextField(blank=True, default="", null=True)),
                ("importance", models.CharField(blank=True, max_length=255, null=True)),
                ("sensitivity", models.CharField(blank=True, max_length=255, null=True)),
                ("is_all_day", models.BooleanField(default=False)),
                ("is_cancelled", models.BooleanField(default=False)),
                ("is_organizer", models.BooleanField(blank=True, null=True)),
                ("response_requested", models.BooleanField(blank=True, null=True)),
                ("series_master_id", models.CharField(blank=True, max_length=255, null=True)),
                ("show_as", models.CharField(blank=True, max_length=255, null=True)),
                ("type", models.CharField(blank=True, max_length=255, null=True)),
                ("web_link", models.CharField(blank=True, max_length=255, null=True)),
                ("online_meeting_url", models.CharField(blank=True, max_length=255, null=True)),
                ("is_online_meeting", models.BooleanField(blank=True, null=True)),
                ("online_meeting_provider", models.CharField(blank=True, max_length=255, null=True)),
                ("allow_new_time_proposals", models.BooleanField(blank=True, null=True)),
                ("occurrence_id", models.CharField(blank=True, max_length=255, null=True)),
                ("is_draft", models.BooleanField(blank=True, null=True)),
                ("hide_attendees", models.BooleanField(blank=True, null=True)),
                ("response_status", models.CharField(blank=True, max_length=255, null=True)),
                ("body", models.TextField(blank=True, default="", null=True)),
                ("start", models.DateTimeField(blank=True, null=True, verbose_name="Start")),
                ("end", models.DateTimeField(blank=True, null=True, verbose_name="End")),
                (
                    "locations",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(default="", max_length=256), blank=True, null=True, size=None
                    ),
                ),
                ("on_line_meeting", models.CharField(blank=True, max_length=255, null=True)),
                ("data", models.JSONField(blank=True, default=dict, null=True)),
                (
                    "activity",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="calendar",
                        to="wbcrm.activity",
                        verbose_name="Activity",
                    ),
                ),
                (
                    "calendar",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="calendars",
                        to="wbintegrator_office365.calendar",
                        verbose_name="Calendar",
                    ),
                ),
                (
                    "recurrence",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="wbintegrator_office365.recurrencepattern",
                        verbose_name="Recurrence Pattern",
                    ),
                ),
                ("is_enable", models.BooleanField(default=True)),
                ("location", models.CharField(blank=True, max_length=255, null=True)),
                ("outlook_verification", models.BooleanField(default=False)),
                (
                    "invitation_event_ids",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=1000),
                        blank=True,
                        default=list,
                        help_text="list of invitation IDs received by participants",
                        size=None,
                        verbose_name="Invitation Event Ids",
                    ),
                ),
                (
                    "event",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="calendars_events",
                        to="wbintegrator_office365.event",
                        verbose_name="Event",
                    ),
                ),
                (
                    "organizer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="organizer_office_calendar_events",
                        to="directory.person",
                        verbose_name="Organizer",
                    ),
                ),
                (
                    "participants",
                    models.ManyToManyField(
                        blank=True,
                        related_name="calendar_events_attendees",
                        to="directory.person",
                        verbose_name="Participants",
                    ),
                ),
            ],
            options={
                "verbose_name": "Calendar Event",
                "verbose_name_plural": "Calendar Events",
            },
        ),
        migrations.CreateModel(
            name="CallEvent",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "version",
                    models.CharField(blank=True, default="", max_length=256, null=True, verbose_name="Version"),
                ),
                ("type", models.CharField(blank=True, default="", max_length=256, null=True, verbose_name="Type")),
                (
                    "modalities",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=256),
                        blank=True,
                        default=list,
                        null=True,
                        size=None,
                        verbose_name="Modalities",
                    ),
                ),
                ("last_modified", models.DateTimeField(blank=True, null=True, verbose_name="Last Modified")),
                ("start", models.DateTimeField(blank=True, null=True, verbose_name="Start")),
                ("end", models.DateTimeField(blank=True, null=True, verbose_name="End")),
                (
                    "join_web_url",
                    models.CharField(blank=True, default="", max_length=256, null=True, verbose_name="Join Web Url"),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                (
                    "activity",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="call_event",
                        to="wbcrm.activity",
                        verbose_name="Activity",
                    ),
                ),
                (
                    "organizer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="wbintegrator_office365.calluser",
                        verbose_name="Organizer",
                    ),
                ),
                (
                    "participants",
                    models.ManyToManyField(
                        blank=True,
                        related_name="participates",
                        to="wbintegrator_office365.calluser",
                        verbose_name="Call participants",
                    ),
                ),
                ("is_internal_call", models.BooleanField(blank=True, null=True, verbose_name="Is internal call")),
                ("data", models.JSONField(blank=True, default=dict, null=True)),
                (
                    "event",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="calls",
                        to="wbintegrator_office365.event",
                    ),
                ),
            ],
            options={
                "verbose_name": "Call Event",
                "verbose_name_plural": "Calls Events",
            },
        ),
        migrations.CreateModel(
            name="EventLog",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("order_received", models.IntegerField(default=0)),
                (
                    "change_type",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Change Type"),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("changed", models.DateTimeField(auto_now=True, verbose_name="Changed")),
                ("data", models.JSONField(blank=True, default=dict, null=True)),
                ("id_event", models.CharField(blank=True, max_length=1000, null=True, verbose_name="Event ID")),
                (
                    "resource",
                    models.CharField(blank=True, default="", max_length=1000, null=True, verbose_name="Resource"),
                ),
                ("is_handled", models.BooleanField(default=True)),
                (
                    "last_event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="event_logs",
                        to="wbintegrator_office365.event",
                        verbose_name="Last Event",
                    ),
                ),
            ],
            options={
                "verbose_name": "Event Log",
                "verbose_name_plural": "Event Logs",
            },
        ),
        migrations.CreateModel(
            name="CalendarEventInstance",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("instance_id", models.CharField(max_length=1000, unique=True, verbose_name="Calendar Event Id")),
                ("start", models.DateTimeField(blank=True, null=True, verbose_name="Start")),
                ("end", models.DateTimeField(blank=True, null=True, verbose_name="End")),
                ("subject", models.CharField(default="(No subject)", max_length=255)),
                ("body", models.TextField(blank=True, default="", null=True)),
                ("body_preview", models.TextField(blank=True, default="", null=True)),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("last_modified", models.DateTimeField(auto_now=True, verbose_name="Last modified")),
                (
                    "activity",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="calendar_event_instance",
                        to="wbcrm.activity",
                        verbose_name="Activity",
                    ),
                ),
                (
                    "calendar_event",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="instances",
                        to="wbintegrator_office365.calendarevent",
                        verbose_name="Calendar Event",
                    ),
                ),
                (
                    "created_calendar",
                    models.DateTimeField(blank=True, null=True, verbose_name="Created in the Calendar"),
                ),
                ("is_enable", models.BooleanField(default=True)),
                (
                    "last_modified_calendar",
                    models.DateTimeField(blank=True, null=True, verbose_name="Last modified in the Calendar"),
                ),
                (
                    "organizer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="organizer_office_calendar_event_instances",
                        to="directory.person",
                        verbose_name="Organizer",
                    ),
                ),
                (
                    "participants",
                    models.ManyToManyField(
                        blank=True,
                        related_name="calendar_events_instance_attendees",
                        to="directory.person",
                        verbose_name="Participants",
                    ),
                ),
            ],
            options={
                "verbose_name": "Calendar Event Instance",
                "verbose_name_plural": "Calendar Event Instances",
            },
        ),
    ]
