"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const method_1 = require("./method");
const AUTHORIZER_SYMBOL = Symbol.for('@aws-cdk/aws-apigateway.Authorizer');
/**
 * Base class for all custom authorizers
 */
class Authorizer extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.authorizationType = method_1.AuthorizationType.CUSTOM;
        Object.defineProperty(this, AUTHORIZER_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x) {
        return x !== null && typeof (x) === 'object' && AUTHORIZER_SYMBOL in x;
    }
}
exports.Authorizer = Authorizer;
//# sourceMappingURL=data:application/json;base64,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