"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.vpcLinkName ||
                core_1.Lazy.stringValue({ produce: () => this.node.uniqueId }),
        });
        this.targets = new Array();
        const cfnResource = new apigateway_generated_1.CfnVpcLink(this, 'Resource', {
            name: this.physicalName,
            description: props.description,
            targetArns: core_1.Lazy.listValue({ produce: () => this.renderTargets() }),
        });
        this.vpcLinkId = cfnResource.ref;
        if (props.targets) {
            this.addTargets(...props.targets);
        }
    }
    /**
     * Import a VPC Link by its Id
     */
    static fromVpcLinkId(scope, id, vpcLinkId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = vpcLinkId;
            }
        }
        return new Import(scope, id);
    }
    addTargets(...targets) {
        this.targets.push(...targets);
    }
    validate() {
        if (this.targets.length === 0) {
            return ['No targets added to vpc link'];
        }
        return [];
    }
    renderTargets() {
        return this.targets.map(nlb => nlb.loadBalancerArn);
    }
}
exports.VpcLink = VpcLink;
//# sourceMappingURL=data:application/json;base64,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