"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const apigw = require("../lib");
class BookStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const booksHandler = new apigw.LambdaIntegration(new lambda.Function(this, 'BooksHandler', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${echoHandlerCode}`),
        }));
        const bookHandler = new apigw.LambdaIntegration(new lambda.Function(this, 'BookHandler', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${echoHandlerCode}`),
        }));
        const hello = new apigw.LambdaIntegration(new lambda.Function(this, 'Hello', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${helloCode}`),
        }));
        const api = new apigw.RestApi(this, 'books-api');
        api.root.addMethod('ANY', hello);
        const books = api.root.addResource('books', {
            defaultIntegration: booksHandler,
            defaultMethodOptions: { authorizationType: apigw.AuthorizationType.IAM },
        });
        books.addMethod('GET');
        books.addMethod('POST');
        const book = books.addResource('{book_id}', {
            defaultIntegration: bookHandler,
        });
        book.addMethod('GET');
        book.addMethod('DELETE');
    }
}
class BookApp extends cdk.App {
    constructor() {
        super();
        new BookStack(this, 'restapi-books-example');
    }
}
function echoHandlerCode(event, _, callback) {
    return callback(undefined, {
        isBase64Encoded: false,
        statusCode: 200,
        headers: { 'content-type': 'application/json' },
        body: JSON.stringify(event),
    });
}
function helloCode(_event, _context, callback) {
    return callback(undefined, {
        statusCode: 200,
        body: 'hello, world!',
    });
}
new BookApp().synth();
//# sourceMappingURL=data:application/json;base64,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