#    "$Name:  $";
#    "$Header:  $";
# =============================================================================
#
# file :        NXSRecSelector.py
#
# description : Python source for the NXSRecSelector and its commands.
#                The class is derived from Device. It represents the
#                CORBA servant object which will be accessed from the
#                network. All commands which can be executed on the
#                NXSRecSelector are implemented in this file.
#
# project :     TANGO Device Server
#
# $Author:  $
#
# $Revision:  $
#
# $Log:  $
#
# copyleft :    European Synchrotron Radiation Facility
#               BP 220, Grenoble 38043
#               FRANCE
#
# =============================================================================
#          This file is generated by POGO
#    (Program Obviously used to Generate tango Object)
#
#         (c) - Software Engineering Group - ESRF
# =============================================================================
#

""" Selector Server for NeXus Sardana Recorder """

# ==================================================================
# ==================================================================

import PyTango
from .Settings import Settings as STG
from .Utils import Utils


class NXSRecSelector(PyTango.Device_4Impl):

    """ NXSRecSelector server interface

    :brief: Tango Server for Nexus Sardana Recorder Settings.
            Device States Description:
            DevState.ON - Server is ON,
            DevState.RUNNING - Performing a query
    """

    def __init__(self, cl, name):
        """  Device constructor

        :param cl: class name
        :type cl: :obj:`str`
        :param name: device name
        :type name: :obj:`str`
        """
        PyTango.Device_4Impl.__init__(self, cl, name)
        self.debug_stream("In __init__()")
        #: (:class:`nxsrecconfig.Settings.Settings`) \
        #:     Recorder Settings
        self.__stg = None
        #: (:class:`PyTango.DeviceProxy`) self device proxy
        self.__dp = None
        #: (:obj:`list` <:obj:`str`>) \
        #:     memorize attribute to be updated on conf change
        self.__toupdate = ['ConfigDevice', 'Door']
        NXSRecSelector.init_device(self)

    def delete_device(self):
        """ Device destructor
        """
        self.debug_stream("In delete_device()")
        if hasattr(self, 'stg') and self.__stg:
            del self.__stg
            self.__stg = None
        self.set_state(PyTango.DevState.OFF)

    def init_device(self):
        """ Device initialization
        """
        self.debug_stream("In init_device()")
        if hasattr(self, 'stg') and self.__stg:
            del self.__stg
            self.__stg = None
        self.get_device_properties(self.get_device_class())
        numberofthreads = self.NumberOfThreads or None
        defaultpath = self.DefaultNeXusPath or None
        defaultzone = self.DefaultTimeZone or None
        defaultmntgrp = self.DefaultMntGrp or None
        syncsnapshot = bool(self.SyncSnapshot)
        self.__stg = STG(self, numberofthreads, defaultpath,
                         defaultzone, defaultmntgrp, syncsnapshot)
        self.set_state(PyTango.DevState.ON)
        self.__stg.poolBlacklist = self.PoolBlacklist or []
        self.__stg.timerFilters = self.TimerFilters or [
            "*dgg*", "*/timer/*", "*/ctctrl0*"]
        self.__stg.masterTimerFirst = bool(self.MasterTimerFirst)
        self.__stg.mutedChannelFilters = self.MutedChannelFilters \
            or ["*tip551*"]
        self.__stg.adminDataNames = self.AdminDataNames or []
        self.__stg.defaultPreselectedComponents = \
            self.DefaultPreselectedComponents or []
        self.__stg.defaultCanFailDataSources = \
            self.DefaultCanFailDataSources or []
        self.__stg.clientRecordKeys = \
            self.ClientRecordKeys or []

    def always_executed_hook(self):
        """ Always excuted hook method
        """
        self.debug_stream("In always_excuted_hook()")

# ==================================================================
#
#    NXSRecSelector read/write attribute methods
#
# ==================================================================
    def read_attr_hardware(self, _):
        """ Read Attribute Hardware
        """
        self.debug_stream("In read_attr_hardware()")

    def read_Components(self, attr):
        """ Read Components attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_Components()")
        attr.set_value(self.__stg.components)

    def read_DescriptionErrors(self, attr):
        """ Read DescriptionErrors attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_DescriptionErrors()")
        attr.set_value(self.__stg.descriptionErrors)

    def read_Version(self, attr):
        """ Read Version attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_Version()")
        attr.set_value(self.__stg.version)

    def read_MacroServer(self, attr):
        """ Read MacroServer attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_MacroServer()")
        attr.set_value(self.__stg.macroServer)

    def read_Door(self, attr):
        """ Read Door attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_Door()")
        attr.set_value(self.__stg.door)

    def write_Door(self, attr):
        """ Write Door attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_Door()")
        self.__stg.door = attr.get_write_value()

    def read_StepDataSources(self, attr):
        """ Read StepDataSources attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_StepDataSources()")
        attr.set_value(self.__stg.stepdatasources or "")

    def write_StepDataSources(self, attr):
        """ Write StepDataSources attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_StepDataSources()")
        if self.is_StepDataSources_write_allowed():
            self.__stg.stepdatasources = attr.get_write_value() or ""
        else:
            self.warn_stream("To change the settings please close the server.")
            raise Exception(
                "To change the settings please close the server.")

    def is_StepDataSources_write_allowed(self):
        """ StepDataSources attribute Write State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def read_CanFailDataSources(self, attr):
        """ Read CanFailDataSources attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_CanFailDataSources()")
        attr.set_value(self.__stg.canfaildatasources or "")

    def write_CanFailDataSources(self, attr):
        """ Write CanFailDataSources attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_CanFailDataSources()")
        if self.is_CanFailDataSources_write_allowed():
            self.__stg.canfaildatasources = attr.get_write_value() or ""
        else:
            self.warn_stream("To change the settings please close the server.")
            raise Exception(
                "To change the settings please close the server.")

    def is_CanFailDataSources_write_allowed(self):
        """ CanFailDataSources attribute Write State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def read_LinkDataSources(self, attr):
        """ Read LinkDataSources attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_LinkDataSources()")
        attr.set_value(self.__stg.linkdatasources or "")

    def write_LinkDataSources(self, attr):
        """ Write LinkDataSources attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_LinkDataSources()")
        if self.is_LinkDataSources_write_allowed():
            self.__stg.linkdatasources = attr.get_write_value() or ""
        else:
            self.warn_stream("To change the settings please close the server.")
            raise Exception(
                "To change the settings please close the server.")

    def is_LinkDataSources_write_allowed(self):
        """ LinkDataSources attribute Write State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def read_ConfigDevice(self, attr):
        """ Read ConfigDevice attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_ConfigDevice()")
        attr.set_value(self.__stg.configDevice)

    def write_ConfigDevice(self, attr):
        """ Write ConfigDevice attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ConfigDevice()")
        self.__stg.configDevice = attr.get_write_value()

    def read_MntGrp(self, attr):
        """ Read MntGrp attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_MntGrp()")
        attr.set_value(self.__stg.mntGrp)

    def write_MntGrp(self, attr):
        """ Write MntGrp attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_MntGrp()")
        self.__stg.mntGrp = attr.get_write_value()

    def read_ScanDir(self, attr):
        """ Read ScanDir attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_ScanDir()")
        attr.set_value(self.__stg.scanDir)

    def write_ScanDir(self, attr):
        """ Write ScanDir attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ScanDir()")
        self.__stg.scanDir = attr.get_write_value()

    def read_ScanFile(self, attr):
        """ Read ScanFile attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_ScanFile()")
        attr.set_value(self.__stg.scanFile or "")

    def write_ScanFile(self, attr):
        """ Write ScanFile attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ScanFile()")
        self.__stg.scanFile = attr.get_write_value() or ""

    def read_ScanID(self, attr):
        """ Read ScanID attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_ScanID()")
        attr.set_value(self.__stg.scanID)

    def write_ScanID(self, attr):
        """ Write ScanID attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ScanID()")
        self.__stg.scanID = attr.get_write_value()

    def read_WriterDevice(self, attr):
        """ Read WriterDevice attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_WriterDevice()")
        attr.set_value(self.__stg.writerDevice)

    def write_WriterDevice(self, attr):
        """ Write WriterDevice attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_WriterDevice()")
        self.__stg.writerDevice = attr.get_write_value()

    def read_DeviceGroups(self, attr):
        """ Read DeviceGroups attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_DeviceGroups()")
        attr.set_value(self.__stg.deviceGroups)

    def write_DeviceGroups(self, attr):
        """ Write DeviceGroups attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_DeviceGroups()")
        self.__stg.deviceGroups = attr.get_write_value()

    def read_UserData(self, attr):
        """ Read UserData attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_UserData()")
        attr.set_value(self.__stg.userData)

    def write_UserData(self, attr):
        """ Write UserData attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_UserData()")
        self.__stg.userData = attr.get_write_value()

    def read_DataSources(self, attr):
        """ Read DataSources attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_DataSources()")
        attr.set_value(self.__stg.dataSources)

    def read_ProfileConfiguration(self, attr):
        """ Read ProfileConfiguration attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_DataSources()")
        attr.set_value(self.__stg.profileConfiguration)

    def write_ProfileConfiguration(self, attr):
        """ Write ProfileConfiguration attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ProfileConfiguration()")
        self.__stg.profileConfiguration = attr.get_write_value()
        try:
            self.__dp = self.__dp or PyTango.DeviceProxy(
                Utils.tostr(self.get_name()))
            for var in self.__toupdate:
                if var in self.__stg.names():
                    if hasattr(self.__dp, var):
                        self.__dp.write_attribute(
                            Utils.tostr(var), self.__stg.value(var))

            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def read_AppendEntry(self, attr):
        """ Read AppendEntry attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_AppendEntry()")
        attr.set_value(self.__stg.appendEntry)

    def write_AppendEntry(self, attr):
        """ Write AppendEntry attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_AppendEntry()")
        self.__stg.appendEntry = attr.get_write_value()

    def read_ConfigVariables(self, attr):
        """ Read ConfigVariables attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_ConfigVariables()")
        attr.set_value(self.__stg.configVariables)

    def write_ConfigVariables(self, attr):
        """ Write ConfigVariables attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ConfigVariables()")
        self.__stg.configVariables = attr.get_write_value()

    def read_ProfileFile(self, attr):
        """ Read ProfileFile attribute

        :param attr: read attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In read_ProfileFile()")
        attr.set_value(self.__stg.profileFile)

    def write_ProfileFile(self, attr):
        """ Write ProfileFile attribute

        :param attr: written attribute
        :type attr: :class:`PyTango.Attribute`
        """
        self.debug_stream("In write_ProfileFile()")
        self.__stg.profileFile = attr.get_write_value()

    # ==================================================================
    #
    #    NXSRecSelector command methods
    #
    # ==================================================================

    def LoadProfile(self):
        """ LoadProfile command

        :brief: Load server configuration
        """
        self.debug_stream("In LoadProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.loadProfile()

            # updating memorized attributes
            self.__dp = self.__dp or PyTango.DeviceProxy(
                Utils.tostr(self.get_name()))
            for var in self.__toupdate:
                if var in self.__stg.names():
                    if hasattr(self.__dp, var):
                        self.__dp.write_attribute(
                            Utils.tostr(var), self.__stg.value(var))

            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_LoadProfile_allowed(self):
        """ LoadProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def FetchProfile(self):
        """ FetchProfile command

        :brief: Fetch server configuration
        """
        self.debug_stream("In FetchProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.fetchProfile()

            # updating memorized attributes
            self.__dp = self.__dp or PyTango.DeviceProxy(
                Utils.tostr(self.get_name()))
            for var in self.__toupdate:
                if var in self.__stg.names():
                    if hasattr(self.__dp, var):
                        self.__dp.write_attribute(
                            Utils.tostr(var), self.__stg.value(var))

            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_FetchProfile_allowed(self):
        """ FetchProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def SaveProfile(self):
        """ SaveProfile command

        :brief: Save server configuration
        """
        self.debug_stream("In SaveProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.saveProfile()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_SaveProfile_allowed(self):
        """ SaveProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def StoreProfile(self):
        """ StoreProfile command command

        :brief: Store server configuration
        """
        self.debug_stream("In StoreProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.storeProfile()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_StoreProfile_allowed(self):
        """ StoreProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def PreselectComponents(self):
        """ PreselectComponents command

        :brief: Check existing devices of pools
        """
        self.debug_stream("In PreselectComponents()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.preselectComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_PreselectComponents_allowed(self):
        """ PreselectComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ResetPreselectedComponents(self):
        """  ResetPreselectedComponents command

        :brief: reset PreselectedComponents
                to DefaultPreselectedComponents
        """
        self.debug_stream("In ResetPreselectedComponents()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.resetPreselectedComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_ResetPreselectedComponents_allowed(self):
        """ ResetPreselectedComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def DeleteAllProfiles(self):
        """ DeleteAllProfiles command

        :brief: Delete all profiles from Configuration Server
        """
        self.debug_stream("In DeleteAllProfiles()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.deleteAllProfiles()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_DeleteAllProfiles_allowed(self):
        """ DeleteAllProfiles command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def UpdateConfigVariables(self):
        """ UpdateConfigVariables command

       :brief: Send ConfigVariables into ConfigServer
            and update serialno if appendEntry selected
        """
        self.debug_stream("In UpdateConfigVariables()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.updateConfigVariables()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_UpdateConfigVariables_allowed(self):
        """ UpdateConfigVariables command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def IsMntGrpUpdated(self):
        """ IsMntGrpUpdated command

        :returns: True if mntgrp was changed
        :rtype: :obj:`bool`
        """
        self.debug_stream("In IsMntGrpUpdated()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            conf = bool(self.__stg.isMntGrpUpdated())
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return conf

    def is_IsMntGrpUpdated_allowed(self):
        """ IsMntGrpUpdated command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def MntGrpConfiguration(self):
        """ MntGrpConfiguration command

        :brief:  returns mntgrp configuration

        :returns: Provide mntgrp configuration in json string
        :rtype: :obj:`str`
        """
        self.debug_stream("In MntGrpConfiguration()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            conf = Utils.tostr(self.__stg.mntGrpConfiguration())
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return conf

    def is_MntGrpConfiguration_allowed(self):
        """ MntGrpConfiguration command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def UpdateProfile(self):
        """ UpdateProfile command

        :brief: Update mntgrp configuration
        :returns: JSON string with mntgrp configuration info
        :rtype: :obj:`str`
        """
        self.debug_stream("In UpdateProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            conf = Utils.tostr(self.__stg.updateProfile())
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return conf

    def is_UpdateProfile_allowed(self):
        """ UpdateProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def UpdateMntGrp(self):
        """ UpdateMntGrp command

        :brief: Update mntgrp configuration
        :returns: mntgrp configuration string
        :rtype: :obj:`str`
        """
        self.debug_stream("In UpdateMntGrp()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            conf = Utils.tostr(self.__stg.updateMntGrp())
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return conf

    def is_UpdateMntGrp_allowed(self):
        """ UpdateMntGrp command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def SwitchProfile(self):
        """ SwitchProfile command

        :brief: Switch mntgrp configuration
        """
        self.debug_stream("In SwitchProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.switchProfile()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_SwitchProfile_allowed(self):
        """ SwitchProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ImportMntGrp(self):
        """ ImportMntGrp command

        :brief: Import active mntgrp configuration
        """
        self.debug_stream("In ImportMntGrp()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.importMntGrp()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_ImportMntGrp_allowed(self):
        """ ImportMntGrp command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ImportEnvProfile(self):
        """  ImportEnvProfile command

        :brief: Import all environment variables
        """
        self.debug_stream("In ImportEnvProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.importEnvProfile()

            # updating memorized attributes
            self.__dp = self.__dp or PyTango.DeviceProxy(
                Utils.tostr(self.get_name()))
            for var in self.__toupdate:
                if var in self.__stg.names():
                    if hasattr(self.__dp, var):
                        self.__dp.write_attribute(
                            Utils.tostr(var), self.__stg.value(var))

            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_ImportEnv_allowed(self):
        """ ImportMntGrp command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ExportEnvProfile(self):
        """ ExportEnvProfile command

        :brief: Export all environment variables
        """
        self.debug_stream("In ExportEnvProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.exportEnvProfile()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_ExportEnv_allowed(self):
        """ ExportMntGrp command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def AvailableTimers(self):
        """ AvailableTimers command

        :brief: Returns a list of available component names

        :returns: DevVarStringArray    list of available component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In AvailableTimers()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.availableTimers()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_AvailableTimers_allowed(self):
        """ AvailableTimers command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def MutedChannels(self):
        """  MutedChannels command

        :brief: Return a list of muted channel names
        :returns: DevVarStringArray    list of muted channel names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In MutedChannels()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.mutedChannels()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_MutedChannels_allowed(self):
        """ MutedChannels command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def AvailableComponents(self):
        """ AvailableComponents command

        :brief: Return a list of available component names
        :returns: DevVarStringArray    list of available component names
        :rtype: :obj:`list` <:obj:`str`>

        """
        self.debug_stream("In AvailableComponents()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.availableComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_AvailableComponents_allowed(self):
        """ AvailableComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ComponentDescription(self):
        """ ComponentDescription command

        :brief: Return a list of available component names
        :returns: DevString   list of available component names
        :rtype: :obj:`str`
        """
        self.debug_stream("In ComponentDescription()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.componentDescription()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_ComponentDescription_allowed(self):
        """ ComponentDescription command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def SetScanEnvVariables(self, argin):
        """ SetScanEnvVariables command

        :brief: Store ScanDir, ScanFile and NeXusSelectorDevice
                      in environment variables
        :param argin: json dictionary with environment data
        :type argin: :obj:`str`
        :returns: DevLong    scan ID
        :rtype: :obj:`int`
        """
        self.debug_stream("In SetScanEnvVariables()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = int(self.__stg.setScanEnvVariables(argin))
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_SetScanEnvVariables_allowed(self):
        """ SetScanEnvVariables command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def FullDeviceNames(self):
        """ FullDeviceNames command

        :brief: Return a JSON with full device names for all aliases
        :returns: DevString JSON dictionary with full device names
        :rtype: :obj:`str`
        """
        self.debug_stream("In FullDeviceNames()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.fullDeviceNames()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_FullDeviceNames_allowed(self):
        """ FullDeviceNames command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ScanEnvVariables(self):
        """ ScanEnvVariables command

        :brief: Fetch ScanDir, ScanFile, ScanID and NeXusSelectorDevice
                      in environment variables
        :returns: DevString    json dictionary with environment data
        :rtype: :obj:`str`
        """

        self.debug_stream("In ScanEnvVariables()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = Utils.tostr(self.__stg.scanEnvVariables())
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_ScanEnvVariables_allowed(self):
        """ ScanEnvVariables command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def VariableComponents(self):
        """ VariableComponents command

        :brief: Returns a list of available component names
        :returns: DevString    list of available component names
        :rtype: :obj:`str`
        """
        self.debug_stream("In VariableComponents()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.variableComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_VariableComponents_allowed(self):
        """ VariableComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def AvailableProfiles(self):
        """ AvailableProfiles command

        :brief: Return a list of available selection names
        :returns: DevVarStringArray    list of available selection names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In AvailableProfiles()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.availableProfiles()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_AvailableProfiles_allowed(self):
        """ AvailableProfiles command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def AvailableMntGrps(self):
        """ AvailableMntGrps command

        :brief: Return a list of available mntgrp names
        :returns: DevVarStringArray    list of available mntgrp names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In AvailableMntGrps()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.availableMntGrps()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_AvailableMntGrps_allowed(self):
        """ AvailableMntGrps command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def AvailableDataSources(self):
        """ AvailableDataSources command

        :brief: Return a list of available DataSource names
        :returns: DevVarStringArray    list of available DataSource names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In AvailableDataSources()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.availableDataSources()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_AvailableDataSources_allowed(self):
        """ AvailableDataSources command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def PoolElementNames(self, argin):
        """ PoolElementNames command

        :brief: Return a list of available pool channels

        :param argin:  DevString            name of pool list attribute
        :type argin:  :obj:`str`
        :returns: DevVarStringArray    list of available pool elements
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In PoolElementNames()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.poolElementNames(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_PoolElementNames_allowed(self):
        """ PoolElementNames command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ComponentDataSources(self):
        """ ComponentDataSources command

        :brief: Provide the component datasources
        :returns: DevVarStringArray    component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In ComponentDataSources()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.componentDataSources()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_ComponentDataSources_allowed(self):
        """ ComponentDataSources command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def SelectedDataSources(self):
        """ SelectedDataSources command

        :brief: Provide the selected datasources
        :returns: DevVarStringArray    component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In SelectedDataSources()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.selectedDataSources()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_SelectedDataSources_allowed(self):
        """ SelectedDataSources command State Machine
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def AdministratorDataNames(self):
        """ AdministratorDataNames command

        :brief: Provide Administrator Data Names
        :returns: DevVarStringArray    data record names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In AdministratorDataNames()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.administratorDataNames()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_AdministratorDataNames_allowed(self):
        """ AdministratorDataNames command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def MandatoryComponents(self):
        """ MandatoryComponents command

        :brief: Set the mandatory components
        :returns: DevVarStringArray    component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In MandatoryComponents()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.mandatoryComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_MandatoryComponents_allowed(self):
        """ MandatoryComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def SelectedComponents(self):
        """ SelectedComponents command

        :brief: Provide the selected components
        :returns: DevVarStringArray    component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In SelectedComponents()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.selectedComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_SelectedComponents_allowed(self):
        """ SelectedComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def PreselectedComponents(self):
        """ PreselectedComponents command

        :brief: Provide the preselected components
        :returns: DevVarStringArray    component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In PreselectedComponents()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.preselectedComponents()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_PreselectedComponents_allowed(self):
        """ PreselectedComponents command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def PreselectedDataSources(self):
        """ PreselectedDataSources command

        :brief: Provide the preselected components
        :returns: DevVarStringArray    component names
        :rtype: :obj:`list` <:obj:`str`>
        """
        self.debug_stream("In PreselectedDataSources()")

        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.preselectedDataSources()
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)
        return argout

    def is_PreselectedDataSources_allowed(self):
        """ PreselectedDataSources command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def CreateDynamicComponent(self, argin):
        """ CreateDynamicComponent command

        :brief: Create dynamic component
        :param argin:  DevVarStringArray    list of datasource parameters
        :type argin: :obj:`list` <:obj:`str`>
        :returns: DevVarString         name of created dynamic component
        :rtype: :obj:`str`
        """
        self.debug_stream("In CreateDynamicComponent()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.createDynamicComponent(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_CreateDynamicComponent_allowed(self):
        """ CreateDynamicComponent command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def RemoveDynamicComponent(self, argin):
        """ RemoveDynamicComponent command

        :brief: Delete the given dynamic component
        :param argin:  DevString  dynamic component name
        :type argin: :obj:`str`
        """
        self.debug_stream("In RemoveDynamicComponent()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.removeDynamicComponent(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_RemoveDynamicComponent_allowed(self):
        """ RemoveDynamicComponent command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def DeleteProfile(self, argin):
        """ DeleteProfile command

        :brief: Delete the given mntgrp
        :param argin:  DevString  measurement group name
        :type argin: :obj:`str`
        """
        self.debug_stream("In DeleteProfile()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            self.__stg.deleteProfile(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

    def is_DeleteProfile_allowed(self):
        """ DeleteProfile command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ChannelProperties(self, argin):
        """ ChannelProperties command

        :brief: Provide JSON dictionary with channel properties
                      {channel:property}
        :param argin:  DevString    property type
        :type argin: :obj:`str`
        :returns: DevString    JSON dictionary with channel properties
        :rtype: :obj:`str`

        """
        self.debug_stream("In ChannelProperties()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.channelProperties(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_ChannelProperties_allowed(self):
        """ ChannelProperties command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def SetChannelProperties(self, argin):
        """ SetChannelProperties command SetChannelProperties

        :brief: Set Channel Properties of the given type
        :param argin: DevVarStringArray two element list with a property type
                      and JSON value dictionary {channel:property}
        :type argin: [:obj:`str`, :obj:`str`]

        """
        self.debug_stream("In SetChannelProperties()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.setChannelProperties(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_SetChannelProperties_allowed(self):
        """ SetChannelProperties command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ComponentClientSources(self, argin):
        """ ComponentClientSources command

        :brief: Describe client datasources from components
        :param argin:  DevVarStringArray    list of component names
        :type argin: :obj:`list` <:obj:`str`>
        :returns: DevVarString         description of component datasources
        :rtype: :obj:`str`
        """
        self.debug_stream("In ComponentClientSources()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.componentClientSources(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_ComponentClientSources_allowed(self):
        """ ComponentClientSources command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def ComponentSources(self, argin):
        """ ComponentSources command

        :brief: Describe datasources from components
        :param argin:  DevVarStringArray    list of component names
        :type argin: :obj:`list` <:obj:`str`>
        :returns: DevVarString         description of component datasources
        :rtype: :obj:`str`
        """
        self.debug_stream("In ComponentSources()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.componentSources(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_ComponentSources_allowed(self):
        """ ComponentSources command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def DataSourceDescription(self, argin):
        """ DataSourceDescription command

        :brief: Provide datasource description
        :param argin:  DevVarStringArray    list of datasource names
        :type argin: :obj:`list` <:obj:`str`>
        :returns: DevVarStringArray    description of datasources
        :rtypes: :obj:`list` <:obj:`str`>

        """
        self.debug_stream("In DataSourceDescription()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.dataSourceDescription(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def AddStepDataSources(self, argin):
        """ AddStepDataSources command

        :brief: switch datasources to step mode
        :param argin:  DevVarStringArray    list of datasource names
        :type argin: :obj:`list` <:obj:`str`>
        :returns: DevVarStringArray list of datasources not found in components
        :rtypes: :obj:`list` <:obj:`str`>

        """
        self.debug_stream("In AddStepDataSources()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.addStepDataSources(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_DataSourceDescription_allowed(self):
        """ DataSourceDescription command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def CreateWriterConfiguration(self, argin):
        """ CreateWriterConfiguration command

        :brief: Create configuration from the given components

        :param argin:  DevVarStringArray    list of component names
        :type argin: :obj:`list` <:obj:`str`>
        :returns: DevVarString         XML configuration string
        :rtype: :obj:`str`
        """
        self.debug_stream("In CreateWriterConfiguration()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.createWriterConfiguration(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_CreateWriterConfiguration_allowed(self):
        """ CreateWriterConfiguration command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        if self.get_state() in [PyTango.DevState.RUNNING]:
            return False
        return True

    def CreateDataSources(self, argin):
        """ It creates new DataSources on the ConfigServer

        :param argin: JSON dictionary with {``dsname``: ``tangosource``, ...}
        :type argin: :obj:`str`
        """
        self.debug_stream("In createDataSources()")
        try:
            self.set_state(PyTango.DevState.RUNNING)
            argout = self.__stg.createDataSources(argin)
            self.set_state(PyTango.DevState.ON)
        finally:
            if self.get_state() == PyTango.DevState.RUNNING:
                self.set_state(PyTango.DevState.ON)

        return argout

    def is_CreateDataSources_allowed(self):
        """ CreateDataSources command State Machine

        :returns: True if the operation allowed
        :rtype: :obj:`bool`
        """
        state_ok = not(self.get_state() in [PyTango.DevState.RUNNING])
        return state_ok


# ==================================================================
#
#    NXSRecSelectorClass class definition
#
# ==================================================================
class NXSRecSelectorClass(PyTango.DeviceClass):

    #: (:obj:`dict` <:obj:`str`, \
    #:       [ :obj:`str`, :class:`PyTango.CmdArgType`, \
    #:       [ :obj:`list` <:obj:`int`> ] ] > ) Class Properties
    class_property_list = {
    }

    #: (:obj:`dict` <:obj:`str`, \
    #:       [ :obj:`str`, :class:`PyTango.CmdArgType`, \
    #:       [ :obj:`list` <:obj:`int`> ] ] > ) Device Properties
    device_property_list = {
        'NumberOfThreads':
        [PyTango.DevLong,
         "maximal number of threads",
         [20]],
        'DefaultNeXusPath':
        [PyTango.DevString,
         "default NeXus path",
         ["/$var.entryname#'scan'$var.serialno:NXentry/"
          "NXinstrument/collection"]],
        'DefaultTimeZone':
        [PyTango.DevString,
         "default Time Zone",
         ["Europe/Berlin"]],
        'DefaultMntGrp':
        [PyTango.DevString,
         "default measurement group name",
         ["nxsmntgrp"]],
        'PoolBlacklist':
        [PyTango.DevVarStringArray,
         "blacklist of pools",
         []],
        'TimerFilters':
        [PyTango.DevVarStringArray,
         "list of timer device name filters",
         []],
        'MutedChannelFilters':
        [PyTango.DevVarStringArray,
         "list of muted channel filters",
         []],
        'AdminDataNames':
        [PyTango.DevVarStringArray,
         "list of administrator data names",
         []],
        'DefaultPreselectedComponents':
        [PyTango.DevVarStringArray,
         "list of default preselected components",
         []],
        'ClientRecordKeys':
        [PyTango.DevVarStringArray,
         "list of record keys for CLIENT datasources",
         []],
        'SyncSnapshot':
        [PyTango.DevBoolean,
         "preselection merges the current ScanSnapshot",
         [False]],
        'MasterTimerFirst':
        [PyTango.DevBoolean,
         "the master timer channel of MG with the index: 0",
         [False]],
        'DefaultCanFailDataSources':
        [PyTango.DevVarStringArray,
         "list of default datasources in the CanFail mode",
         []],
    }

    #: (:obj:`dict` <:obj:`str`, \
    #:       [[ :class:`PyTango.CmdArgType`, :obj:`str`]] >)
    #:       Command definitions
    cmd_list = {
        'SetScanEnvVariables':
            [[PyTango.DevString, "environment data"],
             [PyTango.DevLong, "scanID"]],
        'ScanEnvVariables':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString, "environment data"]],
        'LoadProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'SaveProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'FetchProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'StoreProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'DeleteProfile':
            [[PyTango.DevString, "mntgrp name"],
             [PyTango.DevVoid, ""]],
        'ImportMntGrp':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'ImportEnvProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'ExportEnvProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'UpdateMntGrp':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString, "configuration"]],
        'UpdateProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString, "mntgrp configuration string"]],
        'SwitchProfile':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'MntGrpConfiguration':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString, "mntgrp configuration string"]],
        'IsMntGrpUpdated':
            [[PyTango.DevVoid, ""],
             [PyTango.DevBoolean, "true if mntgrp changed"]],
        'PreselectComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'ResetPreselectedComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'DeleteAllProfiles':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'UpdateConfigVariables':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVoid, ""]],
        'AvailableComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray,
              "list of available component names"]],
        'AvailableProfiles':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray,
              "list of available selection names"]],
        'AvailableMntGrps':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray,
              "list of available mntgrp names"]],
        'AvailableDataSources':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray,
              "list of available DataSource names"]],
        'AvailableTimers':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray,
              "list of available timers"]],
        'MutedChannels':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray,
              "list of muted channels"]],
        'ComponentDescription':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString,
              "JSON component description"]],
        'VariableComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString,
              "JSON Dictionary with all Components for "
                 + "  configuration variable"]],
        'FullDeviceNames':
            [[PyTango.DevVoid, ""],
             [PyTango.DevString,
              "JSON Dictionary with full device names for "
                 + " all aliases "]],
        'ComponentDataSources':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "profile component datasources"]],
        'SelectedDataSources':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "profile datasources"]],
        'AdministratorDataNames':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "administrator data names"]],
        'PoolElementNames':
            [[PyTango.DevString, "pool list attribute name"],
             [PyTango.DevVarStringArray, "list of available pool elements"]],
        'MandatoryComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "component names"]],
        'SelectedComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "component names"]],
        'PreselectedComponents':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "component names"]],
        'PreselectedDataSources':
            [[PyTango.DevVoid, ""],
             [PyTango.DevVarStringArray, "datasources names"]],
        'CreateDynamicComponent':
            [[PyTango.DevVarStringArray,
              "list of JSON strings with datasource parameters"],
             [PyTango.DevString, "name of dynamic Component"]],
        'DataSourceDescription':
            [[PyTango.DevVarStringArray, "list of required datasources"],
             [PyTango.DevVarStringArray,
              "list of JSON with description of CLIENT Datasources"]],
        'AddStepDataSources':
            [[PyTango.DevVarStringArray, "list of required datasources"],
             [PyTango.DevVarStringArray,
              "list of datasources not found in components"]],
        'ComponentClientSources':
            [[PyTango.DevVarStringArray, "list of component "
              "client datasources"],
             [PyTango.DevString,
              "JSON with description of component CLIENT Datasources"]],
        'ComponentSources':
            [[PyTango.DevVarStringArray, "list of components"],
             [PyTango.DevString,
              "JSON with description of component Datasources"]],
        'ChannelProperties':
            [[PyTango.DevString, "property type"],
             [PyTango.DevString,
              "JSON dictionary with channel properties {channel:property}"]],
        'SetChannelProperties':
            [[PyTango.DevVarStringArray,
              "a two element list with a property type and "
              "JSON value dictionary {channel:property}"],
             [PyTango.DevVoid, ""]],
        'CreateWriterConfiguration':
            [[PyTango.DevVarStringArray, "list of required components"],
             [PyTango.DevString,
              "XML Settinges"]],
        'RemoveDynamicComponent':
            [[PyTango.DevString, "name of dynamic Component"],
             [PyTango.DevVoid, ""]],
        'CreateDataSources':
            [[PyTango.DevString,
              "JSON dictionary with {``dsname``: ``tangosource``, ...}"],
             [PyTango.DevVoid, ""]],
    }

    #: (:obj:`dict` <:obj:`str`, \
    #       [[ :class:`PyTango.CmdArgType`, \
    #          :class:`PyTango.AttrDataFormat`, \
    #          :class:`PyTango.AttrWriteType` ], \
    #          :obj:`dict` <:obj:`str` , any> ] > ) Attribute definitions
    attr_list = {
        'Components':
            [[PyTango.DevString,
              PyTango.SPECTRUM,
              PyTango.READ, 10000],
             {
                 'label': "Selected Components",
                 'description': "list of Selected Components",
            }],
        'StepDataSources':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "list of datasources to be switch into step mode",
                 'description': "list of datasources to be switched" +
                 " into step mode",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'CanFailDataSources':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "list of datasources to be switch into canfail mode",
                 'description': "list of datasources to be switched" +
                 " into canfail mode",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'LinkDataSources':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "list of datasources to which a link will be added",
                 'description': "list of datasources to which "
                 "a link will be added",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'DescriptionErrors':
            [[PyTango.DevString,
              PyTango.SPECTRUM,
              PyTango.READ, 10000],
             {
                 'label': "Descriptive Component Errors",
                 'description': "list of Descriptive Component Errors",
            }],
        'Version':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ],
             {
                 'label': "Version",
                 'description': "server version",
            }],
        'MacroServer':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ],
             {
                 'label': "MacroServer",
                 'description': "Macro Server device name",
            }],
        'MntGrp':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': " Measurement Group",
                 'description': " Measurement Group name",
            }],
        'ScanDir':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Scan Directory",
                 'description': "Scan Directory",
            }],
        'ScanID':
            [[PyTango.DevLong,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Scan ID",
                 'description': "Scan ID",
            }],
        'ScanFile':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Scan File(s)",
                 'description': "Scan File(s)",
            }],
        'ConfigDevice':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Configuration Device",
                 'description': "Configuration device name",
                 'Memorized': "true",
            }],
        'Door':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Door",
                 'description': "Door device name",
                 'Memorized': "true",
            }],
        'WriterDevice':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Writer Device",
                 'description': "Writer device device name",
            }],
        'UserData':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Client Data",
                 'description': "JSON dictionary with User Data",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'DeviceGroups':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Device groups",
                 'description': "JSON dictionary with device groups",
                 'Memorized': "true",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'DataSources':
            [[PyTango.DevString,
              PyTango.SPECTRUM,
              PyTango.READ, 10000],
             {
                 'label': "Selected Datasources",
                 'description': "list of Selected Datasources",
            }],
        'ProfileConfiguration':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Profile Configuration",
                 'description': "JSON dict of server configuration",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'AppendEntry':
            [[PyTango.DevBoolean,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Append Entry",
                 'description': "flag for entry appending",
            }],
        'ConfigVariables':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Configuration Variables",
                'description': "JSON dictionary with configuration variables"
                 + "for templated components",
                 'Display level': PyTango.DispLevel.EXPERT,
            }],
        'ProfileFile':
            [[PyTango.DevString,
              PyTango.SCALAR,
              PyTango.READ_WRITE],
             {
                 'label': "Profile File with its Path",
                 'description': "config file with its full path",
                 'Memorized': "true",
            }],
    }

    def __init__(self, name):
        """ NXSRecSelectorclass Constructor
        """
        PyTango.DeviceClass.__init__(self, name)
        self.set_type(name)
        print("In NXSRecSelectorClass constructor")


# ==================================================================
#
#    NXSRecSelector class main method
#
# ==================================================================
if __name__ == '__main__':
    pass
