# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['poethepoet',
 'poethepoet.completion',
 'poethepoet.executor',
 'poethepoet.task']

package_data = \
{'': ['*']}

install_requires = \
['pastel>=0.2.0,<0.3.0', 'tomlkit>=0.6.0,<1.0.0']

entry_points = \
{'console_scripts': ['poe = poethepoet:main']}

setup_kwargs = {
    'name': 'poethepoet',
    'version': '0.9.0',
    'description': 'A task runner that works well with poetry.',
    'long_description': '************\nPoe the Poet\n************\n\nA task runner that works well with poetry.\n\n.. role:: bash(code)\n   :language: bash\n.. role:: fish(code)\n   :language: fish\n.. role:: zsh(code)\n   :language: zsh\n\n.. role:: toml(code)\n   :language: toml\n\nFeatures\n========\n\n✅  Straight forward declaration of project tasks in your pyproject.toml (kind of like npm scripts)\n\n✅  Task are run in poetry\'s virtualenv by default\n\n✅  Tasks can be commands (with or without a shell) or references to python functions (like tool.poetry.scripts)\n\n✅  Short and sweet commands with extra arguments passed to the task :bash:`poe [options] task [task_args]`\n\n✅  Tasks can specify and reference environment variables as if they were evaluated by a shell\n\n✅  Tasks are self documenting, with optional help messages (just run poe without arguments)\n\n✅  Tasks can be defined as a sequence of other tasks\n\n✅  Shell completion of task names (and global options too for zsh)\n\nInstallation\n============\n\nInto your project (so it works inside poetry shell):\n\n.. code-block:: bash\n\n  poetry add --dev poethepoet\n\nAnd into your default python environment (so it works outside of poetry shell)\n\n.. code-block:: bash\n\n  pip install poethepoet\n\nEnable tab completion for your shell\n------------------------------------\n\nPoe comes with tab completion scripts for bash, zsh, and fish to save you keystrokes. How to install them will depend on your shell setup.\n\nZsh\n~~~\n\n.. code-block:: zsh\n\n  # oh-my-zsh\n  mkdir -p ~/.oh-my-zsh/completions\n  poe _zsh_completion > ~/.oh-my-zsh/completions/_poe\n\n  # without oh-my-zsh\n  mkdir -p ~/.zfunc/\n  poe _zsh_completion > ~/.zfunc/_poetry\n\nNote that you\'ll need to start a new shell for the new completion script to be loaded. If it still doesn\'t work try adding a call to `compinit` to the end of your zshrc file.\n\nBash\n~~~~\n\n.. code-block:: bash\n\n  # System bash\n  poe _bash_completion > /etc/bash_completion.d/poe.bash-completion\n\n  # Homebrew bash\n  poe _bash_completion > $(brew --prefix)/etc/bash_completion.d/poe.bash-completion\n\n\nHow to ensure installed bash completions are enabled may vary depending on your system.\n\nFish\n~~~~\n\n.. code-block:: fish\n\n  # Fish\n  poe _fish_completion > ~/.config/fish/completions/poe.fish\n\n  # Homebrew fish\n  poe _fish_completion > (brew --prefix)/share/fish/vendor_completions.d/poe.fish\n\n\nBasic Usage\n===========\n\nDefine tasks in your pyproject.toml\n-----------------------------------\n\n`See a real example <https://github.com/nat-n/poethepoet/blob/master/pyproject.toml>`_\n\n.. code-block:: toml\n\n  [tool.poe.tasks]\n  test       = "pytest --cov=poethepoet"                                # simple command based task\n  mksandwich = { script = "my_package.sandwich:build" }                 # python script based task\n  tunnel     = { shell = "ssh -N -L 0.0.0.0:8080:$PROD:8080 $PROD &" }  # shell script based task\n\nRun tasks with the poe cli\n--------------------------\n\n.. code-block:: bash\n\n  poe test\n\nAdditional arguments are passed to the task so\n\n.. code-block:: bash\n\n  poe test -v tests/favorite_test.py\n\nresults in the following being run inside poetry\'s virtualenv\n\n.. code-block:: bash\n\n  pytest --cov=poethepoet -v tests/favorite_test.py\n\nYou can also run it like so if you fancy\n\n.. code-block:: bash\n\n  python -m poethepoet [options] task [task_args]\n\nOr install it as a dev dependency with poetry and run it like\n\n.. code-block:: bash\n\n  poetry add --dev poethepoet\n  poetry run poe [options] task [task_args]\n\nThough it that case you might like to do :bash:`alias poe=\'poetry run poe\'`.\n\nTypes of task\n=============\n\nThere are four types of task: simple commands (cmd), python scripts (script), shell\nscripts (shell), and composite tasks (sequence).\n\n- **Command tasks** contain a single command that will be executed without a shell.\n  This covers most basic use cases for example:\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n    format = "black ."  # strings are interpreted as commands by default\n    clean = """\n    # Multiline commands including comments work too. Unescaped whitespace is ignored.\n    rm -rf .coverage\n           .mypy_cache\n           .pytest_cache\n           dist\n           ./**/__pycache__\n    """\n    lint = { "cmd": "pylint poethepoet" }  # Inline tables with a cmd key work too\n    greet = "echo Hello $USER"  # Environment variables work, even though there\'s no shell!\n\n- **Script tasks** contain a reference to a python callable to import and execute, for\n  example:\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n    fetch-assets = { "script" = "my_package.assets:fetch" }\n    fetch-images = { "script" = "my_package.assets:fetch(only=\'images\')" }\n\n  As in the second example, is it possible to hard code literal arguments to the target\n  callable.\n\n  If extra arguments are passed to task on the command line, then they will be available\n  to the called python function via `sys.argv`.\n\n- **Shell tasks** are similar to simple command tasks except that they are executed\n  inside a new shell, and can consist of multiple separate commands, command\n  substitution, pipes, background processes, etc.\n\n  An example use case for this might be opening some ssh tunnels in the background with\n  one task and closing them with another like so:\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n    pfwd = { "shell" = "ssh -N -L 0.0.0.0:8080:$STAGING:8080 $STAGING & ssh -N -L 0.0.0.0:5432:$STAGINGDB:5432 $STAGINGDB &" }\n    pfwdstop = { "shell" = "kill $(pgrep -f "ssh -N -L .*:(8080|5432)")" }\n\n- **Composite tasks** are defined as a sequence of other tasks as an array.\n\n  By default the contents of the array are interpreted as references to other tasks (actually a ref task type), though this behaviour can be altered by setting the global `default_array_item_task_type` option to the name of another task type such as _cmd_, or by setting the `default_item_type` option locally on the sequence task.\n\n  **An example task with references**\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n\n    test = "pytest --cov=src"\n    build = "poetry build"\n    _publish = "poetry publish"\n    release = ["test", "build", "_publish"]\n\n  Note that tasks with names prefixed with `_` are not included in the documentation or directly executable, but can be useful for cases where a task is only needed for a sequence.\n\n  **An example task with inline tasks expressed via inline tables**\n\n  .. code-block:: toml\n\n    release = [\n      { cmd = "pytest --cov=src" },\n      { script = "devtasks:build" },\n      { ref = "_publish" },\n    ]\n\n  **An example task with inline script subtasks using default_item_type**\n\n  .. code-block:: toml\n\n    release.sequence = [\n      "devtasks:run_tests(all=True)",\n      "devtasks:build",\n      "devtasks:publish",\n    ]\n    release.default_item_type = "script"\n\n  A failure (non-zero result) will result in the rest of the tasks in the sequence not being executed, unless the `ignore_fail` option is set on the task like so:\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n    attempts.sequence = ["task1", "task2", "task3"]\n    attempts.ignore_fail = true\n\nTask level configuration\n========================\n\nTask help text\n--------------\n\nYou can specifiy help text to be shown alongside the task name in the list of available tasks (such as when executing poe with no arguments), by adding a help key like so:\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n    style = {cmd = "black . --check --diff", help = "Check code style"}\n\nEnvironment variables\n---------------------\n\nYou can specify arbitrary environment variables to be set for a task by providing the env key like so:\n\n  .. code-block:: toml\n\n    [tool.poe.tasks]\n    serve.script = "myapp:run"\n    serve.env = { PORT = 9001 }\n\nNotice this example uses deep keys which can be more convenient but aren\'t as well supported by some toml implementations.\n\nProject-wide configuration options\n==================================\n\nGlobal environment variables\n----------------------------\n\nYou can configure environment variables to be set for all poe tasks in the pyproject.toml file by specifying `tool.poe.env` like so\n\n.. code-block:: toml\n\n  [tool.poe.env]\n  VAR1 = "FOO"\n  VAR2 = "BAR"\n\nRun poe from anywhere\n---------------------\n\nBy default poe will detect when you\'re inside a project with a pyproject.toml in the\nroot. However if you want to run it from elsewhere that is supported too by using the\n`--root` option to specify an alternate location for the toml file. The task will run\nwith the given location as the current working directory.\n\nIn all cases the path to project root (where the pyproject.toml resides) will be available\nas `$POE_ROOT` within the command line and process.\n\nChange the default task type\n----------------------------\n\nBy default tasks defined as strings are interpreted as shell commands, and script tasks\nrequire the more verbose table syntax to specify. For example:\n\n.. code-block:: toml\n\n  my_cmd_task = "cmd args"\n  my_script_task = { "script" = "my_package.my_module:run" }\n\nThis behaviour can be reversed by setting the `default_task_type` option in your\npyproject.toml like so:\n\n.. code-block:: toml\n\n  [tool.poe]\n  default_task_type = "script"\n\n  [tool.poe.tasks]\n  my_cmd_task = { "cmd" = "cmd args" }\n  my_script_task = "my_package.my_module:run"\n\nContributing\n============\n\nThere\'s plenty to do, come say hi in the issues! 👋\n\nTODO\n====\n\n☐ support declaring specific arguments for a task\n\n☐ support conditional execution (a bit like make targets)\n\n☐ support verbose mode for documentation that shows task definitions\n\n☐ support different task executors such as specifying a non-poetry venv, or working with pipenv,\n\n☐ support third party task or executor types as plugins\n\n☐ maybe provide poe as a poetry plugin\n\n☐ maybe support plumbum based tasks\n\nLicence\n=======\n\nMIT.\n',
    'author': 'Nat Noordanus',
    'author_email': 'n@natn.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nat-n/poethepoet',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
