# clayton

## Sampling from copulae


The modeling of dependence between random variables is an important subject in several
applied fields of science. To this aim the copula function can be used as a margin-free description of the dependence structure. Several copulae belong to specific families such as Archimedean, Elliptical or Extreme. While software implementation of copulae has been thoroughly explored in R software, methods to work with copula in Python are still in their infancy. To promote the dependence modeling with copula in Python, we have developed clayton, a library that provides a range of random vector generation vector for copulae.

The module clayton is implemented using the object-oriented features of the Python language. The classes are designed for Archimedean, elliptical, extreme value copulae. Each contains methods to generate random vectors.

For more information, the reader can access the paper describing the code, which was accepted for publication in computo, at the following URL: https://aleboul.github.io/computo/.

## Installation

### Dependencies

COPPY requires :

- Python (>= 3.7)
- NumPY (>= 1.14.6)
- SciPY (>= 1.1.0)

### Source Code

You can check the latest sources with the command::

  git clone https://github.com/Aleboul/clayton/

## Examples

[Graphical Representations](https://github.com/Aleboul/clayton/blob/master/examples/sample.ipynb)
