"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = exports.VpcEndpointServiceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const privatelink_generated_1 = require("./privatelink.generated");
Object.defineProperty(exports, "VpcEndpointServiceProperty", { enumerable: true, get: function () { return privatelink_generated_1.RosVpcEndpointService; } });
/**
 * A ROS resource type:  `ALIYUN::PrivateLink::VpcEndpointService`
 */
class VpcEndpointService extends ros.Resource {
    /**
     * Create a new `ALIYUN::PrivateLink::VpcEndpointService`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVpcEndpointService = new privatelink_generated_1.RosVpcEndpointService(this, id, {
            payer: props.payer,
            user: props.user,
            serviceDescription: props.serviceDescription,
            resource: props.resource,
            connectBandwidth: props.connectBandwidth,
            zoneAffinityEnabled: props.zoneAffinityEnabled,
            autoAcceptEnabled: props.autoAcceptEnabled,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpcEndpointService;
        this.attrMaxBandwidth = rosVpcEndpointService.attrMaxBandwidth;
        this.attrMinBandwidth = rosVpcEndpointService.attrMinBandwidth;
        this.attrServiceDescription = rosVpcEndpointService.attrServiceDescription;
        this.attrServiceDomain = rosVpcEndpointService.attrServiceDomain;
        this.attrServiceId = rosVpcEndpointService.attrServiceId;
        this.attrServiceName = rosVpcEndpointService.attrServiceName;
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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