# coding: utf-8

"""
    Veeroute.Routing

    Veeroute Routing API  # noqa: E501

    The version of the OpenAPI document: 3.8.171175
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vrt_lss_routing.api_client import ApiClient
from vrt_lss_routing.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MatrixApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def build_matrix(self, matrix_task, **kwargs):  # noqa: E501
        """Creating a time-distance matrix.  # noqa: E501

        Creating time-distance matrices between each pair of locations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.build_matrix(matrix_task, async_req=True)
        >>> result = thread.get()

        :param matrix_task: New request for matrix calculation. (required)
        :type matrix_task: MatrixTask
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MatrixResult
        """
        kwargs['_return_http_data_only'] = True
        return self.build_matrix_with_http_info(matrix_task, **kwargs)  # noqa: E501

    def build_matrix_with_http_info(self, matrix_task, **kwargs):  # noqa: E501
        """Creating a time-distance matrix.  # noqa: E501

        Creating time-distance matrices between each pair of locations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.build_matrix_with_http_info(matrix_task, async_req=True)
        >>> result = thread.get()

        :param matrix_task: New request for matrix calculation. (required)
        :type matrix_task: MatrixTask
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MatrixResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'matrix_task'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method build_matrix" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'matrix_task' is set
        if self.api_client.client_side_validation and ('matrix_task' not in local_var_params or  # noqa: E501
                                                        local_var_params['matrix_task'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `matrix_task` when calling `build_matrix`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'matrix_task' in local_var_params:
            body_params = local_var_params['matrix_task']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "MatrixResult",
            400: "InlineResponse400",
            401: "InlineResponse401",
            404: "InlineResponse404",
            406: "InlineResponse406",
            415: "InlineResponse415",
            429: "InlineResponse429",
            500: "InlineResponse500",
            501: "InlineResponse501",
            502: "InlineResponse502",
            503: "InlineResponse503",
            504: "InlineResponse504",
        }

        return self.api_client.call_api(
            '/routing/matrix', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
