# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/Sanitize_Secrets.ipynb.

# %% auto 0
__all__ = ['old_log', 'old_publish_display_data', 'sanitize_secrets', 'new_publish_display_data', 'sanitized_print']

# %% ../notebooks/Sanitize_Secrets.ipynb 2
import builtins
import logging
import re
import sys
from logging import Logger
from typing import *

import IPython

from .logger import get_logger

from fastcore.utils import patch

# %% ../notebooks/Sanitize_Secrets.ipynb 9
def sanitize_secrets(s: str) -> str:
    d = {
        "(A3T[A-Z0-9]|AKIA|AGPA|AIDA|AROA|AIPA|ANPA|ANVA|ASIA)\w+": "*" * 20,
        "AWS_ACCESS_KEY_ID':\s*'.*?'": "AWS_ACCESS_KEY_ID': " + f"'{'*' * 20}'",
        "AWSAccessKeyId':\s*'.*?'": "AWSAccessKeyId': " + f"'{'*' * 20}'",
        "KEY':\s*'.*?'": "KEY': " + f"'{'*' * 40}'",
        "KEY\s*=\s*'.*?'": "KEY = " + f"'{'*' * 40}'",
        "AZURE_SUBSCRIPTION_ID':\s*'.*?'": "AZURE_SUBSCRIPTION_ID': " + f"'{'*' * 36}'",
        "AZURE_TENANT_ID':\s*'.*?'": "AZURE_TENANT_ID': " + f"'{'*' * 36}'",
        "AZURE_CLIENT_ID':\s*'.*?'": "AZURE_CLIENT_ID': " + f"'{'*' * 36}'",
        "SECRET':\s*'.*?'": "SECRET': " + f"'{'*' * 40}'",
        "PASSWORD':\s*'.*?'": "PASSWORD': " + f"'{'*' * 40}'",
        "POLICY':\s*'.*?'": "POLICY': " + f"'{'*' * 252}'",
        "SIGNATURE':\s*'.*?'": "SIGNATURE': " + f"'{'*' * 28}'",
        "://.*@": "://" + "*" * 40 + "@",
        "value':\s*'[a-zA-Z0-9]{8}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{12}'": f"value': '{'*'*8}-{'*'*4}-{'*'*4}-{'*'*4}-{'*'*12}'",
        "[a-zA-Z0-9]{5}~[a-zA-Z0-9-]{34}": f"{'*'*40}",
    }

    d2 = {k.replace("'", '"'): v.replace("'", '"') for k, v in d.items() if "'" in k}
    for k, v in d2.items():
        d[k] = v

    d3 = {k.lower(): v.lower() for k, v in d.items()}
    for k, v in d3.items():
        d[k] = v

    d4 = {
        k.replace("':", "="): v.replace("':", " =") for k, v in d.items() if "':" in k
    }
    for k, v in d4.items():
        d[k] = v

    d = {k.replace("'", "\\\\?'"): v for k, v in d.items()}

    if not isinstance(s, str):
        s = s.__repr__()

    for pattern, replacement in d.items():
        s = re.sub(pattern, replacement, s)

    return s

# %% ../notebooks/Sanitize_Secrets.ipynb 17
old_log = Logger._log

# %% ../notebooks/Sanitize_Secrets.ipynb 18
@patch
def _log(self: Logger, level, msg, *args, **kwargs):
    return old_log(self, level, sanitize_secrets(msg), *args, **kwargs)

# %% ../notebooks/Sanitize_Secrets.ipynb 23
old_publish_display_data = IPython.core.display_functions.publish_display_data

# %% ../notebooks/Sanitize_Secrets.ipynb 24
def new_publish_display_data(
    data,
    metadata=None,
    source=IPython.core.display_functions._sentinel,
    *,
    transient=None,
    **kwargs
):
    sanitized_data = {
        k: sanitize_secrets(v.__repr__() if not isinstance(v, str) else v)
        for k, v in data.items()
    }
    return old_publish_display_data(
        sanitized_data, metadata=metadata, source=source, transient=transient, **kwargs
    )


IPython.core.display_functions.publish_display_data = new_publish_display_data

# %% ../notebooks/Sanitize_Secrets.ipynb 27
old_print = builtins.print

# %% ../notebooks/Sanitize_Secrets.ipynb 28
def sanitized_print(*objects, sep=" ", end="\n", file=sys.stdout, flush=False):
    new_objs = [
        sanitize_secrets(obj.__repr__() if not isinstance(obj, str) else obj)
        for obj in objects
    ]
    return old_print(*new_objs, sep=sep, end=end, file=file, flush=flush)


# builtins.print = new_print
