"""create indexes for download count queries

Revision ID: b9886d9cadb0
Revises: 0653794b6252
Create Date: 2021-01-28 13:11:27.197409

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = 'b9886d9cadb0'
down_revision = '0653794b6252'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('aggregated_metrics', schema=None) as batch_op:
        batch_op.create_index(
            'package_version_metric_index',
            [
                'channel_name',
                'platform',
                'filename',
                'metric_name',
                'period',
                'timestamp',
            ],
            unique=False,
        )
        batch_op.create_unique_constraint(
            "package_version_metric_constraint",
            [
                'channel_name',
                'platform',
                'filename',
                'metric_name',
                'period',
                'timestamp',
            ],
        )

    with op.batch_alter_table('package_versions', schema=None) as batch_op:
        batch_op.create_index(
            'package_version_filename_index',
            ['channel_name', 'filename', 'platform'],
            unique=True,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('package_versions', schema=None) as batch_op:
        batch_op.drop_index('package_version_filename_index')

    with op.batch_alter_table('aggregated_metrics', schema=None) as batch_op:
        batch_op.drop_constraint("package_version_metric_constraint", type_='unique')
        batch_op.drop_index('package_version_metric_index')

    # ### end Alembic commands ###
