"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.phoneNumberValidator = void 0;
var AREA_CODE = /^[^01][0-9]{2}$/;
var TOLL_FREE = /^8(33|44|55|66|77|88)$/;
function phoneNumberValidator(props) {
    if (props.phoneCity && !props.phoneState) {
        throw new Error('State must be included with City search');
    }
    if ((props.phoneCountry === 'US' || !props.phoneCountry) &&
        !(props.phoneState ||
            props.phoneAreaCode ||
            props.phoneNumberTollFreePrefix)) {
        throw new Error('Need a State, Area Code, or Toll Free Prefix');
    }
    if (props.phoneCountry &&
        !(props.phoneCountry === 'US') &&
        !props.phoneNumberType) {
        throw new Error('Non US numbers must include Number Type');
    }
    if (props.phoneProductType === 'VoiceConnector' &&
        !(props.phoneCountry === 'US')) {
        throw new Error('Non US numbers must be SipMediaApplicationDialIn');
    }
    if (props.phoneNumberTollFreePrefix) {
        if (!TOLL_FREE.test(props.phoneNumberTollFreePrefix.toString())) {
            throw new Error('Invalid Toll Free Prefix');
        }
    }
    if (props.phoneAreaCode) {
        if (!AREA_CODE.test(props.phoneAreaCode.toString())) {
            throw new Error('Invalid Area Code');
        }
    }
    return true;
}
exports.phoneNumberValidator = phoneNumberValidator;
//# sourceMappingURL=data:application/json;base64,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