import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeGlobalNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The default port used if the port number is not specified in the
  network endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#default_port ComputeGlobalNetworkEndpointGroup#default_port}
    */
    readonly defaultPort?: number;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#description ComputeGlobalNetworkEndpointGroup#description}
    */
    readonly description?: string;
    /**
    * Name of the resource; provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#name ComputeGlobalNetworkEndpointGroup#name}
    */
    readonly name: string;
    /**
    * Type of network endpoints in this network endpoint group. Possible values: ["INTERNET_IP_PORT", "INTERNET_FQDN_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#network_endpoint_type ComputeGlobalNetworkEndpointGroup#network_endpoint_type}
    */
    readonly networkEndpointType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#project ComputeGlobalNetworkEndpointGroup#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#timeouts ComputeGlobalNetworkEndpointGroup#timeouts}
    */
    readonly timeouts?: ComputeGlobalNetworkEndpointGroupTimeouts;
}
export interface ComputeGlobalNetworkEndpointGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#create ComputeGlobalNetworkEndpointGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group#delete ComputeGlobalNetworkEndpointGroup#delete}
    */
    readonly delete?: string;
}
export declare function computeGlobalNetworkEndpointGroupTimeoutsToTerraform(struct?: ComputeGlobalNetworkEndpointGroupTimeoutsOutputReference | ComputeGlobalNetworkEndpointGroupTimeouts | cdktf.IResolvable): any;
export declare class ComputeGlobalNetworkEndpointGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeGlobalNetworkEndpointGroupTimeouts | undefined;
    set internalValue(value: ComputeGlobalNetworkEndpointGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group google_compute_global_network_endpoint_group}
*/
export declare class ComputeGlobalNetworkEndpointGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group google_compute_global_network_endpoint_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeGlobalNetworkEndpointGroupConfig
    */
    constructor(scope: Construct, id: string, config: ComputeGlobalNetworkEndpointGroupConfig);
    private _defaultPort?;
    get defaultPort(): number;
    set defaultPort(value: number);
    resetDefaultPort(): void;
    get defaultPortInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkEndpointType?;
    get networkEndpointType(): string;
    set networkEndpointType(value: string);
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): ComputeGlobalNetworkEndpointGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeGlobalNetworkEndpointGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeGlobalNetworkEndpointGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
