import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputePerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The instance group manager this instance config is part of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#instance_group_manager ComputePerInstanceConfig#instance_group_manager}
    */
    readonly instanceGroupManager: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#minimal_action ComputePerInstanceConfig#minimal_action}
    */
    readonly minimalAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#most_disruptive_allowed_action ComputePerInstanceConfig#most_disruptive_allowed_action}
    */
    readonly mostDisruptiveAllowedAction?: string;
    /**
    * The name for this per-instance config and its corresponding instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#name ComputePerInstanceConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#project ComputePerInstanceConfig#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#remove_instance_state_on_destroy ComputePerInstanceConfig#remove_instance_state_on_destroy}
    */
    readonly removeInstanceStateOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Zone where the containing instance group manager is located
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#zone ComputePerInstanceConfig#zone}
    */
    readonly zone?: string;
    /**
    * preserved_state block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#preserved_state ComputePerInstanceConfig#preserved_state}
    */
    readonly preservedState?: ComputePerInstanceConfigPreservedState;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#timeouts ComputePerInstanceConfig#timeouts}
    */
    readonly timeouts?: ComputePerInstanceConfigTimeouts;
}
export interface ComputePerInstanceConfigPreservedStateDisk {
    /**
    * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
  The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
  'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
  'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
  deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#delete_rule ComputePerInstanceConfig#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#device_name ComputePerInstanceConfig#device_name}
    */
    readonly deviceName: string;
    /**
    * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#mode ComputePerInstanceConfig#mode}
    */
    readonly mode?: string;
    /**
    * The URI of an existing persistent disk to attach under the specified device-name in the format
  'projects/project-id/zones/zone/disks/disk-name'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#source ComputePerInstanceConfig#source}
    */
    readonly source: string;
}
export declare function computePerInstanceConfigPreservedStateDiskToTerraform(struct?: ComputePerInstanceConfigPreservedStateDisk | cdktf.IResolvable): any;
export interface ComputePerInstanceConfigPreservedState {
    /**
    * Preserved metadata defined for this instance. This is a list of key->value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#metadata ComputePerInstanceConfig#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#disk ComputePerInstanceConfig#disk}
    */
    readonly disk?: ComputePerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
}
export declare function computePerInstanceConfigPreservedStateToTerraform(struct?: ComputePerInstanceConfigPreservedStateOutputReference | ComputePerInstanceConfigPreservedState): any;
export declare class ComputePerInstanceConfigPreservedStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputePerInstanceConfigPreservedState | undefined;
    set internalValue(value: ComputePerInstanceConfigPreservedState | undefined);
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _disk?;
    get disk(): ComputePerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
    set disk(value: ComputePerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable);
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | ComputePerInstanceConfigPreservedStateDisk[] | undefined;
}
export interface ComputePerInstanceConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#create ComputePerInstanceConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#delete ComputePerInstanceConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config#update ComputePerInstanceConfig#update}
    */
    readonly update?: string;
}
export declare function computePerInstanceConfigTimeoutsToTerraform(struct?: ComputePerInstanceConfigTimeoutsOutputReference | ComputePerInstanceConfigTimeouts | cdktf.IResolvable): any;
export declare class ComputePerInstanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputePerInstanceConfigTimeouts | undefined;
    set internalValue(value: ComputePerInstanceConfigTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config google_compute_per_instance_config}
*/
export declare class ComputePerInstanceConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_per_instance_config google_compute_per_instance_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputePerInstanceConfigConfig
    */
    constructor(scope: Construct, id: string, config: ComputePerInstanceConfigConfig);
    get id(): string;
    private _instanceGroupManager?;
    get instanceGroupManager(): string;
    set instanceGroupManager(value: string);
    get instanceGroupManagerInput(): string | undefined;
    private _minimalAction?;
    get minimalAction(): string;
    set minimalAction(value: string);
    resetMinimalAction(): void;
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    get mostDisruptiveAllowedAction(): string;
    set mostDisruptiveAllowedAction(value: string);
    resetMostDisruptiveAllowedAction(): void;
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _removeInstanceStateOnDestroy?;
    get removeInstanceStateOnDestroy(): boolean | cdktf.IResolvable;
    set removeInstanceStateOnDestroy(value: boolean | cdktf.IResolvable);
    resetRemoveInstanceStateOnDestroy(): void;
    get removeInstanceStateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _preservedState;
    get preservedState(): ComputePerInstanceConfigPreservedStateOutputReference;
    putPreservedState(value: ComputePerInstanceConfigPreservedState): void;
    resetPreservedState(): void;
    get preservedStateInput(): ComputePerInstanceConfigPreservedState | undefined;
    private _timeouts;
    get timeouts(): ComputePerInstanceConfigTimeoutsOutputReference;
    putTimeouts(value: ComputePerInstanceConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputePerInstanceConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
