import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment#name DataGoogleComposerEnvironment#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment#project DataGoogleComposerEnvironment#project}
    */
    readonly project?: string;
    /**
    * The location or Compute Engine region for the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment#region DataGoogleComposerEnvironment#region}
    */
    readonly region?: string;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy extends cdktf.ComplexComputedList {
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
    get useIpAliases(): cdktf.IResolvable;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfig extends cdktf.ComplexComputedList {
    get diskSizeGb(): number;
    get ipAllocationPolicy(): cdktf.IResolvable;
    get machineType(): string;
    get network(): string;
    get oauthScopes(): string[];
    get serviceAccount(): string;
    get subnetwork(): string;
    get tags(): string[];
    get zone(): string;
}
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig extends cdktf.ComplexComputedList {
    get cloudSqlIpv4CidrBlock(): string;
    get enablePrivateEndpoint(): cdktf.IResolvable;
    get masterIpv4CidrBlock(): string;
    get webServerIpv4CidrBlock(): string;
}
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfig extends cdktf.ComplexComputedList {
    get airflowConfigOverrides(): {
        [key: string]: string;
    };
    get envVariables(): {
        [key: string]: string;
    };
    get imageVersion(): string;
    get pypiPackages(): {
        [key: string]: string;
    };
    get pythonVersion(): string;
    get schedulerCount(): number;
}
export declare class DataGoogleComposerEnvironmentConfigA extends cdktf.ComplexComputedList {
    get airflowUri(): string;
    get dagGcsPrefix(): string;
    get gkeCluster(): string;
    get nodeConfig(): cdktf.IResolvable;
    get nodeCount(): number;
    get privateEnvironmentConfig(): cdktf.IResolvable;
    get softwareConfig(): cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/composer_environment google_composer_environment}
*/
export declare class DataGoogleComposerEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/composer_environment google_composer_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComposerEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComposerEnvironmentConfig);
    config(index: string): DataGoogleComposerEnvironmentConfigA;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
