import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization#domain DataGoogleOrganization#domain}
    */
    readonly domain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization#organization DataGoogleOrganization#organization}
    */
    readonly organization?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/organization google_organization}
*/
export declare class DataGoogleOrganization extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/organization google_organization} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleOrganizationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleOrganizationConfig);
    get createTime(): string;
    get directoryCustomerId(): string;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    get id(): string;
    get lifecycleState(): string;
    get name(): string;
    get orgId(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
