import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareFhirStoreIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy#fhir_store_id HealthcareFhirStoreIamPolicy#fhir_store_id}
    */
    readonly fhirStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy#policy_data HealthcareFhirStoreIamPolicy#policy_data}
    */
    readonly policyData: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy google_healthcare_fhir_store_iam_policy}
*/
export declare class HealthcareFhirStoreIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_policy google_healthcare_fhir_store_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareFhirStoreIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareFhirStoreIamPolicyConfig);
    get etag(): string;
    private _fhirStoreId?;
    get fhirStoreId(): string;
    set fhirStoreId(value: string);
    get fhirStoreIdInput(): string | undefined;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
