import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsKeyRingImportJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * It must be unique within a KeyRing and match the regular expression [a-zA-Z0-9_-]{1,63}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#import_job_id KmsKeyRingImportJob#import_job_id}
    */
    readonly importJobId: string;
    /**
    * The wrapping method to be used for incoming key material. Possible values: ["RSA_OAEP_3072_SHA1_AES_256", "RSA_OAEP_4096_SHA1_AES_256"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#import_method KmsKeyRingImportJob#import_method}
    */
    readonly importMethod: string;
    /**
    * The KeyRing that this import job belongs to.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#key_ring KmsKeyRingImportJob#key_ring}
    */
    readonly keyRing: string;
    /**
    * The protection level of the ImportJob. This must match the protectionLevel of the
  versionTemplate on the CryptoKey you attempt to import into. Possible values: ["SOFTWARE", "HSM", "EXTERNAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#protection_level KmsKeyRingImportJob#protection_level}
    */
    readonly protectionLevel: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#timeouts KmsKeyRingImportJob#timeouts}
    */
    readonly timeouts?: KmsKeyRingImportJobTimeouts;
}
export declare class KmsKeyRingImportJobAttestation extends cdktf.ComplexComputedList {
    get content(): string;
    get format(): string;
}
export declare class KmsKeyRingImportJobPublicKey extends cdktf.ComplexComputedList {
    get pem(): string;
}
export interface KmsKeyRingImportJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#create KmsKeyRingImportJob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job#delete KmsKeyRingImportJob#delete}
    */
    readonly delete?: string;
}
export declare function kmsKeyRingImportJobTimeoutsToTerraform(struct?: KmsKeyRingImportJobTimeoutsOutputReference | KmsKeyRingImportJobTimeouts | cdktf.IResolvable): any;
export declare class KmsKeyRingImportJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KmsKeyRingImportJobTimeouts | undefined;
    set internalValue(value: KmsKeyRingImportJobTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job google_kms_key_ring_import_job}
*/
export declare class KmsKeyRingImportJob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job google_kms_key_ring_import_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsKeyRingImportJobConfig
    */
    constructor(scope: Construct, id: string, config: KmsKeyRingImportJobConfig);
    attestation(index: string): KmsKeyRingImportJobAttestation;
    get expireTime(): string;
    get id(): string;
    private _importJobId?;
    get importJobId(): string;
    set importJobId(value: string);
    get importJobIdInput(): string | undefined;
    private _importMethod?;
    get importMethod(): string;
    set importMethod(value: string);
    get importMethodInput(): string | undefined;
    private _keyRing?;
    get keyRing(): string;
    set keyRing(value: string);
    get keyRingInput(): string | undefined;
    get name(): string;
    private _protectionLevel?;
    get protectionLevel(): string;
    set protectionLevel(value: string);
    get protectionLevelInput(): string | undefined;
    publicKey(index: string): KmsKeyRingImportJobPublicKey;
    get state(): string;
    private _timeouts;
    get timeouts(): KmsKeyRingImportJobTimeoutsOutputReference;
    putTimeouts(value: KmsKeyRingImportJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KmsKeyRingImportJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
