import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RuntimeconfigConfigIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#config RuntimeconfigConfigIamMember#config}
    */
    readonly config: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#member RuntimeconfigConfigIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#project RuntimeconfigConfigIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#role RuntimeconfigConfigIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#condition RuntimeconfigConfigIamMember#condition}
    */
    readonly condition?: RuntimeconfigConfigIamMemberCondition;
}
export interface RuntimeconfigConfigIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#description RuntimeconfigConfigIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#expression RuntimeconfigConfigIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member#title RuntimeconfigConfigIamMember#title}
    */
    readonly title: string;
}
export declare function runtimeconfigConfigIamMemberConditionToTerraform(struct?: RuntimeconfigConfigIamMemberConditionOutputReference | RuntimeconfigConfigIamMemberCondition): any;
export declare class RuntimeconfigConfigIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RuntimeconfigConfigIamMemberCondition | undefined;
    set internalValue(value: RuntimeconfigConfigIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member google_runtimeconfig_config_iam_member}
*/
export declare class RuntimeconfigConfigIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_member google_runtimeconfig_config_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RuntimeconfigConfigIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: RuntimeconfigConfigIamMemberConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    get configInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): RuntimeconfigConfigIamMemberConditionOutputReference;
    putCondition(value: RuntimeconfigConfigIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): RuntimeconfigConfigIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
