import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [mobilehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmobilehub.html).
 *
 * @experimental
 */
export declare class Mobilehub extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [mobilehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmobilehub.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Create a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toCreateProject(): this;
    /**
     * (experimental) Enable AWS Mobile Hub in the account by creating the required service role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toCreateServiceRole(): this;
    /**
     * (experimental) Delete the specified project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toDeleteProject(): this;
    /**
     * (experimental) Delete a saved snapshot of project configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toDeleteProjectSnapshot(): this;
    /**
     * (experimental) Deploy changes to the specified stage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toDeployToStage(): this;
    /**
     * (experimental) Describe the download bundle.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toDescribeBundle(): this;
    /**
     * (experimental) Export the download bundle.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toExportBundle(): this;
    /**
     * (experimental) Export the project configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toExportProject(): this;
    /**
     * (experimental) Generate project parameters required for code generation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toGenerateProjectParameters(): this;
    /**
     * (experimental) Get project configuration and resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toGetProject(): this;
    /**
     * (experimental) Fetch the previously exported project configuration snapshot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toGetProjectSnapshot(): this;
    /**
     * (experimental) Create a new project from the previously exported project configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toImportProject(): this;
    /**
     * (experimental) Install a bundle in the project deployments S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toInstallBundle(): this;
    /**
     * (experimental) List the available SaaS (Software as a Service) connectors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toListAvailableConnectors(): this;
    /**
     * (experimental) List available features.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toListAvailableFeatures(): this;
    /**
     * (experimental) List available regions for projects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toListAvailableRegions(): this;
    /**
     * (experimental) List the available download bundles.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toListBundles(): this;
    /**
     * (experimental) List saved snapshots of project configuration.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toListProjectSnapshots(): this;
    /**
     * (experimental) List projects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toListProjects(): this;
    /**
     * (experimental) Synchronize state of resources into project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toSynchronizeProject(): this;
    /**
     * (experimental) Update project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toUpdateProject(): this;
    /**
     * (experimental) Validate a mobile hub project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toValidateProject(): this;
    /**
     * (experimental) Verify AWS Mobile Hub is enabled in the account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     *
     * @experimental
     */
    toVerifyServiceRole(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type project to the statement.
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/reference-mobile-hub-iam-managed-policies.html
     *
     * @param projectId - Identifier for the projectId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onProject(projectId: string, account?: string, region?: string, partition?: string): this;
}
