![Blankly_Github_Logo](https://firebasestorage.googleapis.com/v0/b/blankly-6ada5.appspot.com/o/blankly-white.svg?alt=media&token=d5d57c15-4c55-422f-9b06-2e578288fa14)
[![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=Blankly-Finance_Blankly&metric=sqale_rating)](https://sonarcloud.io/dashboard?id=Blankly-Finance_Blankly)
[![Security Rating](https://sonarcloud.io/api/project_badges/measure?project=Blankly-Finance_Blankly&metric=security_rating)](https://sonarcloud.io/dashboard?id=Blankly-Finance_Blankly)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=Blankly-Finance_Blankly&metric=alert_status)](https://sonarcloud.io/dashboard?id=Blankly-Finance_Blankly)
[![Downloads](https://pepy.tech/badge/blankly/month)](https://pepy.tech/project/blankly)
[![Docs Badge](https://img.shields.io/badge/Check%20Our%20-DOCS-<COLOR>.svg?style=for-the-badge&logo=data:image/svg%2bxml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4bWxuczpzZXJpZj0iaHR0cDovL3d3dy5zZXJpZi5jb20vIiB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiB2aWV3Qm94PSIwIDAgNDEzNCA0MTM0IiB2ZXJzaW9uPSIxLjEiIHhtbDpzcGFjZT0icHJlc2VydmUiIHN0eWxlPSJmaWxsLXJ1bGU6ZXZlbm9kZDtjbGlwLXJ1bGU6ZXZlbm9kZDtzdHJva2UtbGluZWpvaW46cm91bmQ7c3Ryb2tlLW1pdGVybGltaXQ6MjsiPgogICAgPHBhdGggZD0iTTQxMzMuODYsNzE0Ljk3OUM0MTMzLjg2LDMyMC4zNzEgMzgxMy40OSwwIDM0MTguODgsMEw3MTQuOTc5LDBDMzIwLjM3MSwwIDAsMzIwLjM3MSAwLDcxNC45NzlMMCwzNDE4Ljg4QzAsMzgxMy40OSAzMjAuMzcxLDQxMzMuODYgNzE0Ljk3OSw0MTMzLjg2TDM0MTguODgsNDEzMy44NkMzODEzLjQ5LDQxMzMuODYgNDEzMy44NiwzODEzLjQ5IDQxMzMuODYsMzQxOC44OEw0MTMzLjg2LDcxNC45NzlaIiBzdHlsZT0iZmlsbDp3aGl0ZTsiLz4KICAgIDxnIHRyYW5zZm9ybT0ibWF0cml4KDIwMy42NDYsMCwwLDIwMy42NDYsLTM2MDU2LC0yNTAzLjQzKSI+CiAgICAgICAgPHBhdGggZD0iTTE4OC40MzQsMTQuOTk0TDE4NS45NywxNC45OTRMMTc5LjQ2MiwyOS44OTJMMTgxLjE1NiwyOS44OTJDMTgxLjM0NCwyOS44OTIgMTgxLjUyOSwyOS44NjQgMTgxLjcxMiwyOS44MDhDMTgxLjg5NiwyOS43NTMgMTgyLjA2OCwyOS42NzUgMTgyLjIyOCwyOS41NzVDMTgyLjM4NywyOS40NzQgMTgyLjUyOSwyOS4zNTQgMTgyLjY1NCwyOS4yMTZDMTgyLjc3OSwyOS4wNzcgMTgyLjg3NSwyOC45MjUgMTgyLjk0NSwyOC43NThMMTgzLjgxOCwyNi43NDJMMTgzLjgyLDI2Ljc0MkwxODUuMzk1LDIzLjExNUwxODUuNDA5LDIzLjExNUwxODcuMjAyLDE4Ljk1M0wxODkuMzgsMjQuMDA3TDE4OC4xNDMsMjQuMDA3QzE4Ny4yMTcsMjQuMDA3IDE4Ni4zNzksMjQuNTU3IDE4Ni4wMTEsMjUuNDA2TDE4NS40MzEsMjYuNzQyTDE5MC41ODYsMjYuNzQyTDE5MS40NywyOC43NThDMTkxLjYyOSwyOS4xMTIgMTkxLjg2OCwyOS4zODkgMTkyLjE4NywyOS41OUMxOTIuNTA2LDI5Ljc5MSAxOTIuODU5LDI5Ljg5MiAxOTMuMjQ3LDI5Ljg5MkwxOTQuOTQyLDI5Ljg5MkwxODguNDM0LDE0Ljk5NFoiIHN0eWxlPSJmaWxsLXJ1bGU6bm9uemVybzsiLz4KICAgIDwvZz4KPC9zdmc+)](https://docs.blankly.finance)
[![Docs Badge](https://img.shields.io/badge/Brandon%20Made%20The-Website-<COLOR>.svg?style=for-the-badge&logo=data:image/svg%2bxml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4bWxuczpzZXJpZj0iaHR0cDovL3d3dy5zZXJpZi5jb20vIiB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiB2aWV3Qm94PSIwIDAgNDEzNCA0MTM0IiB2ZXJzaW9uPSIxLjEiIHhtbDpzcGFjZT0icHJlc2VydmUiIHN0eWxlPSJmaWxsLXJ1bGU6ZXZlbm9kZDtjbGlwLXJ1bGU6ZXZlbm9kZDtzdHJva2UtbGluZWpvaW46cm91bmQ7c3Ryb2tlLW1pdGVybGltaXQ6MjsiPgogICAgPHBhdGggZD0iTTQxMzMuODYsNzE0Ljk3OUM0MTMzLjg2LDMyMC4zNzEgMzgxMy40OSwwIDM0MTguODgsMEw3MTQuOTc5LDBDMzIwLjM3MSwwIDAsMzIwLjM3MSAwLDcxNC45NzlMMCwzNDE4Ljg4QzAsMzgxMy40OSAzMjAuMzcxLDQxMzMuODYgNzE0Ljk3OSw0MTMzLjg2TDM0MTguODgsNDEzMy44NkMzODEzLjQ5LDQxMzMuODYgNDEzMy44NiwzODEzLjQ5IDQxMzMuODYsMzQxOC44OEw0MTMzLjg2LDcxNC45NzlaIiBzdHlsZT0iZmlsbDp3aGl0ZTsiLz4KICAgIDxnIHRyYW5zZm9ybT0ibWF0cml4KDIwMy42NDYsMCwwLDIwMy42NDYsLTM2MDU2LC0yNTAzLjQzKSI+CiAgICAgICAgPHBhdGggZD0iTTE4OC40MzQsMTQuOTk0TDE4NS45NywxNC45OTRMMTc5LjQ2MiwyOS44OTJMMTgxLjE1NiwyOS44OTJDMTgxLjM0NCwyOS44OTIgMTgxLjUyOSwyOS44NjQgMTgxLjcxMiwyOS44MDhDMTgxLjg5NiwyOS43NTMgMTgyLjA2OCwyOS42NzUgMTgyLjIyOCwyOS41NzVDMTgyLjM4NywyOS40NzQgMTgyLjUyOSwyOS4zNTQgMTgyLjY1NCwyOS4yMTZDMTgyLjc3OSwyOS4wNzcgMTgyLjg3NSwyOC45MjUgMTgyLjk0NSwyOC43NThMMTgzLjgxOCwyNi43NDJMMTgzLjgyLDI2Ljc0MkwxODUuMzk1LDIzLjExNUwxODUuNDA5LDIzLjExNUwxODcuMjAyLDE4Ljk1M0wxODkuMzgsMjQuMDA3TDE4OC4xNDMsMjQuMDA3QzE4Ny4yMTcsMjQuMDA3IDE4Ni4zNzksMjQuNTU3IDE4Ni4wMTEsMjUuNDA2TDE4NS40MzEsMjYuNzQyTDE5MC41ODYsMjYuNzQyTDE5MS40NywyOC43NThDMTkxLjYyOSwyOS4xMTIgMTkxLjg2OCwyOS4zODkgMTkyLjE4NywyOS41OUMxOTIuNTA2LDI5Ljc5MSAxOTIuODU5LDI5Ljg5MiAxOTMuMjQ3LDI5Ljg5MkwxOTQuOTQyLDI5Ljg5MkwxODguNDM0LDE0Ljk5NFoiIHN0eWxlPSJmaWxsLXJ1bGU6bm9uemVybzsiLz4KICAgIDwvZz4KPC9zdmc+)](https://blankly.finance)


## What is it?

​	Blankly is an elegant python library for interacting with many crypto exchanges on multiple portfolios in a consistent way. Blankly offers a powerful feature-set, optimized for speed and ease of use.

Try it out: `pip install blankly`


Check out our [website](http://blankly.finance).

## Features

- Full REST API support for non-margin accounts on listed exchanges

- Ticker websocket support

- Order book websocket support

- Fully multiprocessed bots with flexible arguments.

- Quickstart access for interacting with exchanges

- Support for multiple portfolios on multiple exchanges, all independently

- Multi-process communication

- Long term and high resolution historical data downloads as pandas dataframes

- Single pip module (`pip install Blankly`)

- Asynchronous callbacks from ticker feeds

- ZeroRPC server to report to Javascript or React **

- Easy access to raw API calls

- Customizable circular buffer websocket feeds

- Support for coinbase pro & binance sandbox modes

- Instant paper trade wrapper for supported exchanges

- Run scheduled functions natively

- Logs for websocket feeds

- Status management for purchases

- Create strategies using an event-based framework

- Instantly backtest your strategies (`strategy.backtest(to='1y')`)

- Automatic price downloads & caching for use in backtests

- Interface that allows calls to each supported exchange to be identical:

  > Buy example for Coinbase Pro and Binance:
  >
  > Coinbase Pro:
  >
  > ```python
  > self.Interface.market_order(.01, "buy", "BTC-USD")
  > ```
  >
  > Binance:
  >
  > ```python
  > self.Interface.market_order(.01, "buy", "BTC-USD")
  > ```

** Means that the feature is still in development but has some degree of support.

## Coming Features

- Deployment (`> Blankly push bot/*`)
- Online hosting

# Quick Start

1. Using Blankly is incredibly easy. It just requires the pip module and 3 basic files. First **install the pip module** by

> `pip install Blankly`

2. Next **you need the files** in the `Examples` folder:

> Basic_Bot.py
>
> Keys_Example.json
>
> Settings.json

3. **Place** these in the `root` or `working directory` of the project.

4. **Rename** `Keys_Example.json` to `Keys.json` or create your own `.json` that has the same structure.

5. **Insert the API keys** from your exchange into the renamed `Keys.json` file.

   1. **You can add multiple portfolios**! You can specify the name of the portfolio to load when you construct the exchange.
   2. Example: `Blankly.Coinbase_Pro(portfolio_name="my cool portfolio")`). 
   3. If you don't provide one to the constructor, it will just default to the first one given in the `Keys.json` file and show a warning.

6. **The script defaults to Coinbase Pro**. If you're using that, great! If not, change the line that says:

   > `exchange = Blankly.Coinbase_Pro()`
   >
   > to one that matches your exchange, such as:
   >
   > `exchange = Blankly.Binance()`

7. **Everything should work**! Run the `Basic_Bot` example in `Basic_Bot.py`. Note a warning will be shown because the `Basic_Bot` script does not specify the exchange name by default (explained in step 5 above).
    - Note the library is developed on Python 3.7, but most modern versions of python 3 should work.

[comment]: <> (## What is it doing?)

[comment]: <> (The comments offer a decent amount of description for the behavior, but here is a broader overview:)

[comment]: <> (​	The motivation behind this is to **allow full independence** between each bot, but still **giving it the ability to report** back to the main thread easily. The setup runs by specifying three increasingly specific things about the behavior we want:)

[comment]: <> (1. We first **declare** that we want to run on a certain `exchange`, such as Coinbase Pro or Binance. This is done with &#40;for example&#41; `Blankly.Coinbase_Pro&#40;&#41;`)

[comment]: <> (   - Documentation refers to this as the `exchange`)

[comment]: <> (   - ```python)

[comment]: <> (     if __name__ == "__main__":)

[comment]: <> (         """)

[comment]: <> (         Easily setup and run a model on any exchange)

[comment]: <> (         """)
     
[comment]: <> (         # This creates an authenticated exchange. Now we can append models.)

[comment]: <> (         exchange = Blankly.Coinbase_Pro&#40;&#41;)

[comment]: <> (         # Imagine this:)

[comment]: <> (         #   Coinbase Pro <-- Choosing to assign this bot to this exchange)

[comment]: <> (         #   Kraken)

[comment]: <> (         #   Binance)

[comment]: <> (     ```)

[comment]: <> (2. We initialize the bot object. This creates a boilerplate bot that isn't attached or running on anything yet.)

[comment]: <> (   - ```python)

[comment]: <> (     # Create the bot.)

[comment]: <> (     bot=Bot&#40;&#41;)

[comment]: <> (     ```)

[comment]: <> (3. This same function is also **attached** to a `portfolio` within the exchange. Each portfolio has access to each `currency` on the `exchange`. This means that each portfolio is independent from the other. **You can tell it which portfolio you want** by naming it in the `Keys.json` file and then declaring the `portfolio_name` argument to match the same name in `Keys.json`)

[comment]: <> (   - Documentation refers to this set of currencies as a `portfolio`)

[comment]: <> (   - ```python)

[comment]: <> (     # Add it to run as the coinbase_pro bitcoin model)

[comment]: <> (     exchange.append_model&#40;bot, "BTC-USD"&#41;)

[comment]: <> (     # Imagine this:)

[comment]: <> (     #   Coinbase Pro:)

[comment]: <> (     #       Bitcoin)

[comment]: <> (     #       Ethereum)

[comment]: <> (     #       Stellar)

[comment]: <> (     #       The Graph <-- Added to the data from this currency)

[comment]: <> (     ```)

[comment]: <> (4. The code above also **declares** the `currency` that we want it to run on within the `portfolio`. The bot is attached to this currency and is provided default ways to interact with the exchange.)

[comment]: <> (   - Documentation calls this the `currency`. Bots are by default **not** currency specific because this dramatically enhances portability.)

[comment]: <> (5. We then ask the model to start. By default this iterates through all the attached models and queries them to start but you can also specify a particular currency to begin executing the bot attached to it.)

[comment]: <> (   - ```python)

[comment]: <> (     # Begins running the main&#40;&#41; function of the model on a different process)

[comment]: <> (     exchange.start_models&#40;&#41;)

[comment]: <> (     # Imagine this:)

[comment]: <> (     #   Coinbase Pro:)

[comment]: <> (     #       Bitcoin)

[comment]: <> (     #       Ethereum)

[comment]: <> (     #       Stellar)

[comment]: <> (     #       The Graph <-- Bot <-- Asking to start)

[comment]: <> (     ```)

[comment]: <> (6. The bot then starts the main class. The example updates the "heartbeat" value every second. The main thread then reads this and prints it along with some exchange information about that currency.)

[comment]: <> (   - Some default, pre-authenticaed objects are provided to quick start interact with the exchange:)

[comment]: <> (     > self.Interface: allows API through the Blankly exchange interface. The interface object is already authenticated, so the calls are ready to go!)

[comment]: <> (     > self.Ticker_Manager: Allows easy access to a websocket ticker. The actual ticker object can be pulled by self.Ticker_Manager.get_ticker&#40;&#41;. This offers all kinds of functionality. See the docs for more information. By default this will be calling the `price_event` function.)

[comment]: <> (   - Main thread calling:)

[comment]: <> (   - ```python)

[comment]: <> (     # Now other processes can be created or just continue with this one.)

[comment]: <> (     while True:)

[comment]: <> (        # Print the state every 2 seconds)

[comment]: <> (        state = exchange.get_full_state&#40;"BTC-USD"&#41;)

[comment]: <> (        Blankly.utils.pretty_print_JSON&#40;state&#41;)

[comment]: <> (        time.sleep&#40;1&#41;)

[comment]: <> (     ```)

[comment]: <> (   - Bot state updates:)

[comment]: <> (   - ```python)

[comment]: <> (     while True:)

[comment]: <> (        # This demonstrates a way to change the state. The default script just reports the state on this currency.)

[comment]: <> (        # Increment heartbeat value by one every second)

[comment]: <> (        self.update_state&#40;"Heartbeat", self.get_state&#40;&#41;["Heartbeat"] + 1&#41;)

[comment]: <> (        time.sleep&#40;1&#41;)

[comment]: <> (     ```)

     

# Commands & Docs Overview

## Exchanges

| Exchange     | REST Support | Ticker Websocket | Order Book | Interface |
| ------------ | ------------ | ---------------- | ---------- | --------- |
| Coinbase Pro | 🟢           | 🟢               | 🟢        | 🟢        |
| Binance      | 🟢           | 🟢               | 🟢        | 🟡        |
| Alpaca       | 🟡           | 🔴               | 🔴        | 🟡        |

🟢 = working

🟡 = in development, some or most features are working

🔴 = planned but not yet in development

* Interface calls take ~300 µs extra to homogenize the exchange data.

## Docs
https://docs.blankly.finance

## Bugs

Please report any bugs or issues in Github's Issues page.

## Disclaimer 

Trading is risky. We are not responsible for losses incurred using this software, software fitness for any particular purpose, or responsibility for any issues or bugs.
This is free software.

## Contributing

If you would like to support the project, pull requests are welcome.
You can also contribute just by telling us what you think of Blankly: https://forms.gle/4oAjG9MKRTYKX2hP9

New updates every day 💪.
