# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Routine']


class Routine(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutineArgumentArgs']]]]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 definition_body: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 determinism_level: Optional[pulumi.Input[str]] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 return_type: Optional[pulumi.Input[str]] = None,
                 routine_id: Optional[pulumi.Input[str]] = None,
                 routine_type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A user-defined function or a stored procedure that belongs to a Dataset

        To get more information about Routine, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/rest/v2/routines)
        * How-to Guides
            * [Routines Intro](https://cloud.google.com/bigquery/docs/reference/rest/v2/routines)

        ## Example Usage
        ### Big Query Routine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="SQL",
            definition_body="CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);")
        ```

        ## Import

        Routine can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigquery/routine:Routine default projects/{{project}}/datasets/{{dataset_id}}/routines/{{routine_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/routine:Routine default {{project}}/{{dataset_id}}/{{routine_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/routine:Routine default {{dataset_id}}/{{routine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutineArgumentArgs']]]] arguments: Input/output argument of a function or a stored procedure.
               Structure is documented below.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this routine
        :param pulumi.Input[str] definition_body: The body of the routine. For functions, this is the expression in the AS clause.
               If language=SQL, it is the substring inside (but excluding) the parentheses.
        :param pulumi.Input[str] description: The description of the routine if defined.
        :param pulumi.Input[str] determinism_level: The determinism level of the JavaScript UDF if defined.
               Possible values are `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, and `NOT_DETERMINISTIC`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the
               imported JAVASCRIPT libraries.
        :param pulumi.Input[str] language: The language of the routine.
               Possible values are `SQL` and `JAVASCRIPT`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] return_type: A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
               If absent, the return type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the evaluated result will be cast to
               the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
               string, any changes to the string will create a diff, even if the JSON itself hasn't
               changed. If the API returns a different value for the same schema, e.g. it switche
               d the order of values or replaced STRUCT field type with RECORD field type, we currently
               cannot suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param pulumi.Input[str] routine_id: The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param pulumi.Input[str] routine_type: The type of routine.
               Possible values are `SCALAR_FUNCTION` and `PROCEDURE`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['arguments'] = arguments
            if dataset_id is None:
                raise TypeError("Missing required property 'dataset_id'")
            __props__['dataset_id'] = dataset_id
            if definition_body is None:
                raise TypeError("Missing required property 'definition_body'")
            __props__['definition_body'] = definition_body
            __props__['description'] = description
            __props__['determinism_level'] = determinism_level
            __props__['imported_libraries'] = imported_libraries
            __props__['language'] = language
            __props__['project'] = project
            __props__['return_type'] = return_type
            if routine_id is None:
                raise TypeError("Missing required property 'routine_id'")
            __props__['routine_id'] = routine_id
            __props__['routine_type'] = routine_type
            __props__['creation_time'] = None
            __props__['last_modified_time'] = None
        super(Routine, __self__).__init__(
            'gcp:bigquery/routine:Routine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arguments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutineArgumentArgs']]]]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            dataset_id: Optional[pulumi.Input[str]] = None,
            definition_body: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            determinism_level: Optional[pulumi.Input[str]] = None,
            imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            language: Optional[pulumi.Input[str]] = None,
            last_modified_time: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            return_type: Optional[pulumi.Input[str]] = None,
            routine_id: Optional[pulumi.Input[str]] = None,
            routine_type: Optional[pulumi.Input[str]] = None) -> 'Routine':
        """
        Get an existing Routine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutineArgumentArgs']]]] arguments: Input/output argument of a function or a stored procedure.
               Structure is documented below.
        :param pulumi.Input[int] creation_time: The time when this routine was created, in milliseconds since the epoch.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this routine
        :param pulumi.Input[str] definition_body: The body of the routine. For functions, this is the expression in the AS clause.
               If language=SQL, it is the substring inside (but excluding) the parentheses.
        :param pulumi.Input[str] description: The description of the routine if defined.
        :param pulumi.Input[str] determinism_level: The determinism level of the JavaScript UDF if defined.
               Possible values are `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, and `NOT_DETERMINISTIC`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the
               imported JAVASCRIPT libraries.
        :param pulumi.Input[str] language: The language of the routine.
               Possible values are `SQL` and `JAVASCRIPT`.
        :param pulumi.Input[int] last_modified_time: The time when this routine was modified, in milliseconds since the epoch.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] return_type: A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
               If absent, the return type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the evaluated result will be cast to
               the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
               string, any changes to the string will create a diff, even if the JSON itself hasn't
               changed. If the API returns a different value for the same schema, e.g. it switche
               d the order of values or replaced STRUCT field type with RECORD field type, we currently
               cannot suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param pulumi.Input[str] routine_id: The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param pulumi.Input[str] routine_type: The type of routine.
               Possible values are `SCALAR_FUNCTION` and `PROCEDURE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["arguments"] = arguments
        __props__["creation_time"] = creation_time
        __props__["dataset_id"] = dataset_id
        __props__["definition_body"] = definition_body
        __props__["description"] = description
        __props__["determinism_level"] = determinism_level
        __props__["imported_libraries"] = imported_libraries
        __props__["language"] = language
        __props__["last_modified_time"] = last_modified_time
        __props__["project"] = project
        __props__["return_type"] = return_type
        __props__["routine_id"] = routine_id
        __props__["routine_type"] = routine_type
        return Routine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arguments(self) -> pulumi.Output[Optional[Sequence['outputs.RoutineArgument']]]:
        """
        Input/output argument of a function or a stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        The time when this routine was created, in milliseconds since the epoch.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[str]:
        """
        The ID of the dataset containing this routine
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> pulumi.Output[str]:
        """
        The body of the routine. For functions, this is the expression in the AS clause.
        If language=SQL, it is the substring inside (but excluding) the parentheses.
        """
        return pulumi.get(self, "definition_body")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the routine if defined.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="determinismLevel")
    def determinism_level(self) -> pulumi.Output[Optional[str]]:
        """
        The determinism level of the JavaScript UDF if defined.
        Possible values are `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, and `NOT_DETERMINISTIC`.
        """
        return pulumi.get(self, "determinism_level")

    @property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Optional. If language = "JAVASCRIPT", this field stores the path of the
        imported JAVASCRIPT libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[str]]:
        """
        The language of the routine.
        Possible values are `SQL` and `JAVASCRIPT`.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[int]:
        """
        The time when this routine was modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
        If absent, the return type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the evaluated result will be cast to
        the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
        string, any changes to the string will create a diff, even if the JSON itself hasn't
        changed. If the API returns a different value for the same schema, e.g. it switche
        d the order of values or replaced STRUCT field type with RECORD field type, we currently
        cannot suppress the recurring diff this causes. As a workaround, we recommend using
        the schema as returned by the API.
        """
        return pulumi.get(self, "return_type")

    @property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> pulumi.Output[str]:
        """
        The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "routine_id")

    @property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of routine.
        Possible values are `SCALAR_FUNCTION` and `PROCEDURE`.
        """
        return pulumi.get(self, "routine_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

