# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['MachineImage']


class MachineImage(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 guest_flush: Optional[pulumi.Input[bool]] = None,
                 machine_image_encryption_key: Optional[pulumi.Input[pulumi.InputType['MachineImageMachineImageEncryptionKeyArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_instance: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Represents a Machine Image resource. Machine images store all the configuration,
        metadata, permissions, and data from one or more disks required to create a
        Virtual machine (VM) instance.

        To get more information about MachineImage, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/machineImages)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/machine-images)

        ## Example Usage
        ### Machine Image Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vm = gcp.compute.Instance("vm",
            machine_type="e2-medium",
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-9",
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network="default",
            )],
            opts=ResourceOptions(provider=google_beta))
        image = gcp.compute.MachineImage("image", source_instance=vm.self_link,
        opts=ResourceOptions(provider=google_beta))
        ```

        ## Import

        MachineImage can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/machineImage:MachineImage default projects/{{project}}/global/machineImages/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/machineImage:MachineImage default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/machineImage:MachineImage default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text description of the resource.
        :param pulumi.Input[bool] guest_flush: Specify this to create an application consistent machine image by informing the OS to prepare for the snapshot process.
               Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
        :param pulumi.Input[pulumi.InputType['MachineImageMachineImageEncryptionKeyArgs']] machine_image_encryption_key: Encrypts the machine image using a customer-supplied encryption key.
               After you encrypt a machine image with a customer-supplied key, you must
               provide the same key if you use the machine image later (e.g. to create a
               instance from the image)
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] source_instance: The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['guest_flush'] = guest_flush
            __props__['machine_image_encryption_key'] = machine_image_encryption_key
            __props__['name'] = name
            __props__['project'] = project
            if source_instance is None:
                raise TypeError("Missing required property 'source_instance'")
            __props__['source_instance'] = source_instance
            __props__['self_link'] = None
            __props__['storage_locations'] = None
        super(MachineImage, __self__).__init__(
            'gcp:compute/machineImage:MachineImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            guest_flush: Optional[pulumi.Input[bool]] = None,
            machine_image_encryption_key: Optional[pulumi.Input[pulumi.InputType['MachineImageMachineImageEncryptionKeyArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            source_instance: Optional[pulumi.Input[str]] = None,
            storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'MachineImage':
        """
        Get an existing MachineImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text description of the resource.
        :param pulumi.Input[bool] guest_flush: Specify this to create an application consistent machine image by informing the OS to prepare for the snapshot process.
               Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
        :param pulumi.Input[pulumi.InputType['MachineImageMachineImageEncryptionKeyArgs']] machine_image_encryption_key: Encrypts the machine image using a customer-supplied encryption key.
               After you encrypt a machine image with a customer-supplied key, you must
               provide the same key if you use the machine image later (e.g. to create a
               instance from the image)
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] source_instance: The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_locations: The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["guest_flush"] = guest_flush
        __props__["machine_image_encryption_key"] = machine_image_encryption_key
        __props__["name"] = name
        __props__["project"] = project
        __props__["self_link"] = self_link
        __props__["source_instance"] = source_instance
        __props__["storage_locations"] = storage_locations
        return MachineImage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="guestFlush")
    def guest_flush(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify this to create an application consistent machine image by informing the OS to prepare for the snapshot process.
        Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
        """
        return pulumi.get(self, "guest_flush")

    @property
    @pulumi.getter(name="machineImageEncryptionKey")
    def machine_image_encryption_key(self) -> pulumi.Output[Optional['outputs.MachineImageMachineImageEncryptionKey']]:
        """
        Encrypts the machine image using a customer-supplied encryption key.
        After you encrypt a machine image with a customer-supplied key, you must
        provide the same key if you use the machine image later (e.g. to create a
        instance from the image)
        Structure is documented below.
        """
        return pulumi.get(self, "machine_image_encryption_key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sourceInstance")
    def source_instance(self) -> pulumi.Output[str]:
        """
        The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
        """
        return pulumi.get(self, "source_instance")

    @property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> pulumi.Output[Sequence[str]]:
        """
        The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
        """
        return pulumi.get(self, "storage_locations")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

