# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['EngineModel']


class EngineModel(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_version: Optional[pulumi.Input[pulumi.InputType['EngineModelDefaultVersionArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 online_prediction_console_logging: Optional[pulumi.Input[bool]] = None,
                 online_prediction_logging: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 regions: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Represents a machine learning solution.

        A model can have multiple versions, each of which is a deployed, trained model
        ready to receive prediction requests. The model itself is just a container.

        ## Example Usage
        ### Ml Model Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.ml.EngineModel("default",
            description="My model",
            regions="us-central1")
        ```
        ### Ml Model Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.ml.EngineModel("default",
            description="My model",
            labels={
                "my_model": "foo",
            },
            online_prediction_console_logging=True,
            online_prediction_logging=True,
            regions="us-central1")
        ```

        ## Import

        Model can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:ml/engineModel:EngineModel default projects/{{project}}/models/{{name}}
        ```

        ```sh
         $ pulumi import gcp:ml/engineModel:EngineModel default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:ml/engineModel:EngineModel default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EngineModelDefaultVersionArgs']] default_version: The default version of the model. This version will be used to handle
               prediction requests that do not specify a version.
               Structure is documented below.
        :param pulumi.Input[str] description: The description specified for the model when it was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: One or more labels that you can add, to organize your models.
        :param pulumi.Input[str] name: The name specified for the version when it was created.
        :param pulumi.Input[bool] online_prediction_console_logging: If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        :param pulumi.Input[bool] online_prediction_logging: If true, online prediction access logs are sent to StackDriver Logging.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] regions: The list of regions where the model is going to be deployed.
               Currently only one region per model is supported
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['default_version'] = default_version
            __props__['description'] = description
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['online_prediction_console_logging'] = online_prediction_console_logging
            __props__['online_prediction_logging'] = online_prediction_logging
            __props__['project'] = project
            __props__['regions'] = regions
        super(EngineModel, __self__).__init__(
            'gcp:ml/engineModel:EngineModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_version: Optional[pulumi.Input[pulumi.InputType['EngineModelDefaultVersionArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            online_prediction_console_logging: Optional[pulumi.Input[bool]] = None,
            online_prediction_logging: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            regions: Optional[pulumi.Input[str]] = None) -> 'EngineModel':
        """
        Get an existing EngineModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EngineModelDefaultVersionArgs']] default_version: The default version of the model. This version will be used to handle
               prediction requests that do not specify a version.
               Structure is documented below.
        :param pulumi.Input[str] description: The description specified for the model when it was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: One or more labels that you can add, to organize your models.
        :param pulumi.Input[str] name: The name specified for the version when it was created.
        :param pulumi.Input[bool] online_prediction_console_logging: If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        :param pulumi.Input[bool] online_prediction_logging: If true, online prediction access logs are sent to StackDriver Logging.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] regions: The list of regions where the model is going to be deployed.
               Currently only one region per model is supported
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["default_version"] = default_version
        __props__["description"] = description
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["online_prediction_console_logging"] = online_prediction_console_logging
        __props__["online_prediction_logging"] = online_prediction_logging
        __props__["project"] = project
        __props__["regions"] = regions
        return EngineModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> pulumi.Output[Optional['outputs.EngineModelDefaultVersion']]:
        """
        The default version of the model. This version will be used to handle
        prediction requests that do not specify a version.
        Structure is documented below.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description specified for the model when it was created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        One or more labels that you can add, to organize your models.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name specified for the version when it was created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onlinePredictionConsoleLogging")
    def online_prediction_console_logging(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        """
        return pulumi.get(self, "online_prediction_console_logging")

    @property
    @pulumi.getter(name="onlinePredictionLogging")
    def online_prediction_logging(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, online prediction access logs are sent to StackDriver Logging.
        """
        return pulumi.get(self, "online_prediction_logging")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Optional[str]]:
        """
        The list of regions where the model is going to be deployed.
        Currently only one region per model is supported
        """
        return pulumi.get(self, "regions")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

