# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Project']


class Project(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_network: Optional[pulumi.Input[bool]] = None,
                 billing_account: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 skip_delete: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Allows creation and management of a Google Cloud Platform project.

        Projects created with this resource must be associated with an Organization.
        See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.

        The service account used to run this provider when creating a `organizations.Project`
        resource must have `roles/resourcemanager.projectCreator`. See the
        [Access Control for Organizations Using IAM](https://cloud.google.com/resource-manager/docs/access-control-org)
        doc for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("myProject",
            org_id="1234567",
            project_id="your-project-id")
        ```

        To create a project under a specific folder

        ```python
        import pulumi
        import pulumi_gcp as gcp

        department1 = gcp.organizations.Folder("department1",
            display_name="Department 1",
            parent="organizations/1234567")
        my_project_in_a_folder = gcp.organizations.Project("myProject-in-a-folder",
            project_id="your-project-id",
            folder_id=department1.name)
        ```

        ## Import

        Projects can be imported using the `project_id`, e.g.

        ```sh
         $ pulumi import gcp:organizations/project:Project my_project your-project-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_network: Create the 'default' network automatically.  Default `true`.
               If set to `false`, the default network will be deleted.  Note that, for quota purposes, you
               will still need to have 1 network slot available to create the project successfully, even if
               you set `auto_create_network` to `false`, since the network will exist momentarily.
        :param pulumi.Input[str] billing_account: The alphanumeric ID of the billing account this project
               belongs to. The user or service account performing this operation with the provider
               must have Billing Account Administrator privileges (`roles/billing.admin`) in
               the organization. See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/v1/how-tos/access-control)
               for more details.
        :param pulumi.Input[str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the project.
        :param pulumi.Input[str] name: The display name of the project.
        :param pulumi.Input[str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[str] project_id: The project ID. Changing this forces a new project to be created.
        :param pulumi.Input[bool] skip_delete: If true, the resource can be deleted
               without deleting the Project via the Google API.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['auto_create_network'] = auto_create_network
            __props__['billing_account'] = billing_account
            __props__['folder_id'] = folder_id
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['org_id'] = org_id
            if project_id is None:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['skip_delete'] = skip_delete
            __props__['number'] = None
        super(Project, __self__).__init__(
            'gcp:organizations/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create_network: Optional[pulumi.Input[bool]] = None,
            billing_account: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            skip_delete: Optional[pulumi.Input[bool]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_network: Create the 'default' network automatically.  Default `true`.
               If set to `false`, the default network will be deleted.  Note that, for quota purposes, you
               will still need to have 1 network slot available to create the project successfully, even if
               you set `auto_create_network` to `false`, since the network will exist momentarily.
        :param pulumi.Input[str] billing_account: The alphanumeric ID of the billing account this project
               belongs to. The user or service account performing this operation with the provider
               must have Billing Account Administrator privileges (`roles/billing.admin`) in
               the organization. See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/v1/how-tos/access-control)
               for more details.
        :param pulumi.Input[str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the project.
        :param pulumi.Input[str] name: The display name of the project.
        :param pulumi.Input[str] number: The numeric identifier of the project.
        :param pulumi.Input[str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[str] project_id: The project ID. Changing this forces a new project to be created.
        :param pulumi.Input[bool] skip_delete: If true, the resource can be deleted
               without deleting the Project via the Google API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["auto_create_network"] = auto_create_network
        __props__["billing_account"] = billing_account
        __props__["folder_id"] = folder_id
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["number"] = number
        __props__["org_id"] = org_id
        __props__["project_id"] = project_id
        __props__["skip_delete"] = skip_delete
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoCreateNetwork")
    def auto_create_network(self) -> pulumi.Output[Optional[bool]]:
        """
        Create the 'default' network automatically.  Default `true`.
        If set to `false`, the default network will be deleted.  Note that, for quota purposes, you
        will still need to have 1 network slot available to create the project successfully, even if
        you set `auto_create_network` to `false`, since the network will exist momentarily.
        """
        return pulumi.get(self, "auto_create_network")

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> pulumi.Output[Optional[str]]:
        """
        The alphanumeric ID of the billing account this project
        belongs to. The user or service account performing this operation with the provider
        must have Billing Account Administrator privileges (`roles/billing.admin`) in
        the organization. See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/v1/how-tos/access-control)
        for more details.
        """
        return pulumi.get(self, "billing_account")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The numeric ID of the folder this project should be
        created under. Only one of `org_id` or `folder_id` may be
        specified. If the `folder_id` is specified, then the project is
        created under the specified folder. Changing this forces the
        project to be migrated to the newly specified folder.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the project.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The display name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[str]:
        """
        The numeric identifier of the project.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        The numeric ID of the organization this project belongs to.
        Changing this forces a new project to be created.  Only one of
        `org_id` or `folder_id` may be specified. If the `org_id` is
        specified then the project is created at the top level. Changing
        this forces the project to be migrated to the newly specified
        organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project ID. Changing this forces a new project to be created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="skipDelete")
    def skip_delete(self) -> pulumi.Output[bool]:
        """
        If true, the resource can be deleted
        without deleting the Project via the Google API.
        """
        return pulumi.get(self, "skip_delete")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

