# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'DatabaseInstanceIpAddressArgs',
    'DatabaseInstanceReplicaConfigurationArgs',
    'DatabaseInstanceServerCaCertArgs',
    'DatabaseInstanceSettingsArgs',
    'DatabaseInstanceSettingsBackupConfigurationArgs',
    'DatabaseInstanceSettingsDatabaseFlagArgs',
    'DatabaseInstanceSettingsIpConfigurationArgs',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs',
    'DatabaseInstanceSettingsLocationPreferenceArgs',
    'DatabaseInstanceSettingsMaintenanceWindowArgs',
]

@pulumi.input_type
class DatabaseInstanceIpAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 time_to_retire: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_to_retire")

    @time_to_retire.setter
    def time_to_retire(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_retire", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DatabaseInstanceReplicaConfigurationArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 connect_retry_interval: Optional[pulumi.Input[int]] = None,
                 dump_file_path: Optional[pulumi.Input[str]] = None,
                 failover_target: Optional[pulumi.Input[bool]] = None,
                 master_heartbeat_period: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 ssl_cipher: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 verify_server_certificate: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param pulumi.Input[str] client_certificate: PEM representation of the slave's x509
               certificate.
        :param pulumi.Input[str] client_key: PEM representation of the slave's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param pulumi.Input[int] connect_retry_interval: The number of seconds
               between connect retries.
        :param pulumi.Input[str] dump_file_path: Path to a SQL file in GCS from which slave
               instances are created. Format is `gs://bucket/filename`.
        :param pulumi.Input[bool] failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
        :param pulumi.Input[int] master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param pulumi.Input[str] password: Password for the replication connection.
        :param pulumi.Input[str] username: Username for replication connection.
        :param pulumi.Input[bool] verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the slave's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the slave's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds
        between connect retries.
        """
        return pulumi.get(self, "connect_retry_interval")

    @connect_retry_interval.setter
    def connect_retry_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_retry_interval", value)

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a SQL file in GCS from which slave
        instances are created. Format is `gs://bucket/filename`.
        """
        return pulumi.get(self, "dump_file_path")

    @dump_file_path.setter
    def dump_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dump_file_path", value)

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        """
        return pulumi.get(self, "failover_target")

    @failover_target.setter
    def failover_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failover_target", value)

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[pulumi.Input[int]]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @master_heartbeat_period.setter
    def master_heartbeat_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_heartbeat_period", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssl_cipher")

    @ssl_cipher.setter
    def ssl_cipher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cipher", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")

    @verify_server_certificate.setter
    def verify_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_server_certificate", value)


@pulumi.input_type
class DatabaseInstanceServerCaCertArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 sha1_fingerprint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sha1_fingerprint")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha1_fingerprint", value)


@pulumi.input_type
class DatabaseInstanceSettingsArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[str],
                 activation_policy: Optional[pulumi.Input[str]] = None,
                 authorized_gae_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 backup_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']] = None,
                 crash_safe_replication: Optional[pulumi.Input[bool]] = None,
                 database_flags: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]] = None,
                 disk_autoresize: Optional[pulumi.Input[bool]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 ip_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']] = None,
                 location_preference: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']] = None,
                 pricing_plan: Optional[pulumi.Input[str]] = None,
                 replication_type: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param pulumi.Input[str] activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_gae_applications: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               A list of Google App Engine (GAE) project names that are allowed to access this instance.
        :param pulumi.Input[str] availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For MySQL
               instances, ensure that `settings.backup_configuration.enabled` and
               `settings.backup_configuration.binary_log_enabled` are both set to `true`.
        :param pulumi.Input[bool] crash_safe_replication: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               Specific to read instances, indicates
               when crash-safe replication flags are enabled.
        :param pulumi.Input[bool] disk_autoresize: Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
        :param pulumi.Input[int] disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
        :param pulumi.Input[str] disk_type: The type of data disk: PD_SSD or PD_HDD.
        :param pulumi.Input[str] pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param pulumi.Input[str] replication_type: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if authorized_gae_applications is not None:
            warnings.warn("""This property is only applicable to First Generation instances, and First Generation instances are now deprecated.""", DeprecationWarning)
            pulumi.log.warn("authorized_gae_applications is deprecated: This property is only applicable to First Generation instances, and First Generation instances are now deprecated.")
        if authorized_gae_applications is not None:
            pulumi.set(__self__, "authorized_gae_applications", authorized_gae_applications)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if crash_safe_replication is not None:
            warnings.warn("""This property is only applicable to First Generation instances, and First Generation instances are now deprecated.""", DeprecationWarning)
            pulumi.log.warn("crash_safe_replication is deprecated: This property is only applicable to First Generation instances, and First Generation instances are now deprecated.")
        if crash_safe_replication is not None:
            pulumi.set(__self__, "crash_safe_replication", crash_safe_replication)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if replication_type is not None:
            warnings.warn("""This property is only applicable to First Generation instances, and First Generation instances are now deprecated.""", DeprecationWarning)
            pulumi.log.warn("replication_type is deprecated: This property is only applicable to First Generation instances, and First Generation instances are now deprecated.")
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[str]:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="authorizedGaeApplications")
    def authorized_gae_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        A list of Google App Engine (GAE) project names that are allowed to access this instance.
        """
        return pulumi.get(self, "authorized_gae_applications")

    @authorized_gae_applications.setter
    def authorized_gae_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_gae_applications", value)

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[str]]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For MySQL
        instances, ensure that `settings.backup_configuration.enabled` and
        `settings.backup_configuration.binary_log_enabled` are both set to `true`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]:
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter(name="crashSafeReplication")
    def crash_safe_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        Specific to read instances, indicates
        when crash-safe replication flags are enabled.
        """
        return pulumi.get(self, "crash_safe_replication")

    @crash_safe_replication.setter
    def crash_safe_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "crash_safe_replication", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]:
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[pulumi.Input[bool]]:
        """
        Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @disk_autoresize.setter
    def disk_autoresize(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk_autoresize", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of data disk: PD_SSD or PD_HDD.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]:
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]:
        return pulumi.get(self, "location_preference")

    @location_preference.setter
    def location_preference(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]):
        pulumi.set(self, "location_preference", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input[str]]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_plan", value)

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_type", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationArgs:
    def __init__(__self__, *,
                 binary_log_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] binary_log_enabled: True if binary logging is enabled. If
               `settings.backup_configuration.enabled` is false, this must be as well.
               Cannot be used with Postgres.
        :param pulumi.Input[bool] enabled: True if backup configuration is enabled.
        :param pulumi.Input[bool] point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL instances.
        :param pulumi.Input[str] start_time: `HH:MM` format time indicating when backup
               configuration starts.
        """
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if binary logging is enabled. If
        `settings.backup_configuration.enabled` is false, this must be as well.
        Cannot be used with Postgres.
        """
        return pulumi.get(self, "binary_log_enabled")

    @binary_log_enabled.setter
    def binary_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "binary_log_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @point_in_time_recovery_enabled.setter
    def point_in_time_recovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "point_in_time_recovery_enabled", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class DatabaseInstanceSettingsDatabaseFlagArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: A name for this whitelist entry.
        :param pulumi.Input[str] value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationArgs:
    def __init__(__self__, *,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]] = None,
                 ipv4_enabled: Optional[pulumi.Input[bool]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. Either `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param pulumi.Input[str] private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[bool] require_ssl: Whether SSL connections over IP are enforced or not.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]:
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. Either `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)


@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param pulumi.Input[str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param pulumi.Input[str] name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DatabaseInstanceSettingsLocationPreferenceArgs:
    def __init__(__self__, *,
                 follow_gae_application: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param pulumi.Input[str] zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[pulumi.Input[str]]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @follow_gae_application.setter
    def follow_gae_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "follow_gae_application", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DatabaseInstanceSettingsMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 update_track: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] day: Day of week (`1-7`), starting on Monday
        :param pulumi.Input[int] hour: Hour of day (`0-23`), ignored if `day` not set
        :param pulumi.Input[str] update_track: Receive updates earlier (`canary`) or later
               (`stable`)
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[pulumi.Input[str]]:
        """
        Receive updates earlier (`canary`) or later
        (`stable`)
        """
        return pulumi.get(self, "update_track")

    @update_track.setter
    def update_track(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_track", value)


